/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.common.enums;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shenyu.common.exception.ShenyuException;

public enum OperatorEnum {
    MATCH("match", true),
    EQ("=", true),
    REGEX("regex", true),
    GT(">", false),
    LT("<", false),
    CONTAINS("contains", true),
    SPEL("SpEL", true),
    GROOVY("Groovy", true),
    TIME_BEFORE("TimeBefore", true),
    TIME_AFTER("TimeAfter", true);

    private final String alias;
    private final Boolean support;

    public static List<OperatorEnum> acquireSupport() {
        return Arrays.stream(OperatorEnum.values()).filter(e -> e.support).collect(Collectors.toList());
    }

    public static OperatorEnum getOperatorEnumByAlias(String alias) {
        return Arrays.stream(OperatorEnum.values()).filter(e -> e.getAlias().equals(alias) && e.support != false).findFirst().orElseThrow(() -> new ShenyuException(String.format(" this  operator can not support %s ", alias)));
    }

    @Generated
    private OperatorEnum(String alias, Boolean support) {
        this.alias = alias;
        this.support = support;
    }

    @Generated
    public String getAlias() {
        return this.alias;
    }

    @Generated
    public Boolean getSupport() {
        return this.support;
    }
}

