/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.common.enums;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shenyu.common.exception.ShenyuException;

public enum ParamTypeEnum {
    PATH("path", true),
    FORM_DATA("form-data", true),
    POST("post", true),
    URI("uri", true),
    QUERY("query", true),
    HOST("host", true),
    IP("ip", true),
    HEADER("header", true),
    COOKIE("cookie", true),
    REQUEST_METHOD("req_method", true);

    private final String name;
    private final Boolean support;

    public static List<ParamTypeEnum> acquireSupport() {
        return Arrays.stream(ParamTypeEnum.values()).filter(e -> e.support).collect(Collectors.toList());
    }

    public static ParamTypeEnum getParamTypeEnumByName(String name) {
        return Arrays.stream(ParamTypeEnum.values()).filter(e -> e.getName().equals(name) && e.support != false).findFirst().orElseThrow(() -> new ShenyuException(String.format(" this  param type can not support %s", name)));
    }

    @Generated
    private ParamTypeEnum(String name, Boolean support) {
        this.name = name;
        this.support = support;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Boolean getSupport() {
        return this.support;
    }
}

