/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.common.utils;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReflectUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ReflectUtils.class);

    public static Field getField(Class<?> beanClass, String name) throws SecurityException {
        Field[] fields = beanClass.getDeclaredFields();
        if (fields.length != 0) {
            for (Field field : fields) {
                if (!name.equals(field.getName())) continue;
                return field;
            }
        }
        return null;
    }

    public static Object getFieldValue(Object obj, String fieldName) {
        if (null == obj || StringUtils.isBlank((CharSequence)fieldName)) {
            return null;
        }
        return ReflectUtils.getFieldValue(obj, ReflectUtils.getField(obj.getClass(), fieldName));
    }

    public static Object getFieldValue(Object obj, Field field) {
        if (null == obj || null == field) {
            return null;
        }
        field.setAccessible(true);
        Object result = null;
        try {
            result = field.get(obj);
        }
        catch (IllegalAccessException e) {
            log.error("", (Throwable)e);
        }
        return result;
    }

    public static Object invokeMethod(Class<?> clazz, String method) {
        try {
            Method m = ReflectUtils.findMethod(clazz, method);
            return m.invoke(null, new Object[0]);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            return null;
        }
    }

    public static Method findMethod(Class<?> clazz, String method) {
        try {
            return clazz.getMethod(method, new Class[0]);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            return null;
        }
    }
}

