/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.common.concurrent;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;

public class MemoryLimitCalculator {
    private static final MemoryMXBean MX_BEAN = ManagementFactory.getMemoryMXBean();

    public static long maxAvailable() {
        MemoryUsage usage = MX_BEAN.getHeapMemoryUsage();
        return usage.getCommitted();
    }

    public static long calculate(float percentage) {
        if (percentage <= 0.0f || percentage > 1.0f) {
            throw new IllegalArgumentException();
        }
        return (long)((float)MemoryLimitCalculator.maxAvailable() * percentage);
    }

    public static long defaultLimit() {
        return (long)((double)MemoryLimitCalculator.maxAvailable() * 0.8);
    }
}

