/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.common.concurrent;

import java.lang.instrument.Instrumentation;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.LongAdder;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

public class MemoryLimiter {
    private final Instrumentation inst;
    private long memoryLimit;
    private final LongAdder memory = new LongAdder();
    private final ReentrantLock acquireLock = new ReentrantLock();
    private final Condition notLimited = this.acquireLock.newCondition();
    private final ReentrantLock releaseLock = new ReentrantLock();
    private final Condition notEmpty = this.releaseLock.newCondition();

    public MemoryLimiter(Instrumentation inst) {
        this(Integer.MAX_VALUE, inst);
    }

    public MemoryLimiter(long memoryLimit, Instrumentation inst) {
        if (memoryLimit <= 0L) {
            throw new IllegalArgumentException();
        }
        this.memoryLimit = memoryLimit;
        this.inst = inst;
    }

    public void setMemoryLimit(long memoryLimit) {
        if (memoryLimit <= 0L) {
            throw new IllegalArgumentException();
        }
        this.memoryLimit = memoryLimit;
    }

    public long getMemoryLimit() {
        return this.memoryLimit;
    }

    public long getCurrentMemory() {
        return this.memory.sum();
    }

    public long getCurrentRemainMemory() {
        return this.getMemoryLimit() - this.getCurrentMemory();
    }

    private void signalNotEmpty() {
        this.releaseLock.lock();
        try {
            this.notEmpty.signal();
        }
        finally {
            this.releaseLock.unlock();
        }
    }

    private void signalNotLimited() {
        this.acquireLock.lock();
        try {
            this.notLimited.signal();
        }
        finally {
            this.acquireLock.unlock();
        }
    }

    private void fullyLock() {
        this.acquireLock.lock();
        this.releaseLock.lock();
    }

    private void fullyUnlock() {
        this.releaseLock.unlock();
        this.acquireLock.unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean acquire(Object o) {
        if (o == null) {
            throw new NullPointerException();
        }
        if (this.memory.sum() >= this.memoryLimit) {
            return false;
        }
        this.acquireLock.lock();
        try {
            long sum = this.memory.sum();
            long objectSize = this.inst.getObjectSize(o);
            if (sum + objectSize >= this.memoryLimit) {
                boolean bl = false;
                return bl;
            }
            this.memory.add(objectSize);
            if (sum < this.memoryLimit) {
                this.notLimited.signal();
            }
        }
        finally {
            this.acquireLock.unlock();
        }
        if (this.memory.sum() > 0L) {
            this.signalNotEmpty();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean acquire(Object o, long timeout, TimeUnit unit) throws InterruptedException {
        if (o == null) {
            throw new NullPointerException();
        }
        long nanos = unit.toNanos(timeout);
        this.acquireLock.lockInterruptibly();
        try {
            long objectSize = this.inst.getObjectSize(o);
            while (this.memory.sum() + objectSize >= this.memoryLimit) {
                if (nanos <= 0L) {
                    boolean bl = false;
                    return bl;
                }
                nanos = this.notLimited.awaitNanos(nanos);
            }
            this.memory.add(objectSize);
            if (this.memory.sum() < this.memoryLimit) {
                this.notLimited.signal();
            }
        }
        finally {
            this.acquireLock.unlock();
        }
        if (this.memory.sum() > 0L) {
            this.signalNotEmpty();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acquireInterruptibly(Object o) throws InterruptedException {
        if (o == null) {
            throw new NullPointerException();
        }
        this.acquireLock.lockInterruptibly();
        try {
            long sum = this.memory.sum();
            long objectSize = this.inst.getObjectSize(o);
            while (sum + objectSize >= this.memoryLimit) {
                this.notLimited.await();
            }
            this.memory.add(objectSize);
            if (sum < this.memoryLimit) {
                this.notLimited.signal();
            }
        }
        finally {
            this.acquireLock.unlock();
        }
        if (this.memory.sum() > 0L) {
            this.signalNotEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(Object o) {
        if (null == o) {
            return;
        }
        if (this.memory.sum() == 0L) {
            return;
        }
        this.releaseLock.lock();
        try {
            long objectSize = this.inst.getObjectSize(o);
            if (this.memory.sum() > 0L) {
                this.memory.add(-objectSize);
                if (this.memory.sum() > 0L) {
                    this.notEmpty.signal();
                }
            }
        }
        finally {
            this.releaseLock.unlock();
        }
        if (this.memory.sum() < this.memoryLimit) {
            this.signalNotLimited();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseInterruptibly(Object o) throws InterruptedException {
        if (null == o) {
            return;
        }
        this.releaseLock.lockInterruptibly();
        try {
            long objectSize = this.inst.getObjectSize(o);
            while (this.memory.sum() == 0L) {
                this.notEmpty.await();
            }
            this.memory.add(-objectSize);
            if (this.memory.sum() > 0L) {
                this.notEmpty.signal();
            }
        }
        finally {
            this.releaseLock.unlock();
        }
        if (this.memory.sum() < this.memoryLimit) {
            this.signalNotLimited();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseInterruptibly(Object o, long timeout, TimeUnit unit) throws InterruptedException {
        if (null == o) {
            return;
        }
        long nanos = unit.toNanos(timeout);
        this.releaseLock.lockInterruptibly();
        try {
            long objectSize = this.inst.getObjectSize(o);
            while (this.memory.sum() == 0L) {
                if (nanos <= 0L) {
                    return;
                }
                nanos = this.notEmpty.awaitNanos(nanos);
            }
            this.memory.add(-objectSize);
            if (this.memory.sum() > 0L) {
                this.notEmpty.signal();
            }
        }
        finally {
            this.releaseLock.unlock();
        }
        if (this.memory.sum() < this.memoryLimit) {
            this.signalNotLimited();
        }
    }

    public void reset() {
        this.fullyLock();
        try {
            if (this.memory.sumThenReset() < this.memoryLimit) {
                this.notLimited.signal();
            }
        }
        finally {
            this.fullyUnlock();
        }
    }
}

