/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.common.config;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.shenyu.common.concurrent.MemoryLimitCalculator;
import org.springframework.util.StringUtils;

public class ShenyuConfig {
    private SwitchConfig switchConfig = new SwitchConfig();
    private FileConfig file = new FileConfig();
    private ExcludePath exclude = new ExcludePath();
    private FallbackPath fallback = new FallbackPath();
    private ExtPlugin extPlugin = new ExtPlugin();
    private Scheduler scheduler = new Scheduler();
    private UpstreamCheck upstreamCheck = new UpstreamCheck();
    private CrossFilterConfig cross = new CrossFilterConfig();
    private InstanceConfig instance = new InstanceConfig();
    private RibbonConfig ribbon = new RibbonConfig();
    private Local local = new Local();
    private WebsocketConfig websocket = new WebsocketConfig();
    private SharedPool sharedPool = new SharedPool();
    private MetricsConfig metrics = new MetricsConfig();

    public MetricsConfig getMetrics() {
        return this.metrics;
    }

    public void setMetrics(MetricsConfig metrics) {
        this.metrics = metrics;
    }

    public SharedPool getSharedPool() {
        return this.sharedPool;
    }

    public void setSharedPool(SharedPool sharedPool) {
        this.sharedPool = sharedPool;
    }

    public Local getLocal() {
        return this.local;
    }

    public void setLocal(Local local) {
        this.local = local;
    }

    public RibbonConfig getRibbon() {
        return this.ribbon;
    }

    public void setRibbon(RibbonConfig ribbon) {
        this.ribbon = ribbon;
    }

    public InstanceConfig getInstance() {
        return this.instance;
    }

    public void setInstance(InstanceConfig instance) {
        this.instance = instance;
    }

    public SwitchConfig getSwitchConfig() {
        return this.switchConfig;
    }

    public void setSwitchConfig(SwitchConfig switchConfig) {
        this.switchConfig = switchConfig;
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    public void setScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    public ExtPlugin getExtPlugin() {
        return this.extPlugin;
    }

    public void setExtPlugin(ExtPlugin extPlugin) {
        this.extPlugin = extPlugin;
    }

    public FileConfig getFile() {
        return this.file;
    }

    public void setFile(FileConfig file) {
        this.file = file;
    }

    public ExcludePath getExclude() {
        return this.exclude;
    }

    public void setExclude(ExcludePath exclude) {
        this.exclude = exclude;
    }

    public FallbackPath getFallback() {
        return this.fallback;
    }

    public void setFallback(FallbackPath fallback) {
        this.fallback = fallback;
    }

    public UpstreamCheck getUpstreamCheck() {
        return this.upstreamCheck;
    }

    public void setUpstreamCheck(UpstreamCheck upstreamCheck) {
        this.upstreamCheck = upstreamCheck;
    }

    public CrossFilterConfig getCross() {
        return this.cross;
    }

    public WebsocketConfig getWebsocket() {
        return this.websocket;
    }

    public void setWebsocket(WebsocketConfig websocket) {
        this.websocket = websocket;
    }

    public void setCross(CrossFilterConfig cross) {
        this.cross = cross;
    }

    public static class MetricsConfig {
        private boolean enabled;
        private String name;
        private String host;
        private Integer port;
        private String jmxConfig;
        private Properties props;

        public boolean getEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getHost() {
            return this.host;
        }

        public void setHost(String host) {
            this.host = host;
        }

        public Integer getPort() {
            return this.port;
        }

        public void setPort(Integer port) {
            this.port = port;
        }

        public String getJmxConfig() {
            return this.jmxConfig;
        }

        public void setJmxConfig(String jmxConfig) {
            this.jmxConfig = jmxConfig;
        }

        public Properties getProps() {
            return this.props;
        }

        public void setProps(Properties props) {
            this.props = props;
        }
    }

    public static class SharedPool {
        private Boolean enable = Boolean.FALSE;
        private String prefix = "shenyu-shared";
        private Integer corePoolSize = 200;
        private Integer maximumPoolSize = Integer.MAX_VALUE;
        private Long keepAliveTime = 60000L;
        private Long maxWorkQueueMemory = MemoryLimitCalculator.defaultLimit();

        public Boolean getEnable() {
            return this.enable;
        }

        public void setEnable(Boolean enable) {
            this.enable = enable;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        public Integer getCorePoolSize() {
            return this.corePoolSize;
        }

        public void setCorePoolSize(Integer corePoolSize) {
            this.corePoolSize = corePoolSize;
        }

        public Integer getMaximumPoolSize() {
            return this.maximumPoolSize;
        }

        public void setMaximumPoolSize(Integer maximumPoolSize) {
            this.maximumPoolSize = maximumPoolSize;
        }

        public Long getKeepAliveTime() {
            return this.keepAliveTime;
        }

        public void setKeepAliveTime(Long keepAliveTime) {
            this.keepAliveTime = keepAliveTime;
        }

        public Long getMaxWorkQueueMemory() {
            return this.maxWorkQueueMemory;
        }

        public void setMaxWorkQueueMemory(Long maxWorkQueueMemory) {
            this.maxWorkQueueMemory = maxWorkQueueMemory;
        }
    }

    public static class WebsocketConfig {
        private Integer maxFramePayloadSize = 10;

        public Integer getMaxFramePayloadSize() {
            return this.maxFramePayloadSize;
        }

        public void setMaxFramePayloadSize(Integer maxFramePayloadSize) {
            this.maxFramePayloadSize = maxFramePayloadSize;
        }
    }

    public static class Local {
        private Boolean enabled = true;
        private String sha512Key;

        public Local() {
        }

        public Local(String sha512Key) {
            this.sha512Key = sha512Key;
        }

        public Boolean getEnabled() {
            return this.enabled;
        }

        public void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public String getSha512Key() {
            return this.sha512Key;
        }

        public void setSha512Key(String sha512Key) {
            this.sha512Key = sha512Key;
        }
    }

    public static class RibbonConfig {
        private Integer serverListRefreshInterval = 10000;

        public RibbonConfig() {
        }

        public RibbonConfig(Integer serverListRefreshInterval) {
            this.serverListRefreshInterval = serverListRefreshInterval;
        }

        public Integer getServerListRefreshInterval() {
            return this.serverListRefreshInterval;
        }

        public void setServerListRefreshInterval(Integer serverListRefreshInterval) {
            this.serverListRefreshInterval = serverListRefreshInterval;
        }
    }

    public static class InstanceConfig {
        private Boolean enabled = false;
        private String registerType;
        private String serverLists;
        private Properties props = new Properties();

        public InstanceConfig() {
        }

        public InstanceConfig(String registerType, String serverLists, Properties props) {
            this.registerType = registerType;
            this.serverLists = serverLists;
            this.props = props;
        }

        public Boolean getEnabled() {
            return this.enabled;
        }

        public void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public String getRegisterType() {
            return this.registerType;
        }

        public void setRegisterType(String registerType) {
            this.registerType = registerType;
        }

        public String getServerLists() {
            return this.serverLists;
        }

        public void setServerLists(String serverLists) {
            this.serverLists = serverLists;
        }

        public Properties getProps() {
            return this.props;
        }

        public void setProps(Properties props) {
            this.props = props;
        }
    }

    public static class CrossFilterConfig {
        private static final Set<String> DEFAULT_ALLOWED_HEADERS = new HashSet<String>(){
            {
                this.add("x-requested-with");
                this.add("authorization");
                this.add("Content-Type");
                this.add("Authorization");
                this.add("credential");
                this.add("X-XSRF-TOKEN");
                this.add("token");
                this.add("username");
                this.add("client");
            }
        };
        private Boolean enabled = true;
        private String allowedHeaders = "";
        private String allowedMethods = "*";
        private String allowedOrigin = "*";
        private String allowedExpose = "*";
        private String maxAge = "18000";
        private boolean allowCredentials = true;

        private String wrapperHeaders(String headers) {
            Set<String> headerSet = DEFAULT_ALLOWED_HEADERS;
            if (StringUtils.hasText((String)headers)) {
                headerSet.addAll(Stream.of(headers.split(",")).collect(Collectors.toSet()));
            }
            return String.join((CharSequence)",", headerSet);
        }

        public Boolean getEnabled() {
            return this.enabled;
        }

        public void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public String getAllowedHeaders() {
            this.allowedHeaders = this.wrapperHeaders(this.allowedHeaders);
            return this.allowedHeaders;
        }

        public void setAllowedHeaders(String allowedHeaders) {
            this.allowedHeaders = this.wrapperHeaders(allowedHeaders);
        }

        public String getAllowedMethods() {
            return this.allowedMethods;
        }

        public void setAllowedMethods(String allowedMethods) {
            this.allowedMethods = allowedMethods;
        }

        public String getAllowedOrigin() {
            return this.allowedOrigin;
        }

        public void setAllowedOrigin(String allowedOrigin) {
            this.allowedOrigin = allowedOrigin;
        }

        public String getAllowedExpose() {
            return this.allowedExpose;
        }

        public void setAllowedExpose(String allowedExpose) {
            this.allowedExpose = allowedExpose;
        }

        public String getMaxAge() {
            return this.maxAge;
        }

        public void setMaxAge(String maxAge) {
            this.maxAge = maxAge;
        }

        public boolean isAllowCredentials() {
            return this.allowCredentials;
        }

        public void setAllowCredentials(boolean allowCredentials) {
            this.allowCredentials = allowCredentials;
        }
    }

    public static class UpstreamCheck {
        private Boolean enabled = false;
        private Integer timeout = 3000;
        private Integer healthyThreshold = 1;
        private Integer unhealthyThreshold = 1;
        private Integer interval = 5000;
        private Boolean printEnabled = true;
        private Integer printInterval = 60000;

        public Boolean getEnabled() {
            return this.enabled;
        }

        public void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public Integer getTimeout() {
            return this.timeout;
        }

        public void setTimeout(Integer timeout) {
            this.timeout = timeout;
        }

        public Integer getHealthyThreshold() {
            return this.healthyThreshold;
        }

        public void setHealthyThreshold(Integer healthyThreshold) {
            this.healthyThreshold = healthyThreshold;
        }

        public Integer getUnhealthyThreshold() {
            return this.unhealthyThreshold;
        }

        public void setUnhealthyThreshold(Integer unhealthyThreshold) {
            this.unhealthyThreshold = unhealthyThreshold;
        }

        public Integer getInterval() {
            return this.interval;
        }

        public void setInterval(Integer interval) {
            this.interval = interval;
        }

        public Boolean getPrintEnabled() {
            return this.printEnabled;
        }

        public void setPrintEnabled(Boolean printEnabled) {
            this.printEnabled = printEnabled;
        }

        public Integer getPrintInterval() {
            return this.printInterval;
        }

        public void setPrintInterval(Integer printInterval) {
            this.printInterval = printInterval;
        }
    }

    public static class SwitchConfig {
        private Boolean local = true;

        public Boolean getLocal() {
            return this.local;
        }

        public void setLocal(Boolean local) {
            this.local = local;
        }
    }

    public static class FileConfig {
        private Boolean enabled = true;
        private Integer maxSize = 10;

        public Boolean getEnabled() {
            return this.enabled;
        }

        public void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public Integer getMaxSize() {
            return this.maxSize;
        }

        public void setMaxSize(Integer maxSize) {
            this.maxSize = maxSize;
        }
    }

    public static class FallbackPath {
        private Boolean enabled = false;
        private List<String> paths = new ArrayList<String>();

        public Boolean getEnabled() {
            return this.enabled;
        }

        public void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public void setPaths(List<String> paths) {
            this.paths = paths;
        }

        public List<String> getPaths() {
            return this.paths;
        }
    }

    public static class ExcludePath {
        private Boolean enabled = false;
        private List<String> paths = new ArrayList<String>();

        public Boolean getEnabled() {
            return this.enabled;
        }

        public void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public void setPaths(List<String> paths) {
            this.paths = paths;
        }

        public List<String> getPaths() {
            return this.paths;
        }
    }

    public static class ExtPlugin {
        private String path;
        private Boolean enabled = true;
        private Integer threads = 1;
        private Integer scheduleTime = 300;
        private Integer scheduleDelay = 30;

        public String getPath() {
            return this.path;
        }

        public void setPath(String path) {
            this.path = path;
        }

        public Boolean getEnabled() {
            return this.enabled;
        }

        public void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public Integer getThreads() {
            return this.threads;
        }

        public void setThreads(Integer threads) {
            this.threads = threads;
        }

        public Integer getScheduleTime() {
            return this.scheduleTime;
        }

        public void setScheduleTime(Integer scheduleTime) {
            this.scheduleTime = scheduleTime;
        }

        public Integer getScheduleDelay() {
            return this.scheduleDelay;
        }

        public void setScheduleDelay(Integer scheduleDelay) {
            this.scheduleDelay = scheduleDelay;
        }
    }

    public static class Scheduler {
        private Boolean enabled = false;
        private String type = "fixed";
        private Integer threads = Math.max((Runtime.getRuntime().availableProcessors() << 1) + 1, 16);

        public Boolean getEnabled() {
            return this.enabled;
        }

        public void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public Integer getThreads() {
            return this.threads;
        }

        public void setThreads(Integer threads) {
            this.threads = threads;
        }
    }
}

