/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.common.timer;

import java.util.concurrent.DelayQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.shenyu.common.concurrent.ShenyuThreadFactory;
import org.apache.shenyu.common.timer.Timer;
import org.apache.shenyu.common.timer.TimerTask;
import org.apache.shenyu.common.timer.TimerTaskList;
import org.apache.shenyu.common.timer.TimingWheel;

public class HierarchicalWheelTimer
implements Timer {
    private static final AtomicIntegerFieldUpdater<HierarchicalWheelTimer> WORKER_STATE_UPDATER = AtomicIntegerFieldUpdater.newUpdater(HierarchicalWheelTimer.class, "workerState");
    private final ExecutorService taskExecutor;
    private final DelayQueue<TimerTaskList> delayQueue = new DelayQueue();
    private final AtomicInteger taskCounter = new AtomicInteger(0);
    private final TimingWheel timingWheel;
    private final ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private final ReentrantReadWriteLock.ReadLock readLock = this.readWriteLock.readLock();
    private final ReentrantReadWriteLock.WriteLock writeLock = this.readWriteLock.writeLock();
    private volatile int workerState;
    private final Thread workerThread;

    public HierarchicalWheelTimer(String executorName) {
        this(executorName, 1L, 20, TimeUnit.NANOSECONDS.toMillis(System.nanoTime()));
    }

    public HierarchicalWheelTimer(String executorName, Long tickMs, Integer wheelSize, Long startMs) {
        ThreadFactory threadFactory = ShenyuThreadFactory.create(executorName, false);
        this.taskExecutor = Executors.newFixedThreadPool(1, threadFactory);
        this.workerThread = threadFactory.newThread(new Worker(this));
        this.timingWheel = new TimingWheel(tickMs, wheelSize, startMs, this.taskCounter, this.delayQueue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(TimerTask timerTask) {
        if (timerTask == null) {
            throw new NullPointerException("timer task null");
        }
        this.readLock.lock();
        try {
            this.start();
            long millis = TimeUnit.NANOSECONDS.toMillis(System.nanoTime());
            this.addTimerTaskEntry(new TimerTaskList.TimerTaskEntry(this, timerTask, timerTask.getDelayMs() + millis));
        }
        finally {
            this.readLock.unlock();
        }
    }

    private void addTimerTaskEntry(TimerTaskList.TimerTaskEntry timerTaskEntry) {
        if (!this.timingWheel.add(timerTaskEntry) && !timerTaskEntry.cancelled()) {
            this.taskExecutor.submit(() -> timerTaskEntry.getTimerTask().run(timerTaskEntry));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void advanceClock(long timeoutMs) throws InterruptedException {
        TimerTaskList bucket = (TimerTaskList)this.delayQueue.poll(timeoutMs, TimeUnit.MILLISECONDS);
        if (bucket != null) {
            this.writeLock.lock();
            try {
                while (bucket != null) {
                    this.timingWheel.advanceClock(bucket.getExpiration());
                    bucket.flush(this::addTimerTaskEntry);
                    bucket = (TimerTaskList)this.delayQueue.poll();
                }
            }
            finally {
                this.writeLock.unlock();
            }
        }
    }

    private void start() {
        int state = WORKER_STATE_UPDATER.get(this);
        if (state == 0 && WORKER_STATE_UPDATER.compareAndSet(this, 0, 1)) {
            this.workerThread.start();
        }
    }

    @Override
    public int size() {
        return this.taskCounter.get();
    }

    @Override
    public void shutdown() {
        this.taskExecutor.shutdown();
    }

    private static class Worker
    implements Runnable {
        private final Timer timer;

        Worker(Timer timer) {
            this.timer = timer;
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        this.timer.advanceClock(100L);
                    }
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
    }
}

