/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.common.cache;

import java.util.Map;
import org.apache.commons.collections4.map.LRUMap;
import org.apache.shenyu.common.concurrent.MemoryLimitCalculator;

public class MemorySafeLRUMap<K, V>
extends LRUMap<K, V> {
    private final int maxFreeMemory;

    public MemorySafeLRUMap(int maxFreeMemory, int initialSize) {
        super(0x40000000, initialSize);
        this.maxFreeMemory = maxFreeMemory;
    }

    public MemorySafeLRUMap(int maxFreeMemory, int initialSize, float loadFactor) {
        super(0x40000000, initialSize, loadFactor);
        this.maxFreeMemory = maxFreeMemory;
    }

    public MemorySafeLRUMap(int maxFreeMemory, int initialSize, float loadFactor, boolean scanUntilRemovable) {
        super(0x40000000, initialSize, loadFactor, scanUntilRemovable);
        this.maxFreeMemory = maxFreeMemory;
    }

    public MemorySafeLRUMap(int maxFreeMemory, Map<? extends K, ? extends V> map) {
        super(map);
        this.maxFreeMemory = maxFreeMemory;
    }

    public MemorySafeLRUMap(int maxFreeMemory, Map<? extends K, ? extends V> map, boolean scanUntilRemovable) {
        super(map, scanUntilRemovable);
        this.maxFreeMemory = maxFreeMemory;
    }

    public boolean isFull() {
        return this.size() > 0 && MemoryLimitCalculator.maxAvailable() < (long)this.maxFreeMemory;
    }
}

