/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.common.utils;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import org.apache.shenyu.common.utils.DigestUtils;
import org.apache.shenyu.common.utils.HmacUtils;

public final class SignUtils {
    public static final String SIGN_MD5 = "MD5";
    public static final String SIGN_HMD5 = "HMD5";
    public static final String SIGN_HS256 = "HS256";
    public static final String SIGN_HS512 = "HS512";
    private static final Map<String, SignFunction> SIGN_FUNCTION_MAP = ImmutableMap.of((Object)"MD5", (key, data) -> DigestUtils.md5Hex(data + key), (Object)"HMD5", HmacUtils::hmacMd5Hex, (Object)"HS256", HmacUtils::hmacSha256Hex, (Object)"HS512", HmacUtils::hmacSha512Hex);

    public static String sign(String algorithmName, String key, String data) {
        if (Objects.isNull(key) || Objects.isNull(data)) {
            throw new NullPointerException("Key or data is null.");
        }
        return Optional.ofNullable(SIGN_FUNCTION_MAP.get(algorithmName)).orElseThrow(() -> new UnsupportedOperationException("unsupported sign algorithm:" + algorithmName)).sign(key, data);
    }

    public static String generateKey() {
        return UUID.randomUUID().toString().replaceAll("-", "").toUpperCase();
    }

    @FunctionalInterface
    private static interface SignFunction {
        public String sign(String var1, String var2);
    }
}

