/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.common.utils;

import java.net.URI;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class UriUtils {
    private static final String PRE_FIX = "/";

    public static URI createUri(String uri) {
        if (StringUtils.isNotBlank((CharSequence)uri)) {
            return URI.create(uri);
        }
        return null;
    }

    public static String repairData(String name) {
        return name.startsWith(PRE_FIX) ? name : PRE_FIX + name;
    }

    public static String removePrefix(String name) {
        return name.startsWith(PRE_FIX) ? name.substring(1) : name;
    }

    public static String getPathWithParams(URI uri) {
        if (Objects.isNull(uri)) {
            return "";
        }
        String params = StringUtils.isEmpty((CharSequence)uri.getQuery()) ? "" : "?" + uri.getQuery();
        return uri.getPath() + params;
    }

    public static String appendScheme(String url, String scheme) {
        String schemeUrl = url;
        if (!schemeUrl.startsWith("http://") && !schemeUrl.startsWith("https://")) {
            schemeUrl = scheme + "://" + schemeUrl;
        }
        return schemeUrl;
    }
}

