/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.springboot.starter.client.springmvc;

import java.util.List;
import org.apache.shenyu.client.auto.config.ClientRegisterConfiguration;
import org.apache.shenyu.client.core.disruptor.ShenyuClientRegisterEventPublisher;
import org.apache.shenyu.client.core.register.ClientInfoRefreshedEventListener;
import org.apache.shenyu.client.core.register.ClientRegisterConfig;
import org.apache.shenyu.client.core.register.ClientRegisterConfigImpl;
import org.apache.shenyu.client.core.register.matcher.ExtractorProcessor;
import org.apache.shenyu.client.core.register.registrar.AbstractApiDocRegistrar;
import org.apache.shenyu.client.core.register.registrar.AbstractApiMetaRegistrar;
import org.apache.shenyu.client.core.register.registrar.HttpApiDocRegistrar;
import org.apache.shenyu.client.springmvc.proceeor.register.ShenyuSpringMvcClientProcessorImpl;
import org.apache.shenyu.client.springmvc.register.SpringMvcApiBeansExtractor;
import org.apache.shenyu.client.springmvc.register.SpringMvcApiMetaRegister;
import org.apache.shenyu.common.enums.RpcTypeEnum;
import org.apache.shenyu.register.common.config.ShenyuClientConfig;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@Configuration(proxyBeanMethods=false)
@ConditionalOnBean(value={ClientRegisterConfiguration.class})
public class ShenyuSpringMvcClientInfoRegisterConfiguration {
    @Bean
    public ClientInfoRefreshedEventListener clientInfoEventListener(ClientRegisterConfig clientRegisterConfig, ShenyuClientRegisterEventPublisher publisher) {
        return new ClientInfoRefreshedEventListener(clientRegisterConfig, publisher);
    }

    @Bean
    @ConditionalOnMissingBean
    public SpringMvcApiBeansExtractor springMvcApiBeansExtractor(List<ExtractorProcessor> extractorProcessorList) {
        SpringMvcApiBeansExtractor extractor = SpringMvcApiBeansExtractor.buildDefaultSpringMvcApiBeansExtractor();
        for (ExtractorProcessor processor : extractorProcessorList) {
            extractor.addExtractorProcessor(processor);
        }
        return extractor;
    }

    @Bean
    public ShenyuSpringMvcClientProcessorImpl shenyuSpringMvcClientProcessor() {
        return new ShenyuSpringMvcClientProcessorImpl();
    }

    public AbstractApiMetaRegistrar buildApiMetaRegistrar(ShenyuClientRegisterEventPublisher publisher, ClientRegisterConfig clientRegisterConfig) {
        return new SpringMvcApiMetaRegister(publisher, clientRegisterConfig);
    }

    public AbstractApiDocRegistrar buildApiDocRegistrar(ShenyuClientRegisterEventPublisher publisher, ClientRegisterConfig clientRegisterConfig) {
        return new HttpApiDocRegistrar(publisher, clientRegisterConfig);
    }

    @Bean
    public ClientRegisterConfig clientRegisterConfig(ShenyuClientConfig shenyuClientConfig, ApplicationContext applicationContext, Environment env) {
        return new ClientRegisterConfigImpl(shenyuClientConfig, RpcTypeEnum.HTTP, applicationContext, env);
    }
}

