/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.common.cache.ehcache;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.MapMaker;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.io.IOException;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServer;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.config.Configuration;
import net.sf.ehcache.config.ConfigurationFactory;
import net.sf.ehcache.management.ManagementService;
import org.apache.shindig.common.cache.Cache;
import org.apache.shindig.common.cache.CacheProvider;
import org.apache.shindig.common.cache.ehcache.EhConfiguredCache;
import org.apache.shindig.common.servlet.GuiceServletContextListener;
import org.apache.shindig.common.util.ResourceLoader;

public class EhCacheCacheProvider
implements CacheProvider,
GuiceServletContextListener.CleanupCapable {
    private static final Logger LOG = Logger.getLogger(EhCacheCacheProvider.class.getName());
    private final CacheManager cacheManager;
    private final ConcurrentMap<String, Cache<?, ?>> caches = new MapMaker().makeMap();

    @Inject
    public EhCacheCacheProvider(@Named(value="shindig.cache.ehcache.config") String configPath, @Named(value="shindig.cache.ehcache.sizeof.filter") String filterPath, @Named(value="shindig.cache.ehcache.jmx.enabled") boolean jmxEnabled, @Named(value="shindig.cache.ehcache.jmx.stats") boolean withCacheStats, GuiceServletContextListener.CleanupHandler cleanupHandler) throws IOException {
        String normalizedFilterPath = filterPath.replaceFirst("res://", "");
        normalizedFilterPath = normalizedFilterPath.replaceFirst("file://", "");
        System.setProperty("net.sf.ehcache.sizeof.filter", normalizedFilterPath);
        String diskStoreProperty = System.getProperty("ehcache.disk.store.dir");
        if (Strings.isNullOrEmpty((String)diskStoreProperty)) {
            System.setProperty("ehcache.disk.store.dir", System.getProperty("java.io.tmpdir"));
        }
        this.cacheManager = CacheManager.newInstance((Configuration)this.getConfiguration(configPath));
        this.create(jmxEnabled, withCacheStats);
        cleanupHandler.register(this);
    }

    protected Configuration getConfiguration(String configPath) throws IOException {
        InputStream configStream = ResourceLoader.open(configPath);
        return ConfigurationFactory.parseConfiguration((InputStream)configStream);
    }

    private void create(boolean jmxEnabled, boolean withCacheStats) {
        if (jmxEnabled) {
            MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
            ManagementService.registerMBeans((CacheManager)this.cacheManager, (MBeanServer)mBeanServer, (boolean)true, (boolean)true, (boolean)true, (boolean)withCacheStats);
        }
    }

    @Override
    public void cleanup() {
        this.cacheManager.shutdown();
    }

    @Override
    public <K, V> Cache<K, V> createCache(String name) {
        if (!this.caches.containsKey(Preconditions.checkNotNull((Object)name))) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Creating cache named " + name);
            }
            this.caches.putIfAbsent(name, new EhConfiguredCache(name, this.cacheManager));
        }
        return (Cache)this.caches.get(Preconditions.checkNotNull((Object)name));
    }
}

