/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.protocol.conversion;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.MapMaker;
import com.google.inject.Inject;
import com.google.inject.Injector;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.shindig.common.JsonProperty;
import org.apache.shindig.common.JsonSerializer;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.protocol.conversion.BeanConverter;
import org.apache.shindig.protocol.model.Enum;
import org.apache.shindig.protocol.model.EnumImpl;
import org.apache.shindig.protocol.model.ExtendableBean;
import org.joda.time.DateTime;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class BeanJsonConverter
implements BeanConverter {
    private static final Map<Class<?>, Map<String, Method>> setters = new MapMaker().makeMap();
    private final Injector injector;

    @Inject
    public BeanJsonConverter(Injector injector) {
        this.injector = injector;
    }

    @Override
    public String getContentType() {
        return "application/json";
    }

    @Override
    public String convertToString(Object pojo) {
        return JsonSerializer.serialize(pojo);
    }

    @Override
    public void append(Appendable buf, Object pojo) throws IOException {
        JsonSerializer.append(buf, pojo);
    }

    private static Map<String, Method> getSetters(Class<?> type) {
        ImmutableMap methods = setters.get(type);
        if (methods != null) {
            return methods;
        }
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Method method : type.getMethods()) {
            String name;
            if (method.getParameterTypes().length != 1 || (name = BeanJsonConverter.getPropertyName(method)) == null) continue;
            builder.put((Object)name, (Object)method);
        }
        methods = builder.build();
        setters.put(type, (Map<String, Method>)methods);
        return methods;
    }

    private static String getPropertyName(Method setter) {
        JsonProperty property = setter.getAnnotation(JsonProperty.class);
        if (property == null) {
            String name = setter.getName();
            if (name.startsWith("set") && !Modifier.isStatic(setter.getModifiers())) {
                return name.substring(3, 4).toLowerCase() + name.substring(4);
            }
            return null;
        }
        return property.value();
    }

    @Override
    public <T> T convertToObject(String string, Class<T> clazz) {
        return this.convertToObject(string, (Type)clazz);
    }

    public <T> T convertToObject(String json, Type type) {
        try {
            return (T)this.convertToObject(new JSONObject(json), type);
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    public Object convertToObject(Object value, Type type) {
        if (type == null || type.equals(Object.class)) {
            if (value instanceof JSONObject) {
                return this.convertToMap((JSONObject)value, null);
            }
            if (value instanceof JSONArray) {
                return this.convertToList((JSONArray)value, null);
            }
            return value;
        }
        if (type instanceof ParameterizedType) {
            return this.convertGeneric(value, (ParameterizedType)type);
        }
        if (type.equals(String.class)) {
            return String.valueOf(value);
        }
        if (type.equals(Boolean.class) || type.equals(Boolean.TYPE)) {
            return value instanceof String ? Boolean.valueOf((String)value).booleanValue() : Boolean.TRUE.equals(value);
        }
        if (type.equals(Integer.class) || type.equals(Integer.TYPE)) {
            return value instanceof String ? Integer.valueOf((String)value).intValue() : ((Number)value).intValue();
        }
        if (type.equals(Long.class) || type.equals(Long.TYPE)) {
            return value instanceof String ? Long.valueOf((String)value).longValue() : ((Number)value).longValue();
        }
        if (type.equals(Double.class) || type.equals(Double.TYPE)) {
            return value instanceof String ? Double.valueOf((String)value).doubleValue() : ((Number)value).doubleValue();
        }
        if (type.equals(Float.class) || type.equals(Float.TYPE)) {
            return Float.valueOf(value instanceof String ? Float.valueOf((String)value).floatValue() : ((Number)value).floatValue());
        }
        if (type.equals(Date.class)) {
            return new DateTime((Object)String.valueOf(value)).toDate();
        }
        if (type.equals(Uri.class)) {
            return Uri.parse(String.valueOf(value));
        }
        if (type.equals(Map.class)) {
            return this.convertToMap((JSONObject)value, null);
        }
        if (type.equals(List.class) || type.equals(Collection.class)) {
            return this.convertToList((JSONArray)value, null);
        }
        if (type.equals(Set.class)) {
            return this.convertToSet((JSONArray)value, null);
        }
        Class clazz = (Class)type;
        if (clazz.isEnum()) {
            return this.convertToEnum((String)value, clazz);
        }
        return this.convertToClass((JSONObject)value, clazz);
    }

    private Object convertGeneric(Object value, ParameterizedType type) {
        Type[] typeArgs = type.getActualTypeArguments();
        Class clazz = (Class)type.getRawType();
        if (Set.class.isAssignableFrom(clazz)) {
            return this.convertToSet((JSONArray)value, typeArgs[0]);
        }
        if (Collection.class.isAssignableFrom(clazz)) {
            return this.convertToList((JSONArray)value, typeArgs[0]);
        }
        if (Map.class.isAssignableFrom(clazz)) {
            return this.convertToMap((JSONObject)value, typeArgs[1]);
        }
        if (Enum.class.isAssignableFrom(clazz)) {
            return this.convertToOsEnum((JSONObject)value, (Class)typeArgs[0]);
        }
        return this.convertToClass((JSONObject)value, clazz);
    }

    private Enum<Enum.EnumKey> convertToOsEnum(JSONObject json, Class<?> enumKeyType) {
        EnumImpl<Object> value;
        String val = Enum.Field.VALUE.toString();
        String display = Enum.Field.DISPLAY_VALUE.toString();
        if (json.has(val)) {
            Enum.EnumKey enumKey;
            try {
                enumKey = (Enum.EnumKey)enumKeyType.getField(json.optString(val)).get(null);
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException(e);
            }
            catch (SecurityException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (NoSuchFieldException e) {
                throw new RuntimeException(e);
            }
            String displayValue = null;
            if (json.has(display)) {
                displayValue = json.optString(display);
            }
            value = new EnumImpl<Enum.EnumKey>(enumKey, displayValue);
        } else {
            value = new EnumImpl<Object>(null, json.optString(display));
        }
        return value;
    }

    private Object convertToEnum(String value, Class<?> type) {
        for (Object o : type.getEnumConstants()) {
            if (!o.toString().equals(value)) continue;
            return o;
        }
        throw new IllegalArgumentException("No enum value " + value + " in " + type.getName());
    }

    private Map<String, Object> convertToMap(JSONObject in, Type type) {
        HashMap<String, Object> out = new HashMap<String, Object>(in.length(), 1.0f);
        if (in.length() == 0) {
            return Collections.emptyMap();
        }
        for (String name : JSONObject.getNames((JSONObject)in)) {
            out.put(name, this.convertToObject(in.opt(name), type));
        }
        return out;
    }

    private List<Object> convertToList(JSONArray in, Type type) {
        ArrayList out = Lists.newArrayListWithCapacity((int)in.length());
        int j = in.length();
        for (int i = 0; i < j; ++i) {
            out.add(this.convertToObject(in.opt(i), type));
        }
        return out;
    }

    private Set<Object> convertToSet(JSONArray in, Type type) {
        return ImmutableSet.copyOf(this.convertToList(in, type));
    }

    private Object convertToClass(JSONObject in, Class<?> type) {
        Object out = this.injector.getInstance(type);
        if (ExtendableBean.class.isAssignableFrom(type)) {
            for (String name : JSONObject.getNames((JSONObject)in)) {
                ((ExtendableBean)out).put(name, this.convertToObject(in.opt(name), null));
            }
        }
        for (Map.Entry<String, Method> entry : BeanJsonConverter.getSetters(out.getClass()).entrySet()) {
            Object value = in.opt(entry.getKey());
            if (value == null) continue;
            Method method = entry.getValue();
            try {
                method.invoke(out, this.convertToObject(value, method.getGenericParameterTypes()[0]));
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        return out;
    }
}

