/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets;

import java.util.concurrent.ExecutorService;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.shindig.auth.AnonymousSecurityToken;
import org.apache.shindig.auth.SecurityToken;
import org.apache.shindig.common.cache.Cache;
import org.apache.shindig.common.cache.SoftExpiringCache;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.common.xml.XmlException;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.http.HttpRequest;
import org.apache.shindig.gadgets.http.HttpResponse;
import org.apache.shindig.gadgets.http.RequestPipeline;
import org.apache.shindig.gadgets.spec.SpecParserException;

public abstract class AbstractSpecFactory<T> {
    private static final String classname = AbstractSpecFactory.class.getName();
    private static final Logger LOG = Logger.getLogger(classname, "org.apache.shindig.common.logging.i18n.resource");
    private final Class<T> clazz;
    private final ExecutorService executor;
    private final RequestPipeline pipeline;
    final SoftExpiringCache<String, Object> cache;
    private final long refresh;

    public AbstractSpecFactory(Class<T> clazz, ExecutorService executor, RequestPipeline pipeline, Cache<String, Object> cache, long refresh) {
        this.clazz = clazz;
        this.executor = executor;
        this.pipeline = pipeline;
        this.cache = new SoftExpiringCache(cache);
        this.refresh = refresh;
    }

    protected T getSpec(Query query) throws GadgetException {
        SoftExpiringCache.CachedObject cached;
        Object obj = null;
        if (!query.ignoreCache && (cached = this.cache.getElement((Object)query.specUri.toString())) != null) {
            obj = cached.obj;
            if (cached.isExpired) {
                this.cache.addElement((Object)query.specUri.toString(), obj, this.refresh);
                this.executor.execute(new SpecUpdater(query, obj));
            }
        }
        if (obj == null) {
            boolean bypassCache = false;
            try {
                obj = this.fetchFromNetwork(query);
            }
            catch (SpecRetrievalFailedException e) {
                bypassCache = true;
                obj = e;
            }
            catch (GadgetException e) {
                obj = e;
            }
            if (!bypassCache) {
                this.cache.addElement((Object)query.specUri.toString(), obj, this.refresh);
            }
        }
        if (obj instanceof GadgetException) {
            throw (GadgetException)obj;
        }
        return this.clazz.cast(obj);
    }

    protected T fetchFromNetwork(Query query) throws SpecRetrievalFailedException, GadgetException {
        HttpRequest request = new HttpRequest(query.specUri).setIgnoreCache(query.ignoreCache).setGadget(query.gadgetUri).setContainer(query.container).setSecurityToken((SecurityToken)new AnonymousSecurityToken("", Long.valueOf(0L), query.gadgetUri.toString()));
        request.setCacheTtl((int)(this.refresh / 1000L));
        HttpResponse response = this.pipeline.execute(request);
        if (response.getHttpStatusCode() != 200) {
            int retcode = response.getHttpStatusCode();
            if (retcode == 500) {
                retcode = 502;
            }
            throw new SpecRetrievalFailedException(query.specUri, retcode);
        }
        try {
            String content = response.getResponseAsString();
            return this.parse(content, query);
        }
        catch (XmlException e) {
            throw new SpecParserException(e);
        }
    }

    protected abstract T parse(String var1, Query var2) throws XmlException, GadgetException;

    protected static class SpecRetrievalFailedException
    extends GadgetException {
        public SpecRetrievalFailedException(Uri specUri, int code) {
            super(GadgetException.Code.FAILED_TO_RETRIEVE_CONTENT, "Unable to retrieve spec for " + specUri + ". HTTP error " + code, code);
        }
    }

    private class SpecUpdater
    implements Runnable {
        private final Query query;
        private final Object old;

        public SpecUpdater(Query query, Object old) {
            this.query = query;
            this.old = old;
        }

        @Override
        public void run() {
            try {
                Object newSpec = AbstractSpecFactory.this.fetchFromNetwork(this.query);
                AbstractSpecFactory.this.cache.addElement((Object)this.query.specUri.toString(), newSpec, AbstractSpecFactory.this.refresh);
            }
            catch (SpecRetrievalFailedException se) {
                if (LOG.isLoggable(Level.WARNING)) {
                    LOG.logp(Level.WARNING, classname, "SpecUpdater", "updateSpecFailureApplyNegCache", new Object[]{this.query.specUri, se.getHttpStatusCode(), se.getMessage()});
                }
            }
            catch (GadgetException e) {
                if (this.old != null) {
                    if (LOG.isLoggable(Level.WARNING)) {
                        LOG.logp(Level.WARNING, classname, "SpecUpdater", "updateSpecFailureUseCacheVersion", new Object[]{this.query.specUri, e.getHttpStatusCode(), e.getMessage()});
                    }
                    AbstractSpecFactory.this.cache.addElement((Object)this.query.specUri.toString(), this.old, AbstractSpecFactory.this.refresh);
                }
                if (LOG.isLoggable(Level.WARNING)) {
                    LOG.logp(Level.WARNING, classname, "SpecUpdater", "updateSpecFailureApplyNegCache", new Object[]{this.query.specUri, e.getHttpStatusCode(), e.getMessage()});
                }
                AbstractSpecFactory.this.cache.addElement((Object)this.query.specUri.toString(), (Object)e, AbstractSpecFactory.this.refresh);
            }
        }
    }

    protected static class Query {
        private Uri specUri = null;
        private String container = "default";
        private Uri gadgetUri = null;
        private boolean ignoreCache = false;

        public Query setSpecUri(Uri specUri) {
            this.specUri = specUri;
            return this;
        }

        public Query setContainer(String container) {
            this.container = container;
            return this;
        }

        public Query setGadgetUri(Uri gadgetUri) {
            this.gadgetUri = gadgetUri;
            return this;
        }

        public Query setIgnoreCache(boolean ignoreCache) {
            this.ignoreCache = ignoreCache;
            return this;
        }

        public Uri getSpecUri() {
            return this.specUri;
        }

        public String getContainer() {
            return this.container;
        }

        public Uri getGadgetUri() {
            return this.gadgetUri;
        }

        public boolean getIgnoreCache() {
            return this.ignoreCache;
        }
    }
}

