/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.features;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.common.xml.XmlException;
import org.apache.shindig.common.xml.XmlUtil;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.features.ApiDirective;
import org.apache.shindig.gadgets.features.FeatureRegistry;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class FeatureParser {
    FeatureParser() {
    }

    public ParsedFeature parse(Uri parent, String xml) throws GadgetException {
        Element doc;
        try {
            doc = XmlUtil.parse((String)xml);
        }
        catch (XmlException e) {
            throw new GadgetException(GadgetException.Code.MALFORMED_XML_DOCUMENT, (Throwable)e);
        }
        String name = null;
        ArrayList deps = Lists.newArrayList();
        ArrayList bundles = Lists.newArrayList();
        boolean supportDefer = false;
        NodeList children = doc.getChildNodes();
        int j = children.getLength();
        for (int i = 0; i < j; ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 1) continue;
            Element element = (Element)child;
            if (element.getTagName().equals("name")) {
                name = element.getTextContent();
                continue;
            }
            if (element.getTagName().equals("dependency")) {
                deps.add(element.getTextContent());
                continue;
            }
            String type = element.getTagName().toLowerCase();
            ArrayList resources = Lists.newArrayList();
            NodeList resourceKids = element.getElementsByTagName("script");
            int y = resourceKids.getLength();
            for (int x = 0; x < y; ++x) {
                Element resourceChild = (Element)resourceKids.item(x);
                String src = resourceChild.getAttribute("src");
                String content = resourceChild.getTextContent();
                Map<String, String> attribs = this.getAttribs(resourceChild);
                Uri source = null;
                if (src != null && src.length() > 0) {
                    source = !"false".equals(attribs.get("inline")) ? parent.resolve(FeatureRegistry.getComponentUri(src)) : Uri.parse((String)src);
                }
                resources.add(new ParsedFeature.Resource(source, (String)(src != null && src.length() != 0 ? null : content), this.getAttribs(resourceChild)));
            }
            ArrayList apiDirectives = Lists.newArrayList();
            NodeList apiKids = element.getElementsByTagName("api");
            int y2 = apiKids.getLength();
            for (int x = 0; x < y2; ++x) {
                Element apiChild = (Element)apiKids.item(x);
                supportDefer = "true".equalsIgnoreCase(apiChild.getAttribute("supportDefer"));
                NodeList apiElems = apiChild.getChildNodes();
                int b = apiElems.getLength();
                for (int a = 0; a < b; ++a) {
                    Node apiElemNode = apiElems.item(a);
                    if (apiElemNode.getNodeType() != 1) continue;
                    Element apiElem = (Element)apiElemNode;
                    boolean isImport = "uses".equals(apiElem.getNodeName());
                    boolean isExport = "exports".equals(apiElem.getNodeName());
                    if (!isImport && !isExport) continue;
                    apiDirectives.add(new ApiDirective(apiElem.getAttribute("type"), apiElem.getTextContent(), isImport));
                }
            }
            bundles.add(new ParsedFeature.Bundle(name, type, this.getAttribs(element), resources, apiDirectives, supportDefer));
        }
        return new ParsedFeature(name, deps, bundles);
    }

    private Map<String, String> getAttribs(Element element) {
        ImmutableMap.Builder attribs = ImmutableMap.builder();
        NamedNodeMap attribNodes = element.getAttributes();
        int y = attribNodes.getLength();
        for (int x = 0; x < y; ++x) {
            Attr attr = (Attr)attribNodes.item(x);
            if (attr.getName().equals("src")) continue;
            attribs.put((Object)attr.getName(), (Object)attr.getValue());
        }
        return attribs.build();
    }

    static final class ParsedFeature {
        private final String name;
        private final List<String> deps;
        private final List<Bundle> bundles;

        private ParsedFeature(String name, List<String> deps, List<Bundle> bundles) {
            this.name = name;
            this.deps = ImmutableList.copyOf(deps);
            this.bundles = ImmutableList.copyOf(bundles);
        }

        public String getName() {
            return this.name;
        }

        public List<String> getDeps() {
            return this.deps;
        }

        public List<Bundle> getBundles() {
            return this.bundles;
        }

        static final class Resource {
            private final Uri source;
            private final String content;
            private final Map<String, String> attribs;

            private Resource(Uri source, String content, Map<String, String> attribs) {
                this.source = source;
                this.content = content;
                this.attribs = ImmutableMap.copyOf(attribs);
            }

            public Uri getSource() {
                return this.source;
            }

            public String getContent() {
                return this.content;
            }

            public Map<String, String> getAttribs() {
                return this.attribs;
            }
        }

        public static final class Bundle {
            private final String name;
            private final String type;
            private final Map<String, String> attribs;
            private final List<Resource> resources;
            private final List<ApiDirective> apiDirectives;
            private final boolean supportDefer;

            private Bundle(String name, String type, Map<String, String> attribs, List<Resource> resources, List<ApiDirective> apiDirectives, boolean supportDefer) {
                this.name = name;
                this.type = type;
                this.attribs = attribs;
                this.resources = resources;
                this.apiDirectives = apiDirectives;
                this.supportDefer = supportDefer;
            }

            public String getName() {
                return this.name;
            }

            public String getType() {
                return this.type;
            }

            public Map<String, String> getAttribs() {
                return this.attribs;
            }

            public List<Resource> getResources() {
                return this.resources;
            }

            public List<ApiDirective> getApis() {
                return this.apiDirectives;
            }

            public boolean isSupportDefer() {
                return this.supportDefer;
            }
        }
    }
}

