/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.features;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.MapMaker;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.shindig.common.cache.Cache;
import org.apache.shindig.common.cache.CacheProvider;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.common.util.TimeSource;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.features.DefaultFeatureFileSystem;
import org.apache.shindig.gadgets.features.FeatureRegistry;
import org.apache.shindig.gadgets.features.FeatureResource;
import org.apache.shindig.gadgets.features.FeatureResourceLoader;

public class TestFeatureRegistry
extends FeatureRegistry {
    private final TestFeatureResourceLoader resourceLoader;
    private final TestCacheProvider cacheProvider;

    public static Builder newBuilder() {
        return new Builder();
    }

    private TestFeatureRegistry(TestFeatureResourceLoader resourceLoader, TestCacheProvider cacheProvider, String featureFiles) throws GadgetException {
        super(resourceLoader, cacheProvider, (List<String>)ImmutableList.of((Object)featureFiles), new DefaultFeatureFileSystem());
        this.resourceLoader = resourceLoader;
        this.cacheProvider = cacheProvider;
    }

    public Map<String, String> getLastAttribs() {
        return Collections.unmodifiableMap(this.resourceLoader.lastAttribs);
    }

    public Cache<String, FeatureRegistry.LookupResult> getLookupCache() {
        Cache cacheEntry = (Cache)this.cacheProvider.caches.get("FeatureJsCache");
        if (cacheEntry == null) {
            return null;
        }
        return cacheEntry;
    }

    private static class MapCache<K, V>
    implements Cache<K, V> {
        private final Map<K, V> cache = new MapMaker().makeMap();

        private MapCache() {
        }

        public void addElement(K key, V value) {
            this.cache.put(key, value);
        }

        public long getCapacity() {
            return Integer.MAX_VALUE;
        }

        public V getElement(K key) {
            return this.cache.get(key);
        }

        public long getSize() {
            return this.cache.size();
        }

        public V removeElement(K key) {
            return this.cache.get(key);
        }
    }

    private static class TestCacheProvider
    implements CacheProvider {
        private final Map<String, Cache<?, ?>> caches = new MapMaker().makeMap();

        private TestCacheProvider() {
        }

        public <K, V> Cache<K, V> createCache(String name) {
            Cache<?, ?> cache = this.caches.get(name);
            if (cache == null) {
                cache = new MapCache();
                this.caches.put(name, cache);
            }
            return cache;
        }
    }

    private static class ResourceMock {
        private final Map<String, String> resourceMap = Maps.newHashMap();

        private ResourceMock() {
        }

        private void put(String key, String value) {
            this.resourceMap.put(this.clean(key), value);
        }

        private String get(String key) throws IOException {
            if (!this.resourceMap.containsKey(key = this.clean(key))) {
                throw new IOException("Missing resource: " + key);
            }
            return this.resourceMap.get(key);
        }

        private String clean(String key) {
            return key.startsWith("/") ? key.substring(1) : key;
        }
    }

    private static class TestFeatureResourceLoader
    extends FeatureResourceLoader {
        private final ResourceMock resourceMock;
        private Map<String, String> lastAttribs;

        private TestFeatureResourceLoader(ResourceMock resourceMock) {
            super(null, new TimeSource(), new DefaultFeatureFileSystem());
            this.resourceMock = resourceMock;
        }

        @Override
        public FeatureResource load(Uri uri, Map<String, String> attribs) throws GadgetException {
            this.lastAttribs = ImmutableMap.copyOf(attribs);
            return super.load(uri, attribs);
        }

        @Override
        public String getResourceContent(String resource) throws IOException {
            return this.resourceMock.get(resource);
        }
    }

    public static class Builder {
        private static String RESOURCE_BASE_PATH = "/resource/base/path";
        private static int resourceIdx = 0;
        private final ResourceMock resourceMock = new ResourceMock();
        private final List<String> featureFiles = Lists.newLinkedList();

        private Builder() {
        }

        public TestFeatureRegistry build(String useFeature) throws GadgetException {
            return new TestFeatureRegistry(new TestFeatureResourceLoader(this.resourceMock), new TestCacheProvider(), useFeature);
        }

        public TestFeatureRegistry build() throws GadgetException {
            return this.build(Joiner.on((String)",").join(this.featureFiles));
        }

        public Builder addFeatureFile(String featureFile) {
            this.featureFiles.add(featureFile);
            return this;
        }

        public Uri expectResource(String content) {
            return this.expectResource(content, ".xml");
        }

        public Uri expectResource(String content, String suffix) {
            Uri res = Builder.makeResourceUri(suffix);
            this.resourceMock.put(res.getPath(), content);
            return res;
        }

        private static Uri makeResourceUri(String suffix) {
            return Uri.parse((String)("res://" + RESOURCE_BASE_PATH + "/file" + ++resourceIdx + suffix));
        }
    }
}

