/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.http;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import org.apache.shindig.common.cache.Cache;
import org.apache.shindig.common.cache.CacheProvider;
import org.apache.shindig.gadgets.http.AbstractHttpCache;
import org.apache.shindig.gadgets.http.HttpResponse;

@Singleton
public class DefaultHttpCache
extends AbstractHttpCache {
    public static final String CACHE_NAME = "httpResponses";
    private final Cache<String, HttpResponse> cache;

    @Inject
    public DefaultHttpCache(CacheProvider cacheProvider) {
        this.cache = cacheProvider.createCache(CACHE_NAME);
    }

    @Override
    protected HttpResponse getResponseImpl(String key) {
        return (HttpResponse)this.cache.getElement((Object)key);
    }

    @Override
    protected void addResponseImpl(String key, HttpResponse response) {
        this.cache.addElement((Object)key, (Object)response);
    }

    @Override
    protected void removeResponseImpl(String key) {
        this.cache.removeElement((Object)key);
    }
}

