/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.http;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.shindig.common.util.Base32;
import org.apache.shindig.common.util.CharsetUtil;
import org.apache.shindig.gadgets.http.HttpResponse;
import org.apache.shindig.gadgets.http.HttpResponseBuilder;

public class HttpResponseMetadataHelper {
    public static final String DATA_HASH = "DataHash";
    public static final String IMAGE_HEIGHT = "ImageHeight";
    public static final String IMAGE_WIDTH = "ImageWidth";
    private static final String classname = HttpResponseMetadataHelper.class.getName();
    private static final Logger LOG = Logger.getLogger(classname, "org.apache.shindig.common.logging.i18n.resource");

    public static HttpResponse updateMetadata(HttpResponse response, Map<String, String> values) {
        HashMap metadata = Maps.newHashMap(response.getMetadata());
        for (Map.Entry<String, String> val : values.entrySet()) {
            metadata.put(val.getKey(), val.getValue());
        }
        return new HttpResponseBuilder(response).setMetadata(metadata).create();
    }

    public String getHash(HttpResponse response) {
        try {
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            md5.update(response.getResponseAsBytes());
            byte[] md5val = md5.digest();
            return CharsetUtil.newUtf8String((byte[])Base32.encodeBase32((byte[])md5val));
        }
        catch (NoSuchAlgorithmException e) {
            if (LOG.isLoggable(Level.INFO)) {
                LOG.logp(Level.INFO, classname, "getHash", "errorGettingMD5");
            }
            return null;
        }
    }

    public static HttpResponse updateHash(HttpResponse response, HttpResponseMetadataHelper helper) {
        String hash;
        if (helper != null && (hash = helper.getHash(response)) != null) {
            return HttpResponseMetadataHelper.updateMetadata(response, (Map<String, String>)ImmutableMap.of((Object)DATA_HASH, (Object)hash));
        }
        return response;
    }
}

