/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.js;

import com.google.common.collect.ImmutableList;
import org.apache.shindig.gadgets.features.FeatureRegistry;
import org.apache.shindig.gadgets.js.JsContent;
import org.apache.shindig.gadgets.js.JsProcessor;
import org.apache.shindig.gadgets.js.JsRequest;
import org.apache.shindig.gadgets.js.JsResponseBuilder;

public class SeparatorCommentingProcessor
implements JsProcessor {
    @Override
    public boolean process(JsRequest jsRequest, JsResponseBuilder builder) {
        ImmutableList.Builder jsBuilder = ImmutableList.builder();
        FeatureRegistry.FeatureBundle lastFeature = null;
        for (JsContent js : builder.build().getAllJsContent()) {
            FeatureRegistry.FeatureBundle feature = js.getFeatureBundle();
            if (lastFeature == null && feature != null) {
                jsBuilder.add((Object)this.newComment(feature, true));
            } else if (lastFeature != null && feature != null && lastFeature != feature) {
                jsBuilder.add((Object)this.newComment(lastFeature, false));
                jsBuilder.add((Object)this.newComment(feature, true));
            } else if (lastFeature != null && feature == null) {
                jsBuilder.add((Object)this.newComment(lastFeature, false));
            }
            jsBuilder.add((Object)js);
            lastFeature = feature;
        }
        if (lastFeature != null) {
            jsBuilder.add((Object)this.newComment(lastFeature, false));
        }
        builder.clearJs().appendAllJs((Iterable<JsContent>)jsBuilder.build());
        return true;
    }

    private JsContent newComment(FeatureRegistry.FeatureBundle bundle, boolean start) {
        String tag = start ? "start" : "end";
        return JsContent.fromFeature("\n/* [" + tag + "] feature=" + bundle.getName() + " */\n", "[comment-marker-" + tag + ']', bundle, null);
    }
}

