/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.oauth;

import com.google.common.base.Joiner;
import com.google.inject.Inject;
import net.oauth.OAuthServiceProvider;
import org.apache.shindig.auth.SecurityToken;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.GadgetSpecFactory;
import org.apache.shindig.gadgets.oauth.AccessorInfo;
import org.apache.shindig.gadgets.oauth.AccessorInfoBuilder;
import org.apache.shindig.gadgets.oauth.OAuthArguments;
import org.apache.shindig.gadgets.oauth.OAuthClientState;
import org.apache.shindig.gadgets.oauth.OAuthError;
import org.apache.shindig.gadgets.oauth.OAuthFetcherConfig;
import org.apache.shindig.gadgets.oauth.OAuthGadgetContext;
import org.apache.shindig.gadgets.oauth.OAuthRequestException;
import org.apache.shindig.gadgets.oauth.OAuthResponseParams;
import org.apache.shindig.gadgets.oauth.OAuthStore;
import org.apache.shindig.gadgets.spec.BaseOAuthService;
import org.apache.shindig.gadgets.spec.GadgetSpec;
import org.apache.shindig.gadgets.spec.OAuthService;
import org.apache.shindig.gadgets.spec.OAuthSpec;
import org.apache.shindig.gadgets.spec.SpecParserException;

public class GadgetOAuthTokenStore {
    private final OAuthStore store;
    private final GadgetSpecFactory specFactory;

    @Inject
    public GadgetOAuthTokenStore(OAuthStore store, GadgetSpecFactory specFactory) {
        this.store = store;
        this.specFactory = specFactory;
    }

    public AccessorInfo getOAuthAccessor(SecurityToken securityToken, OAuthArguments arguments, OAuthClientState clientState, OAuthResponseParams responseParams, OAuthFetcherConfig fetcherConfig) throws OAuthRequestException {
        OAuthStore.ConsumerInfo consumer;
        AccessorInfoBuilder accessorBuilder = new AccessorInfoBuilder();
        OAuthServiceProvider provider = null;
        if (arguments.programmaticConfig()) {
            provider = this.loadProgrammaticConfig(arguments, accessorBuilder, responseParams);
        } else if (arguments.mayUseToken()) {
            provider = this.lookupSpecInfo(securityToken, arguments, accessorBuilder, responseParams);
        } else {
            accessorBuilder.setParameterLocation(AccessorInfo.OAuthParamLocation.URI_QUERY);
        }
        try {
            consumer = this.store.getConsumerKeyAndSecret(securityToken, arguments.getServiceName(), provider);
            accessorBuilder.setConsumer(consumer);
        }
        catch (GadgetException e) {
            throw new OAuthRequestException(OAuthError.UNKNOWN_PROBLEM, "Unable to retrieve consumer key", (Throwable)e);
        }
        if (arguments.mayUseToken() && securityToken.getViewerId() != null && (fetcherConfig != null && fetcherConfig.isViewerAccessTokensEnabled() || securityToken.getViewerId().equals(securityToken.getOwnerId()))) {
            this.lookupToken(securityToken, consumer, arguments, clientState, accessorBuilder, responseParams);
        }
        return accessorBuilder.create(responseParams);
    }

    private OAuthServiceProvider lookupSpecInfo(SecurityToken securityToken, OAuthArguments arguments, AccessorInfoBuilder accessorBuilder, OAuthResponseParams responseParams) throws OAuthRequestException {
        GadgetSpec spec = this.findSpec(securityToken, arguments, responseParams);
        OAuthSpec oauthSpec = spec.getModulePrefs().getOAuthSpec();
        if (oauthSpec == null) {
            throw new OAuthRequestException(OAuthError.BAD_OAUTH_CONFIGURATION, "Failed to retrieve OAuth URLs, spec for gadget " + securityToken.getAppUrl() + " does not contain OAuth element.");
        }
        OAuthService service = oauthSpec.getServices().get(arguments.getServiceName());
        if (service == null) {
            throw new OAuthRequestException(OAuthError.BAD_OAUTH_CONFIGURATION, "Failed to retrieve OAuth URLs, spec for gadget does not contain OAuth service " + arguments.getServiceName() + ".  Known services: " + Joiner.on((char)',').join(oauthSpec.getServices().keySet()) + '.');
        }
        accessorBuilder.setParameterLocation(this.getStoreLocation(service.getRequestUrl().location, responseParams));
        accessorBuilder.setMethod(this.getStoreMethod(service.getRequestUrl().method, responseParams));
        return new OAuthServiceProvider(service.getRequestUrl().url.toJavaUri().toASCIIString(), service.getAuthorizationUrl().toJavaUri().toASCIIString(), service.getAccessUrl().url.toJavaUri().toASCIIString());
    }

    private OAuthServiceProvider loadProgrammaticConfig(OAuthArguments arguments, AccessorInfoBuilder accessorBuilder, OAuthResponseParams responseParams) throws OAuthRequestException {
        try {
            String paramLocationStr = arguments.getRequestOption("OAUTH_PARAM_LOCATION", "");
            BaseOAuthService.Location l = BaseOAuthService.Location.parse(paramLocationStr);
            accessorBuilder.setParameterLocation(this.getStoreLocation(l, responseParams));
            String requestMethod = arguments.getRequestOption("OAUTH_REQUEST_METHOD", "GET");
            BaseOAuthService.Method m = BaseOAuthService.Method.parse(requestMethod);
            accessorBuilder.setMethod(this.getStoreMethod(m, responseParams));
            String requestTokenUrl = arguments.getRequestOption("OAUTH_REQUEST_TOKEN_URL");
            this.verifyUrl(requestTokenUrl, responseParams);
            String accessTokenUrl = arguments.getRequestOption("OAUTH_ACCESS_TOKEN_URL");
            this.verifyUrl(accessTokenUrl, responseParams);
            String authorizationUrl = arguments.getRequestOption("OAUTH_AUTHORIZATION_URL");
            this.verifyUrl(authorizationUrl, responseParams);
            return new OAuthServiceProvider(requestTokenUrl, authorizationUrl, accessTokenUrl);
        }
        catch (SpecParserException e) {
            throw new OAuthRequestException(OAuthError.BAD_OAUTH_CONFIGURATION, e.getMessage());
        }
    }

    private void verifyUrl(String url, OAuthResponseParams responseParams) throws OAuthRequestException {
        Uri uri;
        if (url == null) {
            return;
        }
        try {
            uri = Uri.parse((String)url);
        }
        catch (Throwable t) {
            throw new OAuthRequestException(OAuthError.INVALID_URL, url);
        }
        if (!uri.isAbsolute()) {
            throw new OAuthRequestException(OAuthError.INVALID_URL, url);
        }
    }

    private void lookupToken(SecurityToken securityToken, OAuthStore.ConsumerInfo consumerInfo, OAuthArguments arguments, OAuthClientState clientState, AccessorInfoBuilder accessorBuilder, OAuthResponseParams responseParams) throws OAuthRequestException {
        if (clientState.getRequestToken() != null) {
            accessorBuilder.setRequestToken(clientState.getRequestToken());
            accessorBuilder.setTokenSecret(clientState.getRequestTokenSecret());
        } else if (clientState.getAccessToken() != null) {
            accessorBuilder.setAccessToken(clientState.getAccessToken());
            accessorBuilder.setTokenSecret(clientState.getAccessTokenSecret());
            accessorBuilder.setSessionHandle(clientState.getSessionHandle());
            accessorBuilder.setTokenExpireMillis(clientState.getTokenExpireMillis());
        } else {
            OAuthStore.TokenInfo tokenInfo;
            try {
                tokenInfo = this.store.getTokenInfo(securityToken, consumerInfo, arguments.getServiceName(), arguments.getTokenName());
            }
            catch (GadgetException e) {
                throw new OAuthRequestException(OAuthError.UNKNOWN_PROBLEM, "Unable to retrieve access token", (Throwable)e);
            }
            if (tokenInfo != null && tokenInfo.getAccessToken() != null) {
                accessorBuilder.setAccessToken(tokenInfo.getAccessToken());
                accessorBuilder.setTokenSecret(tokenInfo.getTokenSecret());
                accessorBuilder.setSessionHandle(tokenInfo.getSessionHandle());
                accessorBuilder.setTokenExpireMillis(tokenInfo.getTokenExpireMillis());
            } else {
                accessorBuilder.setRequestToken(arguments.getRequestToken());
                accessorBuilder.setTokenSecret(arguments.getRequestTokenSecret());
            }
        }
    }

    private AccessorInfo.OAuthParamLocation getStoreLocation(BaseOAuthService.Location location, OAuthResponseParams responseParams) throws OAuthRequestException {
        switch (location) {
            case HEADER: {
                return AccessorInfo.OAuthParamLocation.AUTH_HEADER;
            }
            case URL: {
                return AccessorInfo.OAuthParamLocation.URI_QUERY;
            }
            case BODY: {
                return AccessorInfo.OAuthParamLocation.POST_BODY;
            }
        }
        throw new OAuthRequestException(OAuthError.UNKNOWN_PARAMETER_LOCATION);
    }

    private AccessorInfo.HttpMethod getStoreMethod(BaseOAuthService.Method method, OAuthResponseParams responseParams) throws OAuthRequestException {
        switch (method) {
            case GET: {
                return AccessorInfo.HttpMethod.GET;
            }
            case POST: {
                return AccessorInfo.HttpMethod.POST;
            }
        }
        throw new OAuthRequestException(OAuthError.UNSUPPORTED_HTTP_METHOD, method.toString());
    }

    private GadgetSpec findSpec(SecurityToken securityToken, OAuthArguments arguments, OAuthResponseParams responseParams) throws OAuthRequestException {
        try {
            OAuthGadgetContext context = new OAuthGadgetContext(securityToken, arguments);
            return this.specFactory.getGadgetSpec(context);
        }
        catch (IllegalArgumentException e) {
            throw new OAuthRequestException(OAuthError.UNKNOWN_PROBLEM, "Could not fetch gadget spec, gadget URI invalid.", (Throwable)e);
        }
        catch (GadgetException e) {
            throw new OAuthRequestException(OAuthError.UNKNOWN_PROBLEM, "Could not fetch gadget spec", (Throwable)e);
        }
    }

    public void storeTokenKeyAndSecret(SecurityToken securityToken, OAuthStore.ConsumerInfo consumerInfo, OAuthArguments arguments, OAuthStore.TokenInfo tokenInfo, OAuthResponseParams responseParams) throws OAuthRequestException {
        try {
            this.store.setTokenInfo(securityToken, consumerInfo, arguments.getServiceName(), arguments.getTokenName(), tokenInfo);
        }
        catch (GadgetException e) {
            throw new OAuthRequestException(OAuthError.UNKNOWN_PROBLEM, "Unable to store access token", (Throwable)e);
        }
    }

    public void removeToken(SecurityToken securityToken, OAuthStore.ConsumerInfo consumerInfo, OAuthArguments arguments, OAuthResponseParams responseParams) throws OAuthRequestException {
        try {
            this.store.removeToken(securityToken, consumerInfo, arguments.getServiceName(), arguments.getTokenName());
        }
        catch (GadgetException e) {
            throw new OAuthRequestException(OAuthError.UNKNOWN_PROBLEM, "Unable to remove access token", (Throwable)e);
        }
    }
}

