/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.oauth2.handler;

import com.google.common.collect.Maps;
import com.google.inject.Inject;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.List;
import org.apache.shindig.auth.AnonymousSecurityToken;
import org.apache.shindig.auth.SecurityToken;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.gadgets.http.HttpRequest;
import org.apache.shindig.gadgets.oauth2.OAuth2Accessor;
import org.apache.shindig.gadgets.oauth2.OAuth2Error;
import org.apache.shindig.gadgets.oauth2.OAuth2RequestException;
import org.apache.shindig.gadgets.oauth2.OAuth2Utils;
import org.apache.shindig.gadgets.oauth2.handler.ClientAuthenticationHandler;
import org.apache.shindig.gadgets.oauth2.handler.GrantRequestHandler;
import org.apache.shindig.gadgets.oauth2.handler.OAuth2HandlerError;

public class ClientCredentialsGrantTypeHandler
implements GrantRequestHandler {
    private static final OAuth2Error ERROR = OAuth2Error.CLIENT_CREDENTIALS_PROBLEM;
    private final List<ClientAuthenticationHandler> clientAuthenticationHandlers;

    @Inject
    public ClientCredentialsGrantTypeHandler(List<ClientAuthenticationHandler> clientAuthenticationHandlers) {
        this.clientAuthenticationHandlers = clientAuthenticationHandlers;
    }

    private String getAuthorizationBody(OAuth2Accessor accessor) throws OAuth2RequestException {
        String secret;
        String ret = "";
        HashMap queryParams = Maps.newHashMap();
        queryParams.put("grant_type", this.getGrantType());
        String clientId = accessor.getClientId();
        byte[] secretBytes = accessor.getClientSecret();
        try {
            secret = new String(secretBytes, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new OAuth2RequestException(OAuth2Error.CLIENT_CREDENTIALS_PROBLEM, "error getting authorization body", e);
        }
        queryParams.put("client_id", clientId);
        queryParams.put("client_secret", secret);
        ret = OAuth2Utils.buildUrl(ret, queryParams, null);
        char firstChar = ret.charAt(0);
        if (firstChar == '?' || firstChar == '&') {
            ret = ret.substring(1);
        }
        return ret;
    }

    @Override
    public HttpRequest getAuthorizationRequest(OAuth2Accessor accessor, String completeAuthorizationUrl) throws OAuth2RequestException {
        if (completeAuthorizationUrl == null || completeAuthorizationUrl.length() == 0) {
            throw new OAuth2RequestException(ERROR, "completeAuthorizationUrl is null", null);
        }
        if (accessor == null) {
            throw new OAuth2RequestException(ERROR, "accessor is null", null);
        }
        if (!accessor.isValid() || accessor.isErrorResponse() || accessor.isRedirecting()) {
            throw new OAuth2RequestException(ERROR, "accessor is invalid", null);
        }
        if (!accessor.getGrantType().equalsIgnoreCase("client_credentials")) {
            throw new OAuth2RequestException(ERROR, "grant type is not client_credentials", null);
        }
        HttpRequest request = new HttpRequest(Uri.parse((String)completeAuthorizationUrl));
        request.setMethod("GET");
        request.setHeader("Content-Type", "application/x-www-form-urlencoded; charset=utf-8");
        request.setSecurityToken((SecurityToken)new AnonymousSecurityToken("", Long.valueOf(0L), accessor.getGadgetUri()));
        for (ClientAuthenticationHandler clientAuthenticationHandler : this.clientAuthenticationHandlers) {
            OAuth2HandlerError error;
            if (!clientAuthenticationHandler.geClientAuthenticationType().equalsIgnoreCase(accessor.getClientAuthenticationType()) || (error = clientAuthenticationHandler.addOAuth2Authentication(request, accessor)) == null) continue;
            throw new OAuth2RequestException(error.getError(), error.getContextMessage(), error.getCause(), error.getUri(), error.getDescription());
        }
        try {
            request.setPostBody(this.getAuthorizationBody(accessor).getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new OAuth2RequestException(OAuth2Error.CLIENT_CREDENTIALS_PROBLEM, "ClientCredentialsGrantTypeHandler - exception setting post body", e);
        }
        return request;
    }

    @Override
    public String getCompleteUrl(OAuth2Accessor accessor) throws OAuth2RequestException {
        String ret;
        if (accessor == null) {
            throw new OAuth2RequestException(ERROR, "accessor is null", null);
        }
        if (!accessor.isValid() || accessor.isErrorResponse() || accessor.isRedirecting()) {
            throw new OAuth2RequestException(ERROR, "accessor is invalid", null);
        }
        if (!accessor.getGrantType().equalsIgnoreCase("client_credentials")) {
            throw new OAuth2RequestException(ERROR, "grant type is not client_credentials", null);
        }
        try {
            HashMap queryParams = Maps.newHashMapWithExpectedSize((int)4);
            queryParams.put("grant_type", this.getGrantType());
            String clientId = accessor.getClientId();
            byte[] secretBytes = accessor.getClientSecret();
            String secret = new String(secretBytes, "UTF-8");
            queryParams.put("client_id", clientId);
            queryParams.put("client_secret", secret);
            String scope = accessor.getScope();
            if (scope != null && scope.length() > 0) {
                queryParams.put("scope", scope);
            }
            ret = OAuth2Utils.buildUrl(accessor.getTokenUrl(), queryParams, null);
        }
        catch (UnsupportedEncodingException e) {
            throw new OAuth2RequestException(OAuth2Error.CLIENT_CREDENTIALS_PROBLEM, "problem getting complete url", e);
        }
        return ret;
    }

    @Override
    public String getGrantType() {
        return "client_credentials";
    }

    @Override
    public boolean isAuthorizationEndpointResponse() {
        return false;
    }

    @Override
    public boolean isRedirectRequired() {
        return false;
    }

    @Override
    public boolean isTokenEndpointResponse() {
        return true;
    }
}

