/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.oauth2.handler;

import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import org.apache.commons.codec.binary.Base64;
import org.apache.shindig.common.crypto.Crypto;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.gadgets.http.HttpRequest;
import org.apache.shindig.gadgets.oauth2.OAuth2Accessor;
import org.apache.shindig.gadgets.oauth2.OAuth2Error;
import org.apache.shindig.gadgets.oauth2.OAuth2Token;
import org.apache.shindig.gadgets.oauth2.handler.OAuth2HandlerError;
import org.apache.shindig.gadgets.oauth2.handler.ResourceRequestHandler;

public class MacTokenHandler
implements ResourceRequestHandler {
    public static final String TOKEN_TYPE = "mac";
    private static final OAuth2Error ERROR = OAuth2Error.MAC_TOKEN_PROBLEM;

    @Override
    public OAuth2HandlerError addOAuth2Params(OAuth2Accessor accessor, HttpRequest request) {
        try {
            OAuth2HandlerError handlerError = MacTokenHandler.validateOAuth2Params(accessor, request);
            if (handlerError != null) {
                return handlerError;
            }
            OAuth2Token accessToken = accessor.getAccessToken();
            String ext = accessToken.getMacExt();
            if (ext == null || ext.length() == 0) {
                ext = "";
            }
            String id = new String(accessToken.getSecret(), "UTF-8");
            long currentTime = System.currentTimeMillis() / 1000L;
            String nonce = Long.toString(currentTime - accessToken.getIssuedAt()) + ':' + String.valueOf(Math.abs(Crypto.RAND.nextLong()));
            String bodyHash = MacTokenHandler.getBodyHash(request, accessToken.getMacSecret(), accessToken.getMacAlgorithm());
            if (bodyHash == null) {
                bodyHash = "";
            }
            Uri uri = request.getUri();
            String uriString = uri.getPath();
            if (uri.getQuery() != null) {
                uriString = uriString + '?' + uri.getQuery();
            }
            String host = uri.getAuthority();
            String port = "80";
            int index = host.indexOf(58);
            if (index > 0) {
                port = host.substring(index + 1);
                host = host.substring(0, index);
            } else {
                String scheme = uri.getScheme();
                if ("https".equals(scheme)) {
                    port = "443";
                }
            }
            String mac = MacTokenHandler.getMac(nonce, request.getMethod(), uriString, host, port, bodyHash, ext, accessToken.getMacSecret(), accessToken.getMacAlgorithm());
            String headerString = MacTokenHandler.buildHeaderString(id, nonce, bodyHash, ext, mac);
            request.setHeader("Authorization", headerString);
            return null;
        }
        catch (Exception e) {
            return MacTokenHandler.getError("Exception occurred " + e.getMessage(), e);
        }
    }

    private static String buildHeaderString(String id, String nonce, String bodyHash, String ext, String mac) {
        StringBuilder headerString = new StringBuilder();
        headerString.append("MAC");
        headerString.append(" id = \"");
        headerString.append(id);
        headerString.append("\",");
        headerString.append("nonce");
        headerString.append("=\"");
        headerString.append(nonce);
        if (bodyHash.length() > 0) {
            headerString.append("\",");
            headerString.append("bodyhash");
            headerString.append("=\"");
            headerString.append(bodyHash);
        }
        if (ext.length() > 0) {
            headerString.append("\",");
            headerString.append("ext");
            headerString.append("=\"");
            headerString.append(ext);
        }
        headerString.append("\",");
        headerString.append(TOKEN_TYPE);
        headerString.append("=\"");
        headerString.append(mac);
        headerString.append('\"');
        return headerString.toString();
    }

    private static OAuth2HandlerError validateOAuth2Params(OAuth2Accessor accessor, HttpRequest request) {
        if (accessor == null || !accessor.isValid() || accessor.isErrorResponse()) {
            return MacTokenHandler.getError("accessor is invalid " + accessor);
        }
        if (request == null) {
            return MacTokenHandler.getError("request is null");
        }
        OAuth2Token accessToken = accessor.getAccessToken();
        if (accessToken == null || accessToken.getTokenType().length() == 0) {
            return MacTokenHandler.getError("accessToken is invalid " + accessToken);
        }
        if (!TOKEN_TYPE.equalsIgnoreCase(accessToken.getTokenType())) {
            return MacTokenHandler.getError("token type mismatch expected mac but got " + accessToken.getTokenType());
        }
        String algorithm = accessToken.getMacAlgorithm();
        if (algorithm == null || algorithm.length() == 0) {
            return MacTokenHandler.getError("invalid mac algorithm " + algorithm);
        }
        if (!"hmac-sha-1".equalsIgnoreCase(algorithm)) {
            return MacTokenHandler.getError("unsupported algorithm " + algorithm);
        }
        byte[] macSecret = accessToken.getMacSecret();
        if (macSecret == null) {
            return MacTokenHandler.getError("mac secret is null");
        }
        if (macSecret.length == 0) {
            return MacTokenHandler.getError("invalid mac secret");
        }
        return null;
    }

    @Override
    public String getTokenType() {
        return TOKEN_TYPE;
    }

    private static String getBodyHash(HttpRequest request, byte[] key, String algorithm) throws UnsupportedEncodingException, GeneralSecurityException {
        if (request.getPostBodyLength() > 0) {
            byte[] text = MacTokenHandler.getBody(request);
            byte[] hashed = MacTokenHandler.hash(text, key, algorithm);
            return new String(hashed, "UTF-8");
        }
        return "";
    }

    private static byte[] getBody(HttpRequest request) throws UnsupportedEncodingException {
        return request.getPostBodyAsString().getBytes("UTF-8");
    }

    private static String getMac(String nonce, String method, String uri, String host, String port, String bodyHash, String ext, byte[] key, String algorithm) throws UnsupportedEncodingException, GeneralSecurityException {
        StringBuilder normalizedRequestString = MacTokenHandler.getNormalizedRequestString(nonce, method, uri, host, port, bodyHash, ext);
        byte[] normalizedRequestBytes = normalizedRequestString.toString().getBytes("UTF-8");
        byte[] mac = MacTokenHandler.hash(normalizedRequestBytes, key, algorithm);
        byte[] encodedBytes = Base64.encodeBase64((byte[])mac);
        return new String(encodedBytes, "UTF-8");
    }

    private static byte[] hash(byte[] text, byte[] key, String algorithm) throws GeneralSecurityException {
        if ("hmac-sha-1".equalsIgnoreCase(algorithm)) {
            return Crypto.hmacSha1((byte[])key, (byte[])text);
        }
        return new byte[0];
    }

    private static StringBuilder getNormalizedRequestString(String nonce, String method, String uri, String host, String port, String bodyHash, String ext) {
        StringBuilder ret = new StringBuilder();
        ret.append(nonce);
        ret.append('\n');
        ret.append(method);
        ret.append('\n');
        ret.append(uri);
        ret.append('\n');
        ret.append(host);
        ret.append('\n');
        ret.append(port);
        ret.append('\n');
        ret.append(bodyHash);
        ret.append('\n');
        ret.append(ext);
        ret.append('\n');
        return ret;
    }

    private static OAuth2HandlerError getError(String contextMessage) {
        return MacTokenHandler.getError(contextMessage, null);
    }

    private static OAuth2HandlerError getError(String contextMessage, Exception e) {
        return new OAuth2HandlerError(ERROR, contextMessage, e);
    }
}

