/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.oauth2.persistence;

import java.util.Collection;
import java.util.Map;
import org.apache.shindig.gadgets.oauth2.OAuth2Accessor;
import org.apache.shindig.gadgets.oauth2.OAuth2CallbackState;
import org.apache.shindig.gadgets.oauth2.OAuth2Token;
import org.apache.shindig.gadgets.oauth2.persistence.OAuth2Cache;
import org.apache.shindig.gadgets.oauth2.persistence.OAuth2CacheException;
import org.apache.shindig.gadgets.oauth2.persistence.OAuth2Client;

public abstract class MapCache
implements OAuth2Cache {
    protected abstract Map<String, OAuth2Client> getClientMap();

    protected abstract Map<String, OAuth2Token> getTokenMap();

    protected abstract Map<String, OAuth2Accessor> getAccessorMap();

    @Override
    public void clearClients() throws OAuth2CacheException {
        this.getClientMap().clear();
    }

    @Override
    public void clearTokens() throws OAuth2CacheException {
        this.getTokenMap().clear();
    }

    @Override
    public void clearAccessors() {
        this.getAccessorMap().clear();
    }

    @Override
    public void storeTokens(Collection<OAuth2Token> storeTokens) throws OAuth2CacheException {
        if (storeTokens != null) {
            for (OAuth2Token token : storeTokens) {
                this.storeToken(token);
            }
        }
    }

    @Override
    public boolean isPrimed() {
        return false;
    }

    @Override
    public OAuth2Client getClient(String gadgetUri, String serviceName) {
        OAuth2Client ret = null;
        String clientKey = this.getClientKey(gadgetUri, serviceName);
        if (clientKey != null) {
            ret = this.getClientMap().get(clientKey);
        }
        return ret;
    }

    @Override
    public OAuth2Accessor getOAuth2Accessor(OAuth2CallbackState state) {
        OAuth2Accessor ret = null;
        String accessorKey = this.getAccessorKey(state);
        if (accessorKey != null) {
            ret = this.getAccessorMap().get(accessorKey);
        }
        return ret;
    }

    @Override
    public OAuth2Token getToken(String gadgetUri, String serviceName, String user, String scope, OAuth2Token.Type type) {
        OAuth2Token ret = null;
        String tokenKey = this.getTokenKey(gadgetUri, serviceName, user, scope, type);
        if (tokenKey != null) {
            ret = this.getTokenMap().get(tokenKey);
        }
        return ret;
    }

    @Override
    public OAuth2Client removeClient(OAuth2Client client) {
        OAuth2Client ret = null;
        String clientKey = this.getClientKey(client);
        if (clientKey != null) {
            ret = this.getClientMap().remove(clientKey);
        }
        return ret;
    }

    @Override
    public OAuth2Accessor removeOAuth2Accessor(OAuth2Accessor accessor) {
        OAuth2Accessor ret = null;
        String accessorKey = this.getAccessorKey(accessor);
        if (accessorKey != null) {
            ret = this.getAccessorMap().remove(accessorKey);
        }
        return ret;
    }

    @Override
    public OAuth2Token removeToken(OAuth2Token token) {
        OAuth2Token ret = null;
        String tokenKey = this.getTokenKey(token);
        if (tokenKey != null) {
            ret = this.getTokenMap().remove(tokenKey);
        }
        return ret;
    }

    @Override
    public void storeClient(OAuth2Client client) throws OAuth2CacheException {
        if (client != null) {
            String clientKey = this.getClientKey(client.getGadgetUri(), client.getServiceName());
            this.getClientMap().put(clientKey, client);
        }
    }

    @Override
    public void storeClients(Collection<OAuth2Client> clients) throws OAuth2CacheException {
        if (clients != null) {
            for (OAuth2Client client : clients) {
                this.storeClient(client);
            }
        }
    }

    @Override
    public void storeOAuth2Accessor(OAuth2Accessor accessor) {
        if (accessor != null) {
            String accessorKey = this.getAccessorKey(accessor);
            this.getAccessorMap().put(accessorKey, accessor);
        }
    }

    @Override
    public void storeToken(OAuth2Token token) throws OAuth2CacheException {
        if (token != null) {
            String tokenKey = this.getTokenKey(token);
            this.getTokenMap().put(tokenKey, token);
        }
    }

    protected String getClientKey(OAuth2Client client) {
        return this.getClientKey(client.getGadgetUri(), client.getServiceName());
    }

    protected String getClientKey(String gadgetUri, String serviceName) {
        if (gadgetUri == null || serviceName == null) {
            return null;
        }
        StringBuilder buf = new StringBuilder(gadgetUri.length() + serviceName.length() + 1);
        buf.append(gadgetUri);
        buf.append(':');
        buf.append(serviceName);
        return buf.toString();
    }

    protected String getAccessorKey(OAuth2CallbackState state) {
        return this.getAccessorKey(state.getGadgetUri(), state.getServiceName(), state.getUser(), state.getScope());
    }

    private String getAccessorKey(String gadgetUri, String serviceName, String user, String scope) {
        if (gadgetUri == null || serviceName == null || user == null) {
            return null;
        }
        String s = scope == null ? "" : scope;
        StringBuilder buf = new StringBuilder(gadgetUri.length() + serviceName.length() + user.length() + s.length() + 3);
        buf.append(gadgetUri);
        buf.append(':');
        buf.append(serviceName);
        buf.append(':');
        buf.append(user);
        buf.append(':');
        buf.append(s);
        return buf.toString();
    }

    protected String getAccessorKey(OAuth2Accessor accessor) {
        return this.getAccessorKey(accessor.getGadgetUri(), accessor.getServiceName(), accessor.getUser(), accessor.getScope());
    }

    protected String getTokenKey(String gadgetUri, String serviceName, String user, String scope, OAuth2Token.Type type) {
        if (gadgetUri == null || serviceName == null || user == null) {
            return null;
        }
        String s = scope == null ? "" : scope;
        String t = type.name();
        StringBuilder buf = new StringBuilder(gadgetUri.length() + serviceName.length() + user.length() + s.length() + t.length() + 4);
        buf.append(gadgetUri);
        buf.append(':');
        buf.append(serviceName);
        buf.append(':');
        buf.append(user);
        buf.append(':');
        buf.append(s);
        buf.append(':');
        buf.append(t);
        return buf.toString();
    }

    protected String getTokenKey(OAuth2Token token) {
        return this.getTokenKey(token.getGadgetUri(), token.getServiceName(), token.getUser(), token.getScope(), token.getType());
    }
}

