/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.oauth2.persistence.sample;

import com.google.caja.util.Maps;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.shindig.common.Nullable;
import org.apache.shindig.common.servlet.Authority;
import org.apache.shindig.common.util.ResourceLoader;
import org.apache.shindig.gadgets.oauth2.OAuth2Accessor;
import org.apache.shindig.gadgets.oauth2.OAuth2Token;
import org.apache.shindig.gadgets.oauth2.logger.FilteredLogger;
import org.apache.shindig.gadgets.oauth2.persistence.OAuth2Client;
import org.apache.shindig.gadgets.oauth2.persistence.OAuth2Encrypter;
import org.apache.shindig.gadgets.oauth2.persistence.OAuth2EncryptionException;
import org.apache.shindig.gadgets.oauth2.persistence.OAuth2PersistenceException;
import org.apache.shindig.gadgets.oauth2.persistence.OAuth2Persister;
import org.apache.shindig.gadgets.oauth2.persistence.OAuth2TokenPersistence;
import org.apache.shindig.gadgets.oauth2.persistence.sample.OAuth2GadgetBinding;
import org.apache.shindig.gadgets.oauth2.persistence.sample.OAuth2Provider;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Singleton
public class JSONOAuth2Persister
implements OAuth2Persister {
    private static final String ALLOW_MODULE_OVERRIDE = "allowModuleOverride";
    private static final String AUTHORIZATION_HEADER = "usesAuthorizationHeader";
    private static final String AUTHORIZATION_URL = "authorizationUrl";
    private static final String CLIENT_AUTHENTICATION = "client_authentication";
    private static final String CLIENT_NAME = "clientName";
    private static final String CLIENTS = "clients";
    private static final String ENDPOINTS = "endpoints";
    private static final String GADGET_BINDGINGS = "gadgetBindings";
    private static final String NO_CLIENT_AUTHENTICATION = "NONE";
    private static final String OAUTH2_CONFIG = "config/oauth2.json";
    private static final String PROVIDER_NAME = "providerName";
    private static final String PROVIDERS = "providers";
    private static final String TOKEN_URL = "tokenUrl";
    private static final String TYPE = "type";
    private static final String URL_PARAMETER = "usesUrlParameter";
    private static final String ALLOWED_DOMAINS = "allowedDomains";
    private final JSONObject configFile;
    private final String contextRoot;
    private final OAuth2Encrypter encrypter;
    private final String globalRedirectUri;
    private final Authority authority;
    private static final String LOG_CLASS = JSONOAuth2Persister.class.getName();
    private static final FilteredLogger LOG = FilteredLogger.getFilteredLogger(LOG_CLASS);

    @Inject
    public JSONOAuth2Persister(OAuth2Encrypter encrypter, Authority authority, String globalRedirectUri, @Nullable @Named(value="shindig.contextroot") String contextRoot) throws OAuth2PersistenceException {
        this.encrypter = encrypter;
        this.authority = authority;
        this.globalRedirectUri = globalRedirectUri;
        this.contextRoot = contextRoot;
        try {
            this.configFile = new JSONObject(JSONOAuth2Persister.getJSONString(OAUTH2_CONFIG));
        }
        catch (Exception e) {
            if (LOG.isLoggable()) {
                LOG.log("OAuth2PersistenceException", e);
            }
            throw new OAuth2PersistenceException(e);
        }
    }

    public JSONOAuth2Persister(OAuth2Encrypter encrypter, Authority authority, String globalRedirectUri, @Nullable @Named(value="shindig.contextroot") String contextRoot, JSONObject configFile) {
        this.encrypter = encrypter;
        this.authority = authority;
        this.globalRedirectUri = globalRedirectUri;
        this.contextRoot = contextRoot;
        this.configFile = configFile;
    }

    public OAuth2Token createToken() {
        return new OAuth2TokenPersistence(this.encrypter);
    }

    public static OAuth2Client findClient(Integer index) {
        return null;
    }

    @Override
    public OAuth2Client findClient(String providerName, String gadgetUri) throws OAuth2PersistenceException {
        return null;
    }

    public static OAuth2Provider findProvider(Integer index) {
        return null;
    }

    public static OAuth2Provider findProvider(String providerName) {
        return null;
    }

    public static OAuth2Token findToken(Integer index) {
        return null;
    }

    @Override
    public OAuth2Token findToken(String providerName, String gadgetUri, String user, String scope, OAuth2Token.Type type) throws OAuth2PersistenceException {
        return null;
    }

    @Override
    public void insertToken(OAuth2Token token) {
    }

    @Override
    public Set<OAuth2Client> loadClients() throws OAuth2PersistenceException {
        Map<String, OAuth2GadgetBinding> gadgetBindings = this.loadGadgetBindings();
        Map<String, OAuth2Provider> providers = this.loadProviders();
        Map internalMap = Maps.newHashMap();
        try {
            JSONObject clients = this.configFile.getJSONObject(CLIENTS);
            Iterator j = clients.keys();
            while (j.hasNext()) {
                String clientName = (String)j.next();
                JSONObject settings = clients.getJSONObject(clientName);
                OAuth2Client client = new OAuth2Client(this.encrypter);
                String providerName = settings.getString(PROVIDER_NAME);
                OAuth2Provider provider = providers.get(providerName);
                client.setAuthorizationUrl(provider.getAuthorizationUrl());
                client.setClientAuthenticationType(provider.getClientAuthenticationType());
                client.setAuthorizationHeader(provider.isAuthorizationHeader());
                client.setUrlParameter(provider.isUrlParameter());
                client.setTokenUrl(provider.getTokenUrl());
                String redirectUri = settings.optString("redirect_uri", null);
                if (redirectUri == null) {
                    redirectUri = this.globalRedirectUri;
                }
                String secret = settings.optString("client_secret");
                String clientId = settings.getString("client_id");
                String typeS = settings.optString(TYPE, null);
                String grantType = settings.optString("grant_type", null);
                String sharedToken = settings.optString("sharedToken", "false");
                if ("true".equalsIgnoreCase(sharedToken)) {
                    client.setSharedToken(true);
                }
                try {
                    client.setEncryptedSecret(secret.getBytes("UTF-8"));
                }
                catch (OAuth2EncryptionException e) {
                    throw new OAuth2PersistenceException(e);
                }
                client.setClientId(clientId);
                if (this.authority != null) {
                    redirectUri = redirectUri.replace("%authority%", this.authority.getAuthority());
                    redirectUri = redirectUri.replace("%contextRoot%", this.contextRoot);
                    redirectUri = redirectUri.replace("%origin%", this.authority.getOrigin());
                    redirectUri = redirectUri.replace("%scheme", this.authority.getScheme());
                }
                client.setRedirectUri(redirectUri);
                if (grantType == null || grantType.length() == 0) {
                    grantType = "code";
                }
                client.setGrantType(grantType);
                OAuth2Accessor.Type type = OAuth2Accessor.Type.UNKNOWN;
                if ("confidential".equals(typeS)) {
                    type = OAuth2Accessor.Type.CONFIDENTIAL;
                } else if ("public".equals(typeS)) {
                    type = OAuth2Accessor.Type.PUBLIC;
                }
                client.setType(type);
                JSONArray dArray = settings.optJSONArray(ALLOWED_DOMAINS);
                if (dArray != null) {
                    ArrayList<String> domains = new ArrayList<String>();
                    for (int i = 0; i < dArray.length(); ++i) {
                        domains.add(dArray.optString(i));
                    }
                    client.setAllowedDomains(domains.toArray(new String[0]));
                }
                internalMap.put(clientName, client);
            }
        }
        catch (Exception e) {
            if (LOG.isLoggable()) {
                LOG.log("OAuth2PersistenceException", e);
            }
            throw new OAuth2PersistenceException(e);
        }
        HashSet<OAuth2Client> ret = new HashSet<OAuth2Client>(gadgetBindings.size());
        for (OAuth2GadgetBinding binding : gadgetBindings.values()) {
            String clientName = binding.getClientName();
            OAuth2Client cachedClient = (OAuth2Client)internalMap.get(clientName);
            OAuth2Client client = cachedClient.clone();
            client.setGadgetUri(binding.getGadgetUri());
            client.setServiceName(binding.getGadgetServiceName());
            client.setAllowModuleOverride(binding.isAllowOverride());
            ret.add(client);
        }
        return ret;
    }

    private Map<String, OAuth2GadgetBinding> loadGadgetBindings() throws OAuth2PersistenceException {
        Map ret = Maps.newHashMap();
        try {
            JSONObject bindings = this.configFile.getJSONObject(GADGET_BINDGINGS);
            Iterator i = bindings.keys();
            while (i.hasNext()) {
                String gadgetUriS = (String)i.next();
                String gadgetUri = null;
                if (this.authority != null) {
                    gadgetUri = gadgetUriS.replace("%authority%", this.authority.getAuthority());
                    gadgetUri = gadgetUri.replace("%contextRoot%", this.contextRoot);
                    gadgetUri = gadgetUri.replace("%origin%", this.authority.getOrigin());
                    gadgetUri = gadgetUri.replace("%scheme%", this.authority.getScheme());
                }
                JSONObject binding = bindings.getJSONObject(gadgetUriS);
                Iterator j = binding.keys();
                while (j.hasNext()) {
                    String gadgetServiceName = (String)j.next();
                    JSONObject settings = binding.getJSONObject(gadgetServiceName);
                    String clientName = settings.getString(CLIENT_NAME);
                    boolean allowOverride = settings.getBoolean(ALLOW_MODULE_OVERRIDE);
                    OAuth2GadgetBinding gadgetBinding = new OAuth2GadgetBinding(gadgetUri, gadgetServiceName, clientName, allowOverride);
                    ret.put(gadgetBinding.getGadgetUri() + ':' + gadgetBinding.getGadgetServiceName(), gadgetBinding);
                }
            }
        }
        catch (JSONException e) {
            if (LOG.isLoggable()) {
                LOG.log("OAuth2PersistenceException", e);
            }
            throw new OAuth2PersistenceException((Exception)((Object)e));
        }
        return ret;
    }

    private Map<String, OAuth2Provider> loadProviders() throws OAuth2PersistenceException {
        Map ret = Maps.newHashMap();
        try {
            JSONObject providers = this.configFile.getJSONObject(PROVIDERS);
            Iterator i = providers.keys();
            while (i.hasNext()) {
                String providerName = (String)i.next();
                JSONObject provider = providers.getJSONObject(providerName);
                JSONObject endpoints = provider.getJSONObject(ENDPOINTS);
                String clientAuthenticationType = provider.optString(CLIENT_AUTHENTICATION, NO_CLIENT_AUTHENTICATION);
                boolean authorizationHeader = provider.optBoolean(AUTHORIZATION_HEADER, false);
                boolean urlParameter = provider.optBoolean(URL_PARAMETER, false);
                String authorizationUrl = endpoints.optString(AUTHORIZATION_URL, null);
                if (this.authority != null && authorizationUrl != null) {
                    authorizationUrl = authorizationUrl.replace("%authority%", this.authority.getAuthority());
                    authorizationUrl = authorizationUrl.replace("%contextRoot%", this.contextRoot);
                    authorizationUrl = authorizationUrl.replace("%origin%", this.authority.getOrigin());
                    authorizationUrl = authorizationUrl.replace("%scheme%", this.authority.getScheme());
                }
                String tokenUrl = endpoints.optString(TOKEN_URL, null);
                if (this.authority != null && tokenUrl != null) {
                    tokenUrl = tokenUrl.replace("%authority%", this.authority.getAuthority());
                    tokenUrl = tokenUrl.replace("%contextRoot%", this.contextRoot);
                    tokenUrl = tokenUrl.replace("%origin%", this.authority.getOrigin());
                    tokenUrl = tokenUrl.replace("%scheme%", this.authority.getScheme());
                }
                OAuth2Provider oauth2Provider = new OAuth2Provider();
                oauth2Provider.setName(providerName);
                oauth2Provider.setAuthorizationUrl(authorizationUrl);
                oauth2Provider.setTokenUrl(tokenUrl);
                oauth2Provider.setClientAuthenticationType(clientAuthenticationType);
                oauth2Provider.setAuthorizationHeader(authorizationHeader);
                oauth2Provider.setUrlParameter(urlParameter);
                ret.put(oauth2Provider.getName(), oauth2Provider);
            }
        }
        catch (JSONException e) {
            if (LOG.isLoggable()) {
                LOG.log("OAuth2PersistenceException", e);
            }
            throw new OAuth2PersistenceException((Exception)((Object)e));
        }
        return ret;
    }

    @Override
    public Set<OAuth2Token> loadTokens() throws OAuth2PersistenceException {
        return Collections.emptySet();
    }

    public static boolean removeToken(Integer index) {
        return false;
    }

    @Override
    public boolean removeToken(String providerName, String gadgetUri, String user, String scope, OAuth2Token.Type type) {
        return false;
    }

    @Override
    public void updateToken(OAuth2Token token) {
    }

    private static String getJSONString(String location) throws IOException {
        return ResourceLoader.getContent((String)location);
    }
}

