/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.parse;

import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.shindig.common.xml.DomUtil;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public final class SocialDataTags {
    public static final String OSML_DATA_TAG = "osdata";
    public static final String OSML_TEMPLATE_TAG = "ostemplate";
    public static final BiMap<String, String> SCRIPT_TYPE_TO_OSML_TAG = ImmutableBiMap.of((Object)"text/os-data", (Object)"osdata", (Object)"text/os-template", (Object)"ostemplate");

    private SocialDataTags() {
    }

    public static List<Element> getTags(Document doc, String tagName) {
        NodeList list = doc.getElementsByTagName(tagName);
        ArrayList elements = Lists.newArrayListWithExpectedSize((int)list.getLength());
        for (int i = 0; i < list.getLength(); ++i) {
            elements.add((Element)list.item(i));
        }
        String scriptType = (String)SCRIPT_TYPE_TO_OSML_TAG.inverse().get((Object)tagName);
        if (scriptType != null) {
            List scripts = DomUtil.getElementsByTagNameCaseInsensitive((Document)doc, (Set)ImmutableSet.of((Object)"script"));
            for (Element script : scripts) {
                Attr typeAttr = (Attr)script.getAttributes().getNamedItem("type");
                if (typeAttr == null || !scriptType.equalsIgnoreCase(typeAttr.getValue())) continue;
                elements.add(script);
            }
        }
        return elements;
    }

    public static boolean isOpenSocialScript(Element script) {
        Attr typeAttr = (Attr)script.getAttributes().getNamedItem("type");
        return typeAttr != null && typeAttr.getValue() != null && SCRIPT_TYPE_TO_OSML_TAG.containsKey((Object)typeAttr.getValue());
    }
}

