/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.render;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.ELContext;
import javax.el.ELResolver;
import javax.el.PropertyNotFoundException;
import org.apache.commons.lang3.StringUtils;
import org.apache.shindig.common.JsonSerializer;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.common.uri.UriBuilder;
import org.apache.shindig.common.xml.DomUtil;
import org.apache.shindig.config.ContainerConfig;
import org.apache.shindig.expressions.Expressions;
import org.apache.shindig.gadgets.Gadget;
import org.apache.shindig.gadgets.GadgetContext;
import org.apache.shindig.gadgets.GadgetELResolver;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.MessageBundleFactory;
import org.apache.shindig.gadgets.RenderingContext;
import org.apache.shindig.gadgets.UnsupportedFeatureException;
import org.apache.shindig.gadgets.admin.GadgetAdminStore;
import org.apache.shindig.gadgets.config.ConfigProcessor;
import org.apache.shindig.gadgets.features.FeatureRegistry;
import org.apache.shindig.gadgets.features.FeatureRegistryProvider;
import org.apache.shindig.gadgets.js.JsException;
import org.apache.shindig.gadgets.js.JsRequest;
import org.apache.shindig.gadgets.js.JsRequestBuilder;
import org.apache.shindig.gadgets.js.JsResponse;
import org.apache.shindig.gadgets.js.JsServingPipeline;
import org.apache.shindig.gadgets.preload.PreloadException;
import org.apache.shindig.gadgets.preload.PreloadedData;
import org.apache.shindig.gadgets.rewrite.GadgetRewriter;
import org.apache.shindig.gadgets.rewrite.MutableContent;
import org.apache.shindig.gadgets.rewrite.RewritingException;
import org.apache.shindig.gadgets.spec.Feature;
import org.apache.shindig.gadgets.spec.MessageBundle;
import org.apache.shindig.gadgets.spec.UserPref;
import org.apache.shindig.gadgets.spec.View;
import org.apache.shindig.gadgets.templates.MessageELResolver;
import org.apache.shindig.gadgets.uri.JsUriManager;
import org.apache.shindig.gadgets.uri.UriCommon;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class RenderingGadgetRewriter
implements GadgetRewriter {
    private static final String classname = RenderingGadgetRewriter.class.getName();
    private static final Logger LOG = Logger.getLogger(classname, "org.apache.shindig.common.logging.i18n.resource");
    protected static final String DEFAULT_CSS = "body,td,div,span,p{font-family:arial,sans-serif;}a {color:#0000cc;}a:visited {color:#551a8b;}a:active {color:#ff0000;}body{margin: 0px;padding: 0px;background-color:white;}";
    protected static final String SCROLLING_CSS = "html,body{height:100%;width:100%;overflow:auto;}";
    static final String IS_GADGET_BEACON = "window['__isgadget']=true;";
    static final String INSERT_BASE_ELEMENT_KEY = "gadgets.insertBaseElement";
    static final String REWRITE_DOCTYPE_QNAME = "gadgets.doctype_qname";
    static final String REWRITE_DOCTYPE_PUBID = "gadgets.doctype_pubid";
    static final String REWRITE_DOCTYPE_SYSID = "gadgets.doctype_sysid";
    static final String FEATURES_KEY = "gadgets.features";
    protected final MessageBundleFactory messageBundleFactory;
    protected final ContainerConfig containerConfig;
    protected final FeatureRegistryProvider featureRegistryProvider;
    protected final JsServingPipeline jsServingPipeline;
    protected final JsUriManager jsUriManager;
    protected final ConfigProcessor configProcessor;
    protected final GadgetAdminStore gadgetAdminStore;
    protected Set<String> defaultExternLibs = ImmutableSet.of();
    protected Boolean externalizeFeatures = false;
    private String defaultDoctypeQName = "html";
    private String defaultDoctypePubId = null;
    private String defaultDoctypeSysId = null;
    private final Expressions expressions;
    private ELContext elContext;

    @Inject
    public RenderingGadgetRewriter(MessageBundleFactory messageBundleFactory, Expressions expressions, ContainerConfig containerConfig, FeatureRegistryProvider featureRegistryProvider, JsServingPipeline jsServingPipeline, JsUriManager jsUriManager, ConfigProcessor configProcessor, GadgetAdminStore gadgetAdminStore) {
        this.messageBundleFactory = messageBundleFactory;
        this.expressions = expressions;
        this.containerConfig = containerConfig;
        this.featureRegistryProvider = featureRegistryProvider;
        this.jsServingPipeline = jsServingPipeline;
        this.jsUriManager = jsUriManager;
        this.configProcessor = configProcessor;
        this.gadgetAdminStore = gadgetAdminStore;
    }

    public void setDefaultDoctypeQName(String qname) {
        this.defaultDoctypeQName = qname;
    }

    public void setDefaultDoctypePubId(String pubid) {
        this.defaultDoctypePubId = pubid;
    }

    public void setDefaultDoctypeSysId(String sysid) {
        this.defaultDoctypeSysId = sysid;
    }

    @Inject
    public void setDefaultForcedLibs(@Named(value="shindig.gadget-rewrite.default-forced-libs") String forcedLibs) {
        if (StringUtils.isNotBlank((CharSequence)forcedLibs)) {
            this.defaultExternLibs = ImmutableSortedSet.copyOf((Iterable)Splitter.on((char)':').split((CharSequence)forcedLibs));
        }
    }

    @Inject(optional=true)
    public void setExternalizeFeatureLibs(@Named(value="shindig.gadget-rewrite.externalize-feature-libs") Boolean externalizeFeatures) {
        this.externalizeFeatures = externalizeFeatures;
    }

    public void processChildNodes(Node source) {
        NodeList nodes = source.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            this.processNode(nodes.item(i));
        }
    }

    private void processNode(Node source) {
        switch (source.getNodeType()) {
            case 3: {
                try {
                    source.setTextContent(String.valueOf(this.expressions.parse(source.getTextContent(), String.class).getValue(this.elContext)));
                }
                catch (PropertyNotFoundException pe) {
                    if (!LOG.isLoggable(Level.INFO)) break;
                    LOG.log(Level.INFO, pe.getMessage(), pe);
                }
                break;
            }
            case 1: {
                this.processChildNodes(source);
                break;
            }
            case 9: {
                this.processChildNodes(source);
            }
        }
    }

    @Override
    public void rewrite(Gadget gadget, MutableContent mutableContent) throws RewritingException {
        if (gadget.sanitizeOutput()) {
            return;
        }
        try {
            Locale locale;
            Element html;
            GadgetContext context = gadget.getContext();
            MessageBundle bundle = this.messageBundleFactory.getBundle(gadget.getSpec(), context.getLocale(), context.getIgnoreCache(), context.getContainer(), context.getView());
            MessageELResolver messageELResolver = new MessageELResolver(this.expressions, bundle);
            this.elContext = this.expressions.newELContext(new ELResolver[]{messageELResolver, new GadgetELResolver(gadget.getContext())});
            this.elContext.putContext(GadgetContext.class, (Object)this.elContext);
            Document document = mutableContent.getDocument();
            this.processChildNodes(document);
            Element head = (Element)DomUtil.getFirstNamedChildNode((Node)document.getDocumentElement(), (String)"head");
            Node firstHeadChild = head.getFirstChild();
            Element injectedStyle = document.createElement("style");
            injectedStyle.setAttribute("type", "text/css");
            head.insertBefore(injectedStyle, firstHeadChild);
            this.injectDefaultScrolling(injectedStyle);
            if (document.getDoctype() == null) {
                injectedStyle.appendChild(injectedStyle.getOwnerDocument().createTextNode(DEFAULT_CSS));
            }
            if (gadget.getSpecificationVersion().isEqualOrGreaterThan("2.0.0") && !gadget.useQuirksMode()) {
                String container = gadget.getContext().getContainer();
                String doctype_qname = this.defaultDoctypeQName;
                String doctype_sysid = this.defaultDoctypeSysId;
                String doctype_pubid = this.defaultDoctypePubId;
                String value = this.containerConfig.getString(container, REWRITE_DOCTYPE_QNAME);
                if (value != null) {
                    doctype_qname = value;
                }
                if ((value = this.containerConfig.getString(container, REWRITE_DOCTYPE_SYSID)) != null) {
                    doctype_sysid = value;
                }
                if ((value = this.containerConfig.getString(container, REWRITE_DOCTYPE_PUBID)) != null) {
                    doctype_pubid = value;
                }
                if (doctype_qname != null) {
                    DocumentType docTypeNode = document.getImplementation().createDocumentType(doctype_qname, doctype_pubid, doctype_sysid);
                    if (document.getDoctype() != null) {
                        document.removeChild(document.getDoctype());
                    }
                    document.insertBefore(docTypeNode, document.getFirstChild());
                }
            }
            if ((html = (Element)document.getElementsByTagName("html").item(0)) != null && (locale = gadget.getContext().getLocale()) != null) {
                String locStr = locale.toString();
                String locValue = locStr.replace("_", "-");
                html.setAttribute("lang", locValue);
                html.setAttribute("xml:lang", locValue);
            }
            this.injectBaseTag(gadget, head);
            this.injectGadgetBeacon(gadget, head, firstHeadChild);
            this.injectFeatureLibraries(gadget, head, firstHeadChild);
            Element mainScriptTag = document.createElement("script");
            this.injectMessageBundles(bundle, mainScriptTag);
            this.injectDefaultPrefs(gadget, mainScriptTag);
            this.injectPreloads(gadget, mainScriptTag);
            head.insertBefore(mainScriptTag, firstHeadChild);
            Element body = (Element)DomUtil.getFirstNamedChildNode((Node)document.getDocumentElement(), (String)"body");
            body.setAttribute("dir", bundle.getLanguageDirection());
            if (!gadget.requiresCaja()) {
                this.injectOnLoadHandlers(body);
            }
            mutableContent.documentChanged();
        }
        catch (GadgetException e) {
            throw new RewritingException(e.getLocalizedMessage(), e, e.getHttpStatusCode());
        }
    }

    protected void injectDefaultScrolling(Element injectedStyle) {
        injectedStyle.appendChild(injectedStyle.getOwnerDocument().createTextNode(SCROLLING_CSS));
    }

    protected void injectBaseTag(Gadget gadget, Node headTag) {
        GadgetContext context = gadget.getContext();
        if (this.containerConfig.getBool(context.getContainer(), INSERT_BASE_ELEMENT_KEY)) {
            Uri base = gadget.getSpec().getUrl();
            View view = gadget.getCurrentView();
            if (view != null && view.getHref() != null) {
                base = view.getHref();
            }
            Element baseTag = headTag.getOwnerDocument().createElement("base");
            baseTag.setAttribute("href", base.toString());
            headTag.insertBefore(baseTag, headTag.getFirstChild());
        }
    }

    protected void injectOnLoadHandlers(Node bodyTag) {
        Element onloadScript = bodyTag.getOwnerDocument().createElement("script");
        bodyTag.appendChild(onloadScript);
        onloadScript.appendChild(bodyTag.getOwnerDocument().createTextNode("gadgets.util.runOnLoadHandlers();"));
    }

    protected void injectGadgetBeacon(Gadget gadget, Node headTag, Node firstHeadChild) throws GadgetException {
        Element beaconNode = headTag.getOwnerDocument().createElement("script");
        beaconNode.setTextContent(IS_GADGET_BEACON);
        headTag.insertBefore(beaconNode, firstHeadChild);
    }

    protected String getFeatureRepositoryId(Gadget gadget) {
        GadgetContext context = gadget.getContext();
        return context.getRepository();
    }

    protected void injectFeatureLibraries(Gadget gadget, Node headTag, Node firstHeadChild) throws GadgetException {
        GadgetContext context = gadget.getContext();
        String repository = this.getFeatureRepositoryId(gadget);
        FeatureRegistry featureRegistry = this.featureRegistryProvider.get(repository);
        this.checkRequiredFeatures(gadget, featureRegistry);
        if (!this.gadgetAdminStore.checkFeatureAdminInfo(gadget)) {
            throw new GadgetException(GadgetException.Code.GADGET_ADMIN_FEATURE_NOT_ALLOWED);
        }
        TreeSet externForcedLibs = this.defaultExternLibs;
        String externParam = context.getParameter("libs");
        if (StringUtils.isNotBlank((CharSequence)externParam)) {
            externForcedLibs = Sets.newTreeSet((Iterable)Splitter.on((char)':').split((CharSequence)externParam));
        }
        if (!externForcedLibs.isEmpty()) {
            this.injectScript(externForcedLibs, null, false, gadget, headTag, firstHeadChild, "");
        }
        ArrayList gadgetLibs = Lists.newArrayList(gadget.getDirectFeatureDeps());
        List<Feature> gadgetFeatures = gadget.getSpec().getModulePrefs().getAllFeatures();
        for (Feature feature : gadgetFeatures) {
            if (feature.getRequired() || this.gadgetAdminStore.isAllowedFeature(feature, gadget)) continue;
            gadgetLibs.remove(feature.getName());
        }
        ImmutableSet allLibs = ImmutableSet.builder().addAll((Iterable)externForcedLibs).addAll((Iterable)gadgetLibs).build();
        String libraryConfig = this.getLibraryConfig(gadget, featureRegistry.getFeatures((Collection<String>)allLibs));
        this.injectScript(gadgetLibs, externForcedLibs, this.externalizeFeatures == false, gadget, headTag, firstHeadChild, libraryConfig);
    }

    protected void checkRequiredFeatures(Gadget gadget, FeatureRegistry featureRegistry) throws GadgetException {
        LinkedList unsupported = Lists.newLinkedList();
        Map<String, Feature> featureMap = gadget.getViewFeatures();
        LinkedList gadgetFeatureKeys = Lists.newLinkedList(gadget.getDirectFeatureDeps());
        featureRegistry.getFeatureResources(gadget.getContext(), gadgetFeatureKeys, unsupported).getResources();
        if (!unsupported.isEmpty()) {
            LinkedList requiredUnsupported = Lists.newLinkedList();
            for (String notThere : unsupported) {
                if (featureMap.containsKey(notThere) && !featureMap.get(notThere).getRequired()) continue;
                requiredUnsupported.add(notThere);
            }
            if (!requiredUnsupported.isEmpty()) {
                throw new UnsupportedFeatureException(((Object)requiredUnsupported).toString());
            }
        }
    }

    protected String getFeaturesContent(JsUriManager.JsUri jsUri) throws GadgetException {
        JsResponse jsResponse;
        JsRequest jsRequest = new JsRequestBuilder(this.jsUriManager, this.featureRegistryProvider.get(jsUri.getRepository())).build(jsUri, null);
        try {
            jsResponse = this.jsServingPipeline.execute(jsRequest);
        }
        catch (JsException e) {
            throw new GadgetException(GadgetException.Code.JS_PROCESSING_ERROR, e, e.getStatusCode());
        }
        return jsResponse.toJsString();
    }

    protected void injectScript(Collection<String> libs, Collection<String> loaded, boolean inline, Gadget gadget, Node headTag, Node firstHeadChild, String extraContent) throws GadgetException {
        GadgetContext context = gadget.getContext();
        JsUriManager.JsUri jsUri = new JsUriManager.JsUri(null, context.getDebug(), false, context.getContainer(), null, libs, loaded, null, false, false, RenderingContext.getDefault(), null, this.getFeatureRepositoryId(gadget));
        jsUri.setCajoleContent(gadget.requiresCaja());
        String content = "";
        if (!inline) {
            String jsUrl = new UriBuilder(this.jsUriManager.makeExternJsUri(jsUri)).addQueryParameter(UriCommon.Param.JSLOAD.getKey(), "0").toString();
            Element libsTag = headTag.getOwnerDocument().createElement("script");
            libsTag.setAttribute("src", jsUrl);
            headTag.insertBefore(libsTag, firstHeadChild);
        } else {
            content = this.getFeaturesContent(jsUri);
        }
        content = content + extraContent;
        if (content.length() > 0) {
            Element inlineTag = headTag.getOwnerDocument().createElement("script");
            headTag.insertBefore(inlineTag, firstHeadChild);
            inlineTag.appendChild(headTag.getOwnerDocument().createTextNode(content));
        }
    }

    protected String getLibraryConfig(Gadget gadget, List<String> reqs) throws GadgetException {
        Map<String, Object> config = this.configProcessor.getConfig(gadget.getContext().getContainer(), reqs, null, gadget);
        if (!config.isEmpty()) {
            return "gadgets.config.init(" + JsonSerializer.serialize(config) + ");\n";
        }
        return "";
    }

    protected void injectMessageBundles(MessageBundle bundle, Node scriptTag) throws GadgetException {
        String msgs = bundle.toJSONString();
        Text text = scriptTag.getOwnerDocument().createTextNode("gadgets.Prefs.setMessages_(");
        text.appendData(msgs);
        text.appendData(");");
        scriptTag.appendChild(text);
    }

    protected void injectDefaultPrefs(Gadget gadget, Node scriptTag) {
        Collection<UserPref> prefs = gadget.getSpec().getUserPrefs().values();
        HashMap defaultPrefs = Maps.newHashMapWithExpectedSize((int)prefs.size());
        for (UserPref up : prefs) {
            defaultPrefs.put(up.getName(), up.getDefaultValue());
        }
        Text text = scriptTag.getOwnerDocument().createTextNode("gadgets.Prefs.setDefaultPrefs_(");
        text.appendData(JsonSerializer.serialize((Map)defaultPrefs));
        text.appendData(");");
        scriptTag.appendChild(text);
    }

    protected void injectPreloads(Gadget gadget, Node scriptTag) {
        ArrayList preload = Lists.newArrayList();
        for (PreloadedData preloaded : gadget.getPreloads()) {
            try {
                preload.addAll(preloaded.toJson());
            }
            catch (PreloadException pe) {
                if (!LOG.isLoggable(Level.WARNING)) continue;
                LOG.logp(Level.WARNING, classname, "injectPreloads", "unexpectedErrorPreloading");
                LOG.log(Level.WARNING, pe.getMessage(), pe);
            }
        }
        Text text = scriptTag.getOwnerDocument().createTextNode("gadgets.io.preloaded_=");
        text.appendData(JsonSerializer.serialize((Collection)preload));
        text.appendData(";");
        scriptTag.appendChild(text);
    }
}

