/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.rewrite;

import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import java.util.List;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.gadgets.Gadget;
import org.apache.shindig.gadgets.rewrite.ConcatVisitor;
import org.apache.shindig.gadgets.rewrite.ContentRewriterFeature;
import org.apache.shindig.gadgets.rewrite.DomWalker;
import org.apache.shindig.gadgets.rewrite.ProxyingVisitor;
import org.apache.shindig.gadgets.rewrite.ResourceMutateVisitor;
import org.apache.shindig.gadgets.uri.ConcatUriManager;
import org.apache.shindig.gadgets.uri.ProxyUriManager;

public class ProxyingContentRewriter
extends DomWalker.Rewriter {
    private final ContentRewriterFeature.Factory featureConfigFactory;
    private final ProxyUriManager proxyUriManager;
    private final ConcatUriManager concatUriManager;

    @Inject
    public ProxyingContentRewriter(ContentRewriterFeature.Factory featureConfigFactory, ProxyUriManager proxyUriManager, ConcatUriManager concatUriManager) {
        this.featureConfigFactory = featureConfigFactory;
        this.proxyUriManager = proxyUriManager;
        this.concatUriManager = concatUriManager;
    }

    @Override
    protected List<DomWalker.Visitor> makeVisitors(Gadget context, Uri gadgetUri) {
        ContentRewriterFeature.Config config = this.featureConfigFactory.get(context.getSpec());
        return ImmutableList.of((Object)new ConcatVisitor.Js(config, this.concatUriManager), (Object)new ConcatVisitor.Css(config, this.concatUriManager), (Object)new ProxyingVisitor(config, this.proxyUriManager, ResourceMutateVisitor.Tags.SCRIPT, ResourceMutateVisitor.Tags.STYLESHEET, ResourceMutateVisitor.Tags.EMBEDDED_IMAGES));
    }
}

