/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.servlet;

import com.google.caja.lexer.TokenConsumer;
import com.google.caja.parser.html.Nodes;
import com.google.caja.render.Concatenator;
import com.google.caja.render.JsMinimalPrinter;
import com.google.caja.render.JsPrettyPrinter;
import com.google.caja.reporting.Message;
import com.google.caja.reporting.MessageContext;
import com.google.caja.reporting.RenderContext;
import com.google.caja.util.Sets;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.codec.binary.Base64InputStream;
import org.apache.commons.io.IOUtils;
import org.apache.shindig.auth.SecurityToken;
import org.apache.shindig.auth.SecurityTokenCodec;
import org.apache.shindig.auth.SecurityTokenException;
import org.apache.shindig.common.Nullable;
import org.apache.shindig.common.servlet.HttpUtil;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.common.util.TimeSource;
import org.apache.shindig.config.ContainerConfig;
import org.apache.shindig.gadgets.Gadget;
import org.apache.shindig.gadgets.GadgetContext;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.RenderingContext;
import org.apache.shindig.gadgets.admin.GadgetAdminStore;
import org.apache.shindig.gadgets.features.ApiDirective;
import org.apache.shindig.gadgets.features.FeatureRegistry;
import org.apache.shindig.gadgets.features.FeatureRegistryProvider;
import org.apache.shindig.gadgets.http.HttpResponse;
import org.apache.shindig.gadgets.js.JsException;
import org.apache.shindig.gadgets.js.JsRequestBuilder;
import org.apache.shindig.gadgets.js.JsResponse;
import org.apache.shindig.gadgets.js.JsServingPipeline;
import org.apache.shindig.gadgets.process.ProcessingException;
import org.apache.shindig.gadgets.process.Processor;
import org.apache.shindig.gadgets.servlet.CajaContentRewriter;
import org.apache.shindig.gadgets.servlet.GadgetsHandler;
import org.apache.shindig.gadgets.servlet.GadgetsHandlerApi;
import org.apache.shindig.gadgets.servlet.ModuleIdManager;
import org.apache.shindig.gadgets.servlet.ProxyHandler;
import org.apache.shindig.gadgets.spec.BaseOAuthService;
import org.apache.shindig.gadgets.spec.Feature;
import org.apache.shindig.gadgets.spec.GadgetSpec;
import org.apache.shindig.gadgets.spec.LinkSpec;
import org.apache.shindig.gadgets.spec.ModulePrefs;
import org.apache.shindig.gadgets.spec.OAuth2Service;
import org.apache.shindig.gadgets.spec.OAuth2Spec;
import org.apache.shindig.gadgets.spec.OAuthService;
import org.apache.shindig.gadgets.spec.OAuthSpec;
import org.apache.shindig.gadgets.spec.UserPref;
import org.apache.shindig.gadgets.spec.View;
import org.apache.shindig.gadgets.uri.IframeUriManager;
import org.apache.shindig.gadgets.uri.JsUriManager;
import org.apache.shindig.gadgets.uri.ProxyUriManager;
import org.apache.shindig.protocol.conversion.BeanDelegator;
import org.apache.shindig.protocol.conversion.BeanFilter;
import org.w3c.dom.Node;

public class GadgetsHandlerService {
    private static final Locale DEFAULT_LOCALE = new Locale("all", "all");
    private static final Logger LOG = Logger.getLogger(GadgetsHandler.class.getName());
    @VisibleForTesting
    static final Map<Class<?>, Class<?>> API_CLASSES = new ImmutableMap.Builder().put(View.class, GadgetsHandlerApi.View.class).put(UserPref.class, GadgetsHandlerApi.UserPref.class).put(UserPref.EnumValuePair.class, GadgetsHandlerApi.EnumValuePair.class).put(ModulePrefs.class, GadgetsHandlerApi.ModulePrefs.class).put(Feature.class, GadgetsHandlerApi.Feature.class).put(LinkSpec.class, GadgetsHandlerApi.LinkSpec.class).put(OAuthSpec.class, GadgetsHandlerApi.OAuthSpec.class).put(OAuthService.class, GadgetsHandlerApi.OAuthService.class).put(BaseOAuthService.EndPoint.class, GadgetsHandlerApi.EndPoint.class).put(OAuth2Spec.class, GadgetsHandlerApi.OAuth2Spec.class).put(OAuth2Service.class, GadgetsHandlerApi.OAuth2Service.class).put(View.ContentType.class, GadgetsHandlerApi.ViewContentType.class).put(UserPref.DataType.class, GadgetsHandlerApi.UserPrefDataType.class).put(GadgetsHandlerApi.RenderingContext.class, RenderingContext.class).put(BaseOAuthService.Method.class, GadgetsHandlerApi.Method.class).put(BaseOAuthService.Location.class, GadgetsHandlerApi.Location.class).build();
    @VisibleForTesting
    static final Map<Enum<?>, Enum<?>> ENUM_CONVERSION_MAP = new ImmutableMap.Builder().putAll(BeanDelegator.createDefaultEnumMap(View.ContentType.class, GadgetsHandlerApi.ViewContentType.class)).putAll(BeanDelegator.createDefaultEnumMap(UserPref.DataType.class, GadgetsHandlerApi.UserPrefDataType.class)).putAll(BeanDelegator.createDefaultEnumMap(BaseOAuthService.Method.class, GadgetsHandlerApi.Method.class)).putAll(BeanDelegator.createDefaultEnumMap(BaseOAuthService.Location.class, GadgetsHandlerApi.Location.class)).putAll(BeanDelegator.createDefaultEnumMap(GadgetsHandlerApi.RenderingContext.class, RenderingContext.class)).build();
    protected final TimeSource timeSource;
    protected final Processor processor;
    protected final IframeUriManager iframeUriManager;
    protected final SecurityTokenCodec securityTokenCodec;
    protected final ProxyUriManager proxyUriManager;
    protected final JsUriManager jsUriManager;
    protected final JsServingPipeline jsPipeline;
    protected final JsRequestBuilder jsRequestBuilder;
    protected final ProxyHandler proxyHandler;
    protected final BeanDelegator beanDelegator;
    protected final long specRefreshInterval;
    protected final BeanFilter beanFilter;
    protected final CajaContentRewriter cajaContentRewriter;
    protected final GadgetAdminStore gadgetAdminStore;
    protected final FeatureRegistryProvider featureRegistryProvider;
    protected final ModuleIdManager moduleIdManager;
    private ContainerConfig config;

    @Inject
    public GadgetsHandlerService(TimeSource timeSource, Processor processor, IframeUriManager iframeUriManager, SecurityTokenCodec securityTokenCodec, ProxyUriManager proxyUriManager, JsUriManager jsUriManager, ProxyHandler proxyHandler, JsServingPipeline jsPipeline, JsRequestBuilder jsRequestBuilder, @Named(value="shindig.cache.xml.refreshInterval") long specRefreshInterval, BeanFilter beanFilter, CajaContentRewriter cajaContentRewriter, GadgetAdminStore gadgetAdminStore, FeatureRegistryProvider featureRegistryProvider, ModuleIdManager moduleIdManager, ContainerConfig config) {
        this.timeSource = timeSource;
        this.processor = processor;
        this.iframeUriManager = iframeUriManager;
        this.securityTokenCodec = securityTokenCodec;
        this.proxyUriManager = proxyUriManager;
        this.jsUriManager = jsUriManager;
        this.proxyHandler = proxyHandler;
        this.jsPipeline = jsPipeline;
        this.jsRequestBuilder = jsRequestBuilder;
        this.specRefreshInterval = specRefreshInterval;
        this.beanFilter = beanFilter;
        this.cajaContentRewriter = cajaContentRewriter;
        this.gadgetAdminStore = gadgetAdminStore;
        this.featureRegistryProvider = featureRegistryProvider;
        this.moduleIdManager = moduleIdManager;
        this.beanDelegator = new BeanDelegator(API_CLASSES, ENUM_CONVERSION_MAP);
        this.config = config;
    }

    public GadgetsHandlerApi.MetadataResponse getMetadata(GadgetsHandlerApi.MetadataRequest request) throws ProcessingException {
        this.verifyBaseParams(request, true);
        Set fields = this.beanFilter.processBeanFields(request.getFields());
        MetadataGadgetContext context = new MetadataGadgetContext(request);
        Gadget gadget = this.processor.process(context);
        boolean needIfrUrls = this.isFieldIncluded(fields, "iframeurls");
        if (needIfrUrls && !this.gadgetAdminStore.checkFeatureAdminInfo(gadget)) {
            throw new ProcessingException("Gadget is not trusted to render in this container.", 400);
        }
        Map<String, Uri> uris = needIfrUrls ? this.iframeUriManager.makeAllRenderingUris(gadget) : null;
        Boolean needsTokenRefresh = this.isFieldIncluded(fields, "needstokenrefresh") ? Boolean.valueOf(gadget.getAllFeatures().contains("auth-refresh")) : null;
        boolean alwaysAppendSecurityToken = this.config.getBool(gadget.getContext().getContainer(), "gadgets.uri.iframe.alwaysAppendSecurityToken");
        if (alwaysAppendSecurityToken) {
            needsTokenRefresh = Boolean.TRUE;
        }
        Set<String> rpcServiceIds = this.getRpcServiceIds(gadget);
        Integer tokenTTL = this.isFieldIncluded(fields, "tokenTTL") ? Integer.valueOf(this.securityTokenCodec.getTokenTimeToLive(((GadgetContext)context).getContainer())) : null;
        return this.createMetadataResponse(((GadgetContext)context).getUrl(), gadget.getSpec(), uris, needsTokenRefresh, fields, this.timeSource.currentTimeMillis() + this.specRefreshInterval, tokenTTL, rpcServiceIds);
    }

    private Set<String> getRpcServiceIds(Gadget gadget) {
        GadgetContext context = gadget.getContext();
        Set rpcEndpoints = Sets.newHashSet(this.gadgetAdminStore.getAdditionalRpcServiceIds(gadget));
        List<Feature> modulePrefFeatures = gadget.getSpec().getModulePrefs().getAllFeatures();
        ArrayList featureNames = Lists.newArrayList();
        for (Feature feature : modulePrefFeatures) {
            if (!this.gadgetAdminStore.isAllowedFeature(feature, gadget)) continue;
            featureNames.add(feature.getName());
        }
        try {
            FeatureRegistry featureRegistry = this.featureRegistryProvider.get(context.getRepository());
            FeatureRegistry.LookupResult result = featureRegistry.getFeatureResources(context, featureRegistry.getFeatures(featureNames), null);
            List<FeatureRegistry.FeatureBundle> bundles = result.getBundles();
            for (FeatureRegistry.FeatureBundle bundle : bundles) {
                rpcEndpoints.addAll(bundle.getApis(ApiDirective.Type.RPC, false));
            }
        }
        catch (GadgetException e) {
            LOG.log(Level.WARNING, "Error getting features from feature registry", e);
        }
        return rpcEndpoints;
    }

    private boolean isFieldIncluded(Set<String> fields, String name) {
        return fields.contains("*") || fields.contains(name.toLowerCase());
    }

    public GadgetsHandlerApi.TokenResponse getToken(GadgetsHandlerApi.TokenRequest request) throws SecurityTokenException, ProcessingException {
        this.verifyBaseParams(request, true);
        Set fields = this.beanFilter.processBeanFields(request.getFields());
        GadgetsHandlerApi.AuthContext authContext = request.getAuthContext();
        SecurityToken tokenData = null;
        String token = null;
        Long moduleId = request.getModuleId();
        if (moduleId == null) {
            moduleId = 0L;
        } else if (moduleId < 0L) {
            moduleId = this.moduleIdManager.generate(request.getUrl(), authContext);
        }
        if (moduleId > 0L) {
            moduleId = this.moduleIdManager.validate(request.getUrl(), authContext, moduleId);
        }
        if (moduleId != null) {
            tokenData = this.convertAuthContext(authContext, request.getContainer(), request.getUrl().toString(), moduleId, request.getUrl().toString());
            token = this.securityTokenCodec.encodeToken(tokenData);
        }
        Long expiryTimeMs = null;
        Integer tokenTTL = null;
        if (tokenData != null) {
            expiryTimeMs = tokenData.getExpiresAt();
            tokenTTL = this.isFieldIncluded(fields, "tokenTTL") ? Integer.valueOf(this.securityTokenCodec.getTokenTimeToLive(tokenData.getContainer())) : null;
        }
        moduleId = this.isFieldIncluded(fields, "moduleId") ? moduleId : null;
        return this.createTokenResponse(request.getUrl(), token, fields, expiryTimeMs, tokenTTL, moduleId);
    }

    public GadgetsHandlerApi.JsResponse getJs(GadgetsHandlerApi.JsRequest request) throws ProcessingException {
        this.verifyBaseParams(request, false);
        Set fields = this.beanFilter.processBeanFields(request.getFields());
        JsUriManager.JsUri jsUri = this.createJsUri(request);
        Uri servedUri = this.jsUriManager.makeExternJsUri(jsUri);
        String content = null;
        Long expireMs = null;
        if (this.isFieldIncluded(fields, "jsContent")) {
            JsResponse response;
            try {
                response = this.jsPipeline.execute(this.jsRequestBuilder.build(jsUri, servedUri.getAuthority()));
            }
            catch (JsException e) {
                throw new ProcessingException(e.getMessage(), e.getStatusCode());
            }
            content = response.toJsString();
            if (response.isProxyCacheable()) {
                expireMs = this.getDefaultExpiration();
            }
        } else {
            expireMs = this.getDefaultExpiration();
        }
        return this.createJsResponse(request.getUrl(), servedUri, content, fields, expireMs);
    }

    public GadgetsHandlerApi.ProxyResponse getProxy(GadgetsHandlerApi.ProxyRequest request) throws ProcessingException {
        this.verifyBaseParams(request, true);
        Set fields = this.beanFilter.processBeanFields(request.getFields());
        ProxyUriManager.ProxyUri proxyUri = this.createProxyUri(request);
        List<Uri> uris = this.proxyUriManager.make((List<ProxyUriManager.ProxyUri>)ImmutableList.of((Object)proxyUri), null);
        HttpResponse httpResponse = null;
        try {
            if (this.isFieldIncluded(fields, "proxyContent")) {
                httpResponse = this.proxyHandler.fetch(proxyUri);
            }
        }
        catch (IOException e) {
            LOG.log(Level.INFO, "Failed to fetch resource " + proxyUri.getResource().toString(), e);
            throw new ProcessingException("Error getting response content", 502);
        }
        catch (GadgetException e) {
            LOG.log(Level.INFO, "Failed to fetch resource " + proxyUri.getResource().toString(), e);
            throw new ProcessingException("Error getting response content", 502);
        }
        try {
            return this.createProxyResponse(uris.get(0), httpResponse, fields, this.getProxyExpireMs(proxyUri, httpResponse));
        }
        catch (IOException e) {
            LOG.log(Level.WARNING, "Error creating proxy response", e);
            throw new ProcessingException("Error getting response content", 500);
        }
    }

    public static GadgetsHandlerApi.MessageLevel convertMessageLevel(String name) {
        try {
            return GadgetsHandlerApi.MessageLevel.valueOf(name);
        }
        catch (Exception ex) {
            return GadgetsHandlerApi.MessageLevel.UNKNOWN;
        }
    }

    private List<GadgetsHandlerApi.Message> convertMessages(List<Message> msgs, MessageContext mc) {
        ArrayList result = Lists.newArrayListWithExpectedSize((int)msgs.size());
        for (Message m : msgs) {
            MessageImpl msg = new MessageImpl(m.getMessageType().name(), m.format(mc), GadgetsHandlerService.convertMessageLevel(m.getMessageLevel().name()));
            result.add(msg);
        }
        return result;
    }

    public GadgetsHandlerApi.CajaResponse getCaja(GadgetsHandlerApi.CajaRequest request) throws ProcessingException {
        this.verifyBaseParams(request, true);
        Set fields = this.beanFilter.processBeanFields(request.getFields());
        MessageContext mc = new MessageContext();
        CajaContentRewriter.CajoledResult result = this.cajaContentRewriter.rewrite(request.getUrl(), request.getContainer(), request.getMimeType(), true, request.getDebug());
        String html = null;
        String js = null;
        if (!result.hasErrors && null != result.html) {
            html = Nodes.render((Node)result.html);
        }
        if (!result.hasErrors && null != result.js) {
            StringBuilder builder = new StringBuilder();
            JsPrettyPrinter tc = request.getDebug() ? new JsPrettyPrinter(new Concatenator(builder)) : new JsMinimalPrinter(new Concatenator(builder));
            RenderContext rc = new RenderContext((TokenConsumer)tc).withAsciiOnly(true).withEmbeddable(true);
            result.js.render(rc);
            rc.getOut().noMoreTokens();
            js = builder.toString();
        }
        return this.createCajaResponse(request.getUrl(), html, js, this.convertMessages(result.messages, mc), fields, this.timeSource.currentTimeMillis() + this.specRefreshInterval);
    }

    protected void verifyBaseParams(GadgetsHandlerApi.BaseRequest request, boolean checkUrl) throws ProcessingException {
        if (checkUrl && request.getUrl() == null) {
            throw new ProcessingException("Missing url parameter", 400);
        }
        if (request.getContainer() == null) {
            throw new ProcessingException("Missing container parameter", 400);
        }
        if (request.getFields() == null) {
            throw new ProcessingException("Missing fields parameter", 400);
        }
    }

    protected Long getProxyExpireMs(ProxyUriManager.ProxyUri proxyUri, @Nullable HttpResponse httpResponse) {
        if (httpResponse != null) {
            return httpResponse.getCacheExpiration();
        }
        if (proxyUri.getRefresh() != null) {
            return this.timeSource.currentTimeMillis() + (long)(proxyUri.getRefresh() * 1000);
        }
        return this.getDefaultExpiration();
    }

    protected long getDefaultExpiration() {
        return this.timeSource.currentTimeMillis() + (long)(HttpUtil.getDefaultTtl() * 1000);
    }

    private SecurityToken convertAuthContext(GadgetsHandlerApi.AuthContext authContext, String container, String url) {
        return this.convertAuthContext(authContext, container, url, 0L, url);
    }

    private SecurityToken convertAuthContext(GadgetsHandlerApi.AuthContext authContext, String container, String url, long moduleId, String activeUrl) {
        if (authContext == null) {
            return null;
        }
        return (SecurityToken)this.beanDelegator.createDelegator((Object)authContext, SecurityToken.class, (Map)ImmutableMap.of((Object)"container", (Object)container, (Object)"appid", (Object)url, (Object)"appurl", (Object)url, (Object)"moduleId", (Object)moduleId, (Object)"activeurl", (Object)activeUrl));
    }

    public GadgetsHandlerApi.BaseResponse createErrorResponse(Uri uri, Exception e, String defaultMsg) {
        if (e instanceof ProcessingException) {
            ProcessingException processingExc = (ProcessingException)e;
            return this.createErrorResponse(uri, processingExc.getHttpStatusCode(), processingExc.getMessage());
        }
        LOG.log(Level.WARNING, "Error handling request: " + (uri != null ? uri.toString() : ""), e);
        return this.createErrorResponse(uri, 500, defaultMsg);
    }

    public GadgetsHandlerApi.BaseResponse createErrorResponse(Uri url, int code, String error) {
        GadgetsHandlerApi.Error errorBean = (GadgetsHandlerApi.Error)this.beanDelegator.createDelegator(null, GadgetsHandlerApi.Error.class, (Map)ImmutableMap.of((Object)"message", (Object)BeanDelegator.nullable((Object)error), (Object)"code", (Object)code));
        return (GadgetsHandlerApi.BaseResponse)this.beanDelegator.createDelegator((Object)error, GadgetsHandlerApi.BaseResponse.class, (Map)ImmutableMap.of((Object)"url", (Object)BeanDelegator.nullable((Object)url), (Object)"error", (Object)errorBean, (Object)"responsetimems", (Object)"<NULL sentinel>", (Object)"expiretimems", (Object)"<NULL sentinel>"));
    }

    @VisibleForTesting
    GadgetsHandlerApi.MetadataResponse createMetadataResponse(Uri url, GadgetSpec spec, Map<String, Uri> iframeUris, Boolean needsTokenRefresh, Set<String> fields, Long expireTime, Integer tokenTTL, Set<String> rpcServiceIds) {
        return (GadgetsHandlerApi.MetadataResponse)this.beanFilter.createFilteredBean(this.beanDelegator.createDelegator((Object)spec, GadgetsHandlerApi.MetadataResponse.class, (Map)ImmutableMap.builder().put((Object)"url", (Object)url).put((Object)"error", (Object)"<NULL sentinel>").put((Object)"iframeurls", BeanDelegator.nullable(iframeUris)).put((Object)"needstokenrefresh", BeanDelegator.nullable((Object)needsTokenRefresh)).put((Object)"responsetimems", (Object)this.timeSource.currentTimeMillis()).put((Object)"expiretimems", BeanDelegator.nullable((Object)expireTime)).put((Object)"rpcserviceids", BeanDelegator.nullable(rpcServiceIds)).put((Object)"tokenttl", BeanDelegator.nullable((Object)tokenTTL)).build()), fields);
    }

    @VisibleForTesting
    GadgetsHandlerApi.TokenResponse createTokenResponse(Uri url, String token, Set<String> fields, Long tokenExpire, Integer tokenTTL, Long moduleId) {
        return (GadgetsHandlerApi.TokenResponse)this.beanFilter.createFilteredBean(this.beanDelegator.createDelegator(null, GadgetsHandlerApi.TokenResponse.class, (Map)ImmutableMap.builder().put((Object)"url", (Object)url).put((Object)"error", (Object)"<NULL sentinel>").put((Object)"token", BeanDelegator.nullable((Object)token)).put((Object)"responsetimems", (Object)this.timeSource.currentTimeMillis()).put((Object)"expiretimems", BeanDelegator.nullable((Object)tokenExpire)).put((Object)"tokenttl", BeanDelegator.nullable((Object)tokenTTL)).put((Object)"moduleid", BeanDelegator.nullable((Object)moduleId)).build()), fields);
    }

    protected JsUriManager.JsUri createJsUri(GadgetsHandlerApi.JsRequest request) {
        RenderingContext context = request.getContext() != null ? this.beanDelegator.convertEnum((Enum)request.getContext()) : RenderingContext.GADGET;
        return new JsUriManager.JsUri(request.getRefresh(), request.getDebug(), request.getIgnoreCache(), request.getContainer(), request.getGadget(), request.getFeatures(), request.getLoadedFeatures(), request.getOnload(), false, false, context, request.getUrl(), request.getRepository());
    }

    @VisibleForTesting
    GadgetsHandlerApi.JsResponse createJsResponse(Uri url, Uri jsUri, String content, Set<String> fields, Long expireMs) {
        return (GadgetsHandlerApi.JsResponse)this.beanFilter.createFilteredBean(this.beanDelegator.createDelegator(null, GadgetsHandlerApi.JsResponse.class, (Map)ImmutableMap.builder().put((Object)"url", BeanDelegator.nullable((Object)url)).put((Object)"error", (Object)"<NULL sentinel>").put((Object)"jsurl", (Object)jsUri).put((Object)"jscontent", BeanDelegator.nullable((Object)content)).put((Object)"responsetimems", (Object)this.timeSource.currentTimeMillis()).put((Object)"expiretimems", BeanDelegator.nullable((Object)expireMs)).build()), fields);
    }

    protected ProxyUriManager.ProxyUri createProxyUri(GadgetsHandlerApi.ProxyRequest request) {
        ProxyUriManager.ProxyUri proxyUri = new ProxyUriManager.ProxyUri(request.getRefresh(), request.getDebug(), request.getIgnoreCache(), request.getContainer(), request.getGadget(), request.getUrl());
        proxyUri.setFallbackUrl(request.getFallbackUrl()).setRewriteMimeType(request.getRewriteMimeType()).setSanitizeContent(request.getSanitize());
        GadgetsHandlerApi.ImageParams image = request.getImageParams();
        if (image != null) {
            proxyUri.setResize(image.getWidth(), image.getHeight(), image.getQuality(), image.getDoNotExpand());
        }
        return proxyUri;
    }

    @VisibleForTesting
    GadgetsHandlerApi.ProxyResponse createProxyResponse(Uri uri, HttpResponse httpResponse, Set<String> fields, Long expireMs) throws IOException {
        GadgetsHandlerApi.HttpResponse beanHttp = null;
        if (httpResponse != null) {
            String content = "";
            if (httpResponse.getContentLength() > 0) {
                Base64InputStream b64input = new Base64InputStream(httpResponse.getResponse(), true, 0, null);
                content = IOUtils.toString((InputStream)b64input);
            }
            ImmutableList.Builder headersBuilder = ImmutableList.builder();
            for (Map.Entry entry : httpResponse.getHeaders().entries()) {
                headersBuilder.add(this.beanDelegator.createDelegator(null, GadgetsHandlerApi.NameValuePair.class, (Map)ImmutableMap.of((Object)"name", entry.getKey(), (Object)"value", entry.getValue())));
            }
            beanHttp = (GadgetsHandlerApi.HttpResponse)this.beanDelegator.createDelegator(null, GadgetsHandlerApi.HttpResponse.class, (Map)ImmutableMap.of((Object)"code", (Object)httpResponse.getHttpStatusCode(), (Object)"encoding", (Object)httpResponse.getEncoding(), (Object)"contentbase64", (Object)content, (Object)"headers", (Object)headersBuilder.build()));
        }
        return (GadgetsHandlerApi.ProxyResponse)this.beanFilter.createFilteredBean(this.beanDelegator.createDelegator(null, GadgetsHandlerApi.ProxyResponse.class, (Map)ImmutableMap.builder().put((Object)"proxyurl", (Object)uri).put((Object)"proxycontent", BeanDelegator.nullable(beanHttp)).put((Object)"url", (Object)"<NULL sentinel>").put((Object)"error", (Object)"<NULL sentinel>").put((Object)"responsetimems", (Object)this.timeSource.currentTimeMillis()).put((Object)"expiretimems", BeanDelegator.nullable((Object)expireMs)).build()), fields);
    }

    @VisibleForTesting
    GadgetsHandlerApi.CajaResponse createCajaResponse(Uri uri, String html, String js, List<GadgetsHandlerApi.Message> messages, Set<String> fields, Long expireMs) {
        ImmutableList.Builder msgBuilder = ImmutableList.builder();
        for (GadgetsHandlerApi.Message m : messages) {
            msgBuilder.add(this.beanDelegator.createDelegator(null, GadgetsHandlerApi.Message.class, (Map)ImmutableMap.of((Object)"name", (Object)m.getName(), (Object)"level", (Object)((Object)m.getLevel()), (Object)"message", (Object)m.getMessage())));
        }
        return (GadgetsHandlerApi.CajaResponse)this.beanFilter.createFilteredBean(this.beanDelegator.createDelegator(null, GadgetsHandlerApi.CajaResponse.class, (Map)ImmutableMap.builder().put((Object)"url", (Object)uri).put((Object)"html", BeanDelegator.nullable((Object)html)).put((Object)"js", BeanDelegator.nullable((Object)js)).put((Object)"messages", (Object)msgBuilder.build()).put((Object)"error", (Object)"<NULL sentinel>").put((Object)"responsetimems", (Object)this.timeSource.currentTimeMillis()).put((Object)"expiretimems", BeanDelegator.nullable((Object)expireMs)).build()), fields);
    }

    private static class MessageImpl
    implements GadgetsHandlerApi.Message {
        private final GadgetsHandlerApi.MessageLevel level;
        private final String message;
        private final String name;

        public MessageImpl(String name, String message, GadgetsHandlerApi.MessageLevel level) {
            this.name = name;
            this.message = message;
            this.level = level;
        }

        @Override
        public GadgetsHandlerApi.MessageLevel getLevel() {
            return this.level;
        }

        @Override
        public String getMessage() {
            return this.message;
        }

        @Override
        public String getName() {
            return this.name;
        }
    }

    protected class MetadataGadgetContext
    extends GadgetContext {
        private final GadgetsHandlerApi.MetadataRequest request;
        private final SecurityToken authContext;

        public MetadataGadgetContext(GadgetsHandlerApi.MetadataRequest request) {
            this.request = request;
            this.authContext = GadgetsHandlerService.this.convertAuthContext(request.getAuthContext(), request.getContainer(), request.getUrl().toString());
        }

        @Override
        public Uri getUrl() {
            return this.request.getUrl();
        }

        @Override
        public String getContainer() {
            return this.request.getContainer();
        }

        @Override
        public RenderingContext getRenderingContext() {
            return RenderingContext.METADATA;
        }

        @Override
        public long getModuleId() {
            return 1L;
        }

        @Override
        public Locale getLocale() {
            return this.request.getLocale() == null ? DEFAULT_LOCALE : this.request.getLocale();
        }

        @Override
        public boolean getIgnoreCache() {
            return this.request.getIgnoreCache();
        }

        @Override
        public boolean getDebug() {
            return this.request.getDebug();
        }

        @Override
        public String getView() {
            return this.request.getView();
        }

        @Override
        public SecurityToken getToken() {
            return this.authContext;
        }

        @Override
        public boolean getSanitize() {
            return this.request.getRenderingType() == GadgetsHandlerApi.RenderingType.SANITIZED;
        }

        @Override
        public boolean getCajoled() {
            return this.request.getRenderingType() == GadgetsHandlerApi.RenderingType.IFRAME_CAJOLED;
        }
    }
}

