/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.servlet;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.name.Named;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shindig.common.crypto.BlobCrypter;
import org.apache.shindig.common.servlet.HttpUtil;
import org.apache.shindig.common.servlet.InjectedServlet;
import org.apache.shindig.gadgets.oauth2.OAuth2Accessor;
import org.apache.shindig.gadgets.oauth2.OAuth2CallbackState;
import org.apache.shindig.gadgets.oauth2.OAuth2Error;
import org.apache.shindig.gadgets.oauth2.OAuth2Message;
import org.apache.shindig.gadgets.oauth2.OAuth2Store;
import org.apache.shindig.gadgets.oauth2.handler.AuthorizationEndpointResponseHandler;
import org.apache.shindig.gadgets.oauth2.handler.OAuth2HandlerError;

public class OAuth2CallbackServlet
extends InjectedServlet {
    private static final long serialVersionUID = -8829844832872635091L;
    private static final String LOG_CLASS = OAuth2CallbackServlet.class.getName();
    private static final Logger LOGGER = Logger.getLogger(LOG_CLASS);
    private transient List<AuthorizationEndpointResponseHandler> authorizationEndpointResponseHandlers;
    private transient OAuth2Store store;
    private transient Provider<OAuth2Message> oauth2MessageProvider;
    private transient BlobCrypter stateCrypter;
    private transient boolean sendTraceToClient = false;
    private static final String RESP_BODY = "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/html4/loose.dtd\">\n<html>\n<head>\n<title>Close this window</title>\n</head>\n<body>\n<script type='text/javascript'>\ntry {\n  window.opener.gadgets.io.oauthReceivedCallbackUrl_ = document.location.href;\n} catch (e) {\n}\nwindow.close();\n</script>\nClose this window.\n</body>\n</html>\n";
    private static final String RESP_ERROR_BODY = "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/html4/loose.dtd\">\n<html>\n<head>\n<title>OAuth2 Error</title>\n</head>\n<body>\n<p>error = %s</p><p>error description = %s</p><p>error uri = %s</p>Close this window.\n</body>\n</html>\n";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse resp) throws IOException {
        OAuth2Accessor accessor = null;
        try {
            OAuth2Message msg = (OAuth2Message)this.oauth2MessageProvider.get();
            msg.parseRequest(request);
            OAuth2Error error = msg.getError();
            String encRequestStateKey = msg.getState();
            if (encRequestStateKey == null) {
                if (error != null) {
                    OAuth2CallbackServlet.sendError(error, "encRequestStateKey is null", msg.getErrorUri(), msg.getErrorDescription(), null, resp, null, this.sendTraceToClient);
                } else {
                    OAuth2CallbackServlet.sendError(OAuth2Error.CALLBACK_PROBLEM, "OAuth2CallbackServlet requestStateKey is null.", "", "", null, resp, null, this.sendTraceToClient);
                }
                return;
            }
            OAuth2CallbackState state = new OAuth2CallbackState(this.stateCrypter, encRequestStateKey);
            accessor = this.store.getOAuth2Accessor(state);
            if (error != null) {
                OAuth2CallbackServlet.sendError(error, "error parsing request", msg.getErrorDescription(), msg.getErrorUri(), accessor, resp, null, this.sendTraceToClient);
                return;
            }
            if (accessor == null || !accessor.isValid() || accessor.isErrorResponse()) {
                String message;
                if (accessor != null) {
                    message = accessor.isValid() ? "OAuth2CallbackServlet accessor isErrorResponse " : "OAuth2CallbackServlet accessor is invalid ";
                    message = message + accessor;
                } else {
                    message = "OAuth2CallbackServlet accessor is null";
                }
                OAuth2CallbackServlet.sendError(OAuth2Error.CALLBACK_PROBLEM, message, accessor.getErrorContextMessage(), accessor.getErrorUri(), accessor, resp, accessor.getErrorException(), this.sendTraceToClient);
                return;
            }
            if (!accessor.isRedirecting()) {
                OAuth2CallbackServlet.sendError(OAuth2Error.CALLBACK_PROBLEM, "OAuth2CallbackServlet accessor is not valid, isn't redirecting.", "", "", accessor, resp, null, this.sendTraceToClient);
                return;
            }
            boolean foundHandler = false;
            for (AuthorizationEndpointResponseHandler authorizationEndpointResponseHandler : this.authorizationEndpointResponseHandlers) {
                if (!authorizationEndpointResponseHandler.handlesRequest(accessor, request)) continue;
                OAuth2HandlerError handlerError = authorizationEndpointResponseHandler.handleRequest(accessor, request);
                if (handlerError != null) {
                    OAuth2CallbackServlet.sendError(handlerError.getError(), handlerError.getContextMessage(), handlerError.getDescription(), handlerError.getUri(), accessor, resp, handlerError.getCause(), this.sendTraceToClient);
                    return;
                }
                foundHandler = true;
                break;
            }
            if (!foundHandler) {
                OAuth2CallbackServlet.sendError(OAuth2Error.NO_RESPONSE_HANDLER, "OAuth2Callback servlet couldn't find a AuthorizationEndpointResponseHandler", "", "", accessor, resp, null, this.sendTraceToClient);
                return;
            }
            HttpUtil.setNoCache((HttpServletResponse)resp);
            resp.setContentType("text/html; charset=UTF-8");
            resp.getWriter().write(RESP_BODY);
        }
        catch (Exception e) {
            OAuth2CallbackServlet.sendError(OAuth2Error.CALLBACK_PROBLEM, "Exception occurred processing redirect.", "", "", accessor, resp, e, this.sendTraceToClient);
            if (IOException.class.isInstance(e)) {
                throw (IOException)e;
            }
        }
        finally {
            if (accessor != null) {
                if (!accessor.isErrorResponse()) {
                    accessor.invalidate();
                    this.store.removeOAuth2Accessor(accessor);
                } else {
                    this.store.storeOAuth2Accessor(accessor);
                }
            }
        }
    }

    private static void sendError(OAuth2Error error, String contextMessage, String description, String uri, OAuth2Accessor accessor, HttpServletResponse resp, Throwable t, boolean sendTraceToClient) throws IOException {
        LOGGER.warning(LOG_CLASS + " , callback error " + (Object)((Object)error) + " -  " + contextMessage + " , " + description + " - " + uri);
        if (t != null && LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, " callback exception ", t);
        }
        HttpUtil.setNoCache((HttpServletResponse)resp);
        resp.setContentType("text/html; charset=UTF-8");
        if (accessor == null) {
            String errorResponse = sendTraceToClient ? String.format(RESP_ERROR_BODY, error.getErrorCode(), error.getErrorDescription(description), uri) : String.format(RESP_ERROR_BODY, error.getErrorCode(), "", "");
            resp.getWriter().write(errorResponse);
            return;
        }
        accessor.setErrorResponse(t, error, contextMessage + " , " + description, uri);
        resp.getWriter().write(RESP_BODY);
    }

    @Inject
    public void setAuthorizationResponseHandlers(List<AuthorizationEndpointResponseHandler> authorizationEndpointResponseHandlers) {
        this.authorizationEndpointResponseHandlers = authorizationEndpointResponseHandlers;
    }

    @Inject
    public void setOAuth2Store(@Named(value="shindig.oauth2.send-trace-to-client") boolean sendTraceToClient) {
        this.sendTraceToClient = sendTraceToClient;
    }

    @Inject
    public void setOAuth2Store(OAuth2Store store) {
        this.store = store;
    }

    @Inject
    public void setOauth2MessageProvider(Provider<OAuth2Message> oauth2MessageProvider) {
        this.oauth2MessageProvider = oauth2MessageProvider;
    }

    @Inject
    public void setStateCrypter(@Named(value="shindig.oauth2.state-crypter") BlobCrypter stateCrypter) {
        this.stateCrypter = stateCrypter;
    }
}

