/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.templates;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ELResolver;
import javax.el.ValueExpression;
import org.apache.shindig.expressions.Expressions;
import org.apache.shindig.gadgets.GadgetELResolver;
import org.apache.shindig.gadgets.parse.HtmlSerialization;
import org.apache.shindig.gadgets.templates.ElementELResolver;
import org.apache.shindig.gadgets.templates.TagRegistry;
import org.apache.shindig.gadgets.templates.TemplateContext;
import org.apache.shindig.gadgets.templates.TemplateELResolver;
import org.apache.shindig.gadgets.templates.TemplateProcessor;
import org.apache.shindig.gadgets.templates.tags.RepeatTagHandler;
import org.apache.shindig.gadgets.templates.tags.TagHandler;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DefaultTemplateProcessor
implements TemplateProcessor {
    private static final String classname = DefaultTemplateProcessor.class.getName();
    private static final Logger LOG = Logger.getLogger(classname, "org.apache.shindig.common.logging.i18n.resource");
    public static final String PROPERTY_INDEX = "Index";
    public static final String PROPERTY_COUNT = "Count";
    public static final String ATTRIBUTE_IF = "if";
    public static final String ATTRIBUTE_INDEX = "index";
    public static final String ATTRIBUTE_REPEAT = "repeat";
    public static final String ATTRIBUTE_VAR = "var";
    public static final String ATTRIBUTE_CUR = "cur";
    private static final Set<String> HTML4_BOOLEAN_ATTRIBUTES = ImmutableSet.of((Object)"checked", (Object)"compact", (Object)"declare", (Object)"defer", (Object)"disabled", (Object)"ismap", (Object[])new String[]{"multiple", "nohref", "noresize", "noshade", "nowrap", "readonly", "selected"});
    private static final Set<String> ONCREATE_ATTRIBUTES = ImmutableSet.of((Object)"oncreate", (Object)"x-oncreate");
    private final Expressions expressions;
    private final StringBuilder outputBuffer;
    private TagRegistry registry;
    private TemplateContext templateContext;
    private ELContext elContext;
    private int uniqueIdCounter = 0;

    @Inject
    public DefaultTemplateProcessor(Expressions expressions) {
        this.expressions = expressions;
        this.outputBuffer = new StringBuilder();
    }

    @Override
    public DocumentFragment processTemplate(Element template, TemplateContext templateContext, ELResolver globals, TagRegistry registry) {
        this.registry = registry;
        this.templateContext = templateContext;
        this.elContext = this.expressions.newELContext(new ELResolver[]{globals, new GadgetELResolver(templateContext.getGadget().getContext()), new TemplateELResolver(templateContext), new ElementELResolver()});
        DocumentFragment result = template.getOwnerDocument().createDocumentFragment();
        this.processChildNodes(result, template);
        return result;
    }

    @Override
    public void processChildNodes(Node result, Node source) {
        NodeList nodes = source.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            this.processNode(result, nodes.item(i));
        }
    }

    @Override
    public TemplateContext getTemplateContext() {
        return this.templateContext;
    }

    private void processNode(Node result, Node source) {
        switch (source.getNodeType()) {
            case 3: {
                this.processText(result, source.getTextContent());
                break;
            }
            case 1: {
                this.processElement(result, (Element)source);
                break;
            }
            case 9: {
                this.processChildNodes(result, source);
            }
        }
    }

    private void processText(Node result, String textContent) {
        Document ownerDocument = result.getOwnerDocument();
        int start = 0;
        int current = 0;
        while (current < textContent.length() && (current = textContent.indexOf("${", current)) >= 0) {
            String expression;
            String value;
            if (current > 0 && textContent.charAt(current - 1) == '\\') {
                if (current - 1 > start) {
                    String staticText = textContent.substring(start, current - 1);
                    result.appendChild(ownerDocument.createTextNode(staticText));
                }
                start = current - 1;
                current += 2;
                continue;
            }
            int expressionEnd = textContent.indexOf(125, current + 2);
            if (expressionEnd < 0) break;
            if (current > start) {
                result.appendChild(ownerDocument.createTextNode(textContent.substring(start, current)));
            }
            if (!"".equals(value = this.evaluate(expression = textContent.substring(current, expressionEnd + 1), String.class, ""))) {
                this.outputBuffer.setLength(0);
                try {
                    HtmlSerialization.printEscapedText(value, this.outputBuffer);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                result.appendChild(ownerDocument.createTextNode(this.outputBuffer.toString()));
            }
            current = start = expressionEnd + 1;
        }
        if (start < textContent.length()) {
            result.appendChild(ownerDocument.createTextNode(textContent.substring(start)));
        }
    }

    private void processElement(final Node result, final Element element) {
        Attr repeat = element.getAttributeNode(ATTRIBUTE_REPEAT);
        if (repeat != null) {
            Iterable dataList = this.evaluate(repeat.getValue(), Iterable.class, null);
            this.processRepeat(result, element, dataList, new Runnable(){

                @Override
                public void run() {
                    DefaultTemplateProcessor.this.processElementInner(result, element);
                }
            });
        } else {
            this.processElementInner(result, element);
        }
    }

    @Override
    public void processRepeat(Node result, Element element, Iterable<?> dataList, Runnable onEachLoop) {
        if (dataList == null) {
            return;
        }
        int size = Iterables.size(dataList);
        if (size > 0) {
            Map<String, ? extends Object> oldContext = this.templateContext.getContext();
            Object oldCur = this.templateContext.getCur();
            ValueExpression oldVarExpression = null;
            HashMap loopData = Maps.newHashMap(oldContext);
            loopData.put(PROPERTY_COUNT, size);
            this.templateContext.setContext(loopData);
            Attr varAttr = element.getAttributeNode(ATTRIBUTE_VAR);
            if (varAttr == null) {
                oldCur = this.templateContext.getCur();
            } else {
                oldVarExpression = this.elContext.getVariableMapper().resolveVariable(varAttr.getValue());
            }
            Attr indexVarAttr = element.getAttributeNode(ATTRIBUTE_INDEX);
            String indexVar = indexVarAttr == null ? PROPERTY_INDEX : indexVarAttr.getValue();
            int index = 0;
            for (Object data : dataList) {
                loopData.put(indexVar, index++);
                this.templateContext.setCur(data);
                if (varAttr != null) {
                    ValueExpression varExpression = this.expressions.constant(data, Object.class);
                    this.elContext.getVariableMapper().setVariable(varAttr.getValue(), varExpression);
                }
                onEachLoop.run();
            }
            if (varAttr == null) {
                this.templateContext.setCur(oldCur);
            } else {
                this.elContext.getVariableMapper().setVariable(varAttr.getValue(), oldVarExpression);
            }
            this.templateContext.setContext(oldContext);
        }
    }

    private void processElementInner(Node result, Element element) {
        Attr ifAttribute;
        TagHandler handler = this.registry.getHandlerFor(element);
        if (!(handler instanceof RepeatTagHandler) && (ifAttribute = element.getAttributeNode(ATTRIBUTE_IF)) != null && !this.evaluate(ifAttribute.getValue(), Boolean.class, false).booleanValue()) {
            return;
        }
        Attr curAttribute = element.getAttributeNode(ATTRIBUTE_CUR);
        Object oldCur = this.templateContext.getCur();
        if (curAttribute != null) {
            this.templateContext.setCur(this.evaluate(curAttribute.getValue(), Object.class, null));
        }
        if (handler != null) {
            handler.process(result, element, this);
        } else {
            Element resultNode = element.getOwnerDocument() != result.getOwnerDocument() ? (Element)result.getOwnerDocument().importNode(element, false) : (Element)element.cloneNode(false);
            this.clearSpecialAttributes(resultNode);
            Node additionalNode = this.processAttributes(resultNode);
            this.processChildNodes(resultNode, element);
            result.appendChild(resultNode);
            if (additionalNode != null) {
                result.appendChild(additionalNode);
            }
        }
        if (curAttribute != null) {
            this.templateContext.setCur(oldCur);
        }
    }

    private void clearSpecialAttributes(Element element) {
        element.removeAttribute(ATTRIBUTE_IF);
        element.removeAttribute(ATTRIBUTE_REPEAT);
        element.removeAttribute(ATTRIBUTE_INDEX);
        element.removeAttribute(ATTRIBUTE_VAR);
        element.removeAttribute(ATTRIBUTE_CUR);
    }

    private Node processAttributes(Element element) {
        NamedNodeMap attributes = element.getAttributes();
        Node additionalNode = null;
        List attrsToRemove = null;
        String newId = null;
        for (int i = 0; i < attributes.getLength(); ++i) {
            boolean removeThisAttribute = false;
            Attr attribute = (Attr)attributes.item(i);
            if (element.getNamespaceURI() == null && HTML4_BOOLEAN_ATTRIBUTES.contains(attribute.getName())) {
                if (Boolean.TRUE.equals(this.evaluate(attribute.getValue(), Boolean.class, Boolean.FALSE))) {
                    attribute.setNodeValue(attribute.getName());
                } else {
                    removeThisAttribute = true;
                }
            } else if (ONCREATE_ATTRIBUTES.contains(attribute.getName())) {
                String id = element.getAttribute("id");
                if (id.length() == 0) {
                    newId = id = this.getUniqueId();
                }
                additionalNode = this.buildOnCreateScript(this.evaluate(attribute.getValue(), String.class, null), id, element.getOwnerDocument());
                removeThisAttribute = true;
            } else {
                attribute.setNodeValue(this.evaluate(attribute.getValue(), String.class, null));
            }
            if (!removeThisAttribute) continue;
            if (attrsToRemove == null) {
                attrsToRemove = Lists.newArrayListWithCapacity((int)attributes.getLength());
            }
            attrsToRemove.add(attribute);
        }
        if (attrsToRemove != null) {
            for (Attr attr : attrsToRemove) {
                element.removeAttributeNode(attr);
            }
        }
        if (newId != null) {
            element.setAttribute("id", newId);
        }
        return additionalNode;
    }

    private Node buildOnCreateScript(String code, String id, Document document) {
        Element script = document.createElement("script");
        script.setAttribute("type", "text/javascript");
        StringBuilder builder = new StringBuilder();
        builder.append("(function(){");
        builder.append(code);
        builder.append("}).apply(document.getElementById('");
        builder.append(id);
        builder.append("'));");
        script.setTextContent(builder.toString());
        return script;
    }

    @Override
    public <T> T evaluate(String expression, Class<T> type, T defaultValue) {
        try {
            ValueExpression expr = this.expressions.parse(expression, type);
            this.elContext.putContext(TemplateContext.class, (Object)this.elContext);
            Object result = expr.getValue(this.elContext);
            return type.cast(result);
        }
        catch (ELException e) {
            if (LOG.isLoggable(Level.WARNING)) {
                LOG.logp(Level.WARNING, classname, "evaluate", "elFailure", new Object[]{this.getTemplateContext().getGadget().getContext().getUrl(), e.getMessage()});
            }
            return defaultValue;
        }
    }

    private String getUniqueId() {
        return "ostid" + this.uniqueIdCounter++;
    }
}

