/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.rewrite;

import java.util.List;
import org.apache.shindig.gadgets.Gadget;
import org.apache.shindig.gadgets.rewrite.DomWalker;
import org.apache.shindig.gadgets.rewrite.RewritingException;
import org.apache.shindig.gadgets.uri.UriUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ContentTypeCharsetRemoverVisitor
implements DomWalker.Visitor {
    public static final String CONTENT = "content";
    public static final String CONTENT_TYPE = "content-type";
    public static final String HTTP_EQUIV = "http-equiv";
    public static final String META = "meta";

    @Override
    public DomWalker.Visitor.VisitStatus visit(Gadget gadget, Node node) throws RewritingException {
        if (node.getNodeType() == 1 && META.equalsIgnoreCase(node.getNodeName())) {
            Element elem = (Element)node;
            String httpEquip = elem.getAttribute(HTTP_EQUIV);
            String content = elem.getAttribute(CONTENT);
            if (httpEquip != null && content != null && CONTENT_TYPE.equalsIgnoreCase(httpEquip)) {
                elem.setAttribute(CONTENT, UriUtils.getContentTypeWithoutCharset(content));
                return DomWalker.Visitor.VisitStatus.MODIFY;
            }
        }
        return DomWalker.Visitor.VisitStatus.BYPASS;
    }

    @Override
    public boolean revisit(Gadget gadget, List<Node> nodes) {
        return false;
    }
}

