/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.servlet;

import com.google.common.collect.Maps;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import org.apache.shindig.auth.AuthInfoUtil;
import org.apache.shindig.auth.SecurityToken;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.gadgets.GadgetContext;
import org.apache.shindig.gadgets.RenderingContext;
import org.apache.shindig.gadgets.UserPrefs;
import org.apache.shindig.gadgets.uri.UriCommon;

public class HttpGadgetContext
extends GadgetContext {
    public static final String USERPREF_PARAM_PREFIX = "up_";
    private final HttpServletRequest request;
    private final String container;
    private final Boolean debug;
    private final Boolean ignoreCache;
    private final Locale locale;
    private final Integer moduleId;
    private final RenderingContext renderingContext;
    private final Uri url;
    private final UserPrefs userPrefs;
    private final String view;
    private final String referer;

    public HttpGadgetContext(HttpServletRequest request) {
        this.request = request;
        this.container = HttpGadgetContext.getContainer(request);
        this.debug = HttpGadgetContext.getDebug(request);
        this.ignoreCache = HttpGadgetContext.getIgnoreCache(request);
        this.locale = HttpGadgetContext.getLocale(request);
        this.moduleId = HttpGadgetContext.getModuleId(request);
        this.renderingContext = HttpGadgetContext.getRenderingContext(request);
        this.url = HttpGadgetContext.getUrl(request);
        this.userPrefs = HttpGadgetContext.getUserPrefs(request);
        this.view = HttpGadgetContext.getView(request);
        this.referer = this.getReferer();
    }

    @Override
    public String getParameter(String name) {
        return this.request.getParameter(name);
    }

    @Override
    public String getContainer() {
        return this.container == null ? super.getContainer() : this.container;
    }

    @Override
    public String getHost() {
        String host = this.request.getHeader("Host");
        return host == null ? super.getHost() : host;
    }

    @Override
    public String getHostSchema() {
        String schema = this.request.getScheme();
        return schema == null ? super.getHostSchema() : schema;
    }

    @Override
    public String getUserIp() {
        String ip = this.request.getRemoteAddr();
        return ip == null ? super.getUserIp() : ip;
    }

    @Override
    public boolean getDebug() {
        return this.debug == null ? super.getDebug() : this.debug.booleanValue();
    }

    @Override
    public boolean getIgnoreCache() {
        if (this.ignoreCache == null) {
            return super.getIgnoreCache();
        }
        return this.ignoreCache;
    }

    @Override
    public Locale getLocale() {
        return this.locale == null ? super.getLocale() : this.locale;
    }

    @Override
    public long getModuleId() {
        return this.moduleId == null ? super.getModuleId() : (long)this.moduleId.intValue();
    }

    @Override
    public RenderingContext getRenderingContext() {
        return this.renderingContext == null ? super.getRenderingContext() : this.renderingContext;
    }

    @Override
    public SecurityToken getToken() {
        return AuthInfoUtil.getSecurityTokenFromRequest((HttpServletRequest)this.request);
    }

    @Override
    public Uri getUrl() {
        return this.url == null ? super.getUrl() : this.url;
    }

    @Override
    public UserPrefs getUserPrefs() {
        if (this.userPrefs == null) {
            return super.getUserPrefs();
        }
        return this.userPrefs;
    }

    @Override
    public String getView() {
        if (this.view == null) {
            return super.getView();
        }
        return this.view;
    }

    @Override
    public String getUserAgent() {
        String userAgent = this.request.getHeader("User-Agent");
        if (userAgent == null) {
            return super.getUserAgent();
        }
        return userAgent;
    }

    @Override
    public String getRepository() {
        String repository = this.request.getHeader(UriCommon.Param.REPOSITORY_ID.getKey());
        if (repository == null) {
            return super.getRepository();
        }
        return repository;
    }

    @Override
    public String getReferer() {
        String referer = this.request.getHeader("Referer");
        return referer == null ? super.getReferer() : referer;
    }

    private static String getContainer(HttpServletRequest req) {
        String container = req.getParameter(UriCommon.Param.CONTAINER.getKey());
        if (container == null) {
            container = req.getParameter(UriCommon.Param.SYND.getKey());
        }
        return container;
    }

    private static Boolean getDebug(HttpServletRequest req) {
        String debug = req.getParameter(UriCommon.Param.DEBUG.getKey());
        if (debug == null) {
            return Boolean.FALSE;
        }
        if ("0".equals(debug)) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private static Boolean getIgnoreCache(HttpServletRequest req) {
        String ignoreCache = req.getParameter(UriCommon.Param.NO_CACHE.getKey());
        if (ignoreCache == null) {
            return Boolean.FALSE;
        }
        if ("0".equals(ignoreCache)) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private static Locale getLocale(HttpServletRequest req) {
        String language = req.getParameter(UriCommon.Param.LANG.getKey());
        String country = req.getParameter(UriCommon.Param.COUNTRY.getKey());
        if (language == null && country == null) {
            return null;
        }
        if (language == null) {
            language = "all";
        } else if (country == null) {
            country = "ALL";
        }
        return new Locale(language, country);
    }

    private static Integer getModuleId(HttpServletRequest req) {
        String mid = req.getParameter("mid");
        if (mid == null) {
            return null;
        }
        try {
            return Integer.parseInt(mid);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    private static RenderingContext getRenderingContext(HttpServletRequest req) {
        String c = req.getParameter(UriCommon.Param.CONTAINER_MODE.getKey());
        if (c == null) {
            return null;
        }
        return RenderingContext.valueOfParam(c);
    }

    private static Uri getUrl(HttpServletRequest req) {
        String url = req.getParameter(UriCommon.Param.URL.getKey());
        if (url == null) {
            return null;
        }
        try {
            return Uri.parse((String)url);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    private static UserPrefs getUserPrefs(HttpServletRequest req) {
        HashMap prefs = Maps.newHashMap();
        Enumeration paramNames = req.getParameterNames();
        if (paramNames == null) {
            return null;
        }
        while (paramNames.hasMoreElements()) {
            String paramName = (String)paramNames.nextElement();
            if (!paramName.startsWith(USERPREF_PARAM_PREFIX)) continue;
            String prefName = paramName.substring(USERPREF_PARAM_PREFIX.length());
            prefs.put(prefName, req.getParameter(paramName));
        }
        return new UserPrefs(prefs);
    }

    private static String getView(HttpServletRequest req) {
        return req.getParameter(UriCommon.Param.VIEW.getKey());
    }
}

