/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.social.sample.spi;

import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.Futures;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import org.apache.commons.io.IOUtils;
import org.apache.shindig.auth.SecurityToken;
import org.apache.shindig.common.servlet.Authority;
import org.apache.shindig.common.util.ResourceLoader;
import org.apache.shindig.protocol.DataCollection;
import org.apache.shindig.protocol.ProtocolException;
import org.apache.shindig.protocol.RestfulCollection;
import org.apache.shindig.protocol.conversion.BeanConverter;
import org.apache.shindig.protocol.model.SortOrder;
import org.apache.shindig.social.core.model.NameImpl;
import org.apache.shindig.social.core.model.PersonImpl;
import org.apache.shindig.social.opensocial.model.Activity;
import org.apache.shindig.social.opensocial.model.ActivityEntry;
import org.apache.shindig.social.opensocial.model.Album;
import org.apache.shindig.social.opensocial.model.Group;
import org.apache.shindig.social.opensocial.model.MediaItem;
import org.apache.shindig.social.opensocial.model.Message;
import org.apache.shindig.social.opensocial.model.MessageCollection;
import org.apache.shindig.social.opensocial.model.Person;
import org.apache.shindig.social.opensocial.spi.ActivityService;
import org.apache.shindig.social.opensocial.spi.ActivityStreamService;
import org.apache.shindig.social.opensocial.spi.AlbumService;
import org.apache.shindig.social.opensocial.spi.AppDataService;
import org.apache.shindig.social.opensocial.spi.CollectionOptions;
import org.apache.shindig.social.opensocial.spi.GroupId;
import org.apache.shindig.social.opensocial.spi.GroupService;
import org.apache.shindig.social.opensocial.spi.MediaItemService;
import org.apache.shindig.social.opensocial.spi.MessageService;
import org.apache.shindig.social.opensocial.spi.PersonService;
import org.apache.shindig.social.opensocial.spi.UserId;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Singleton
public class JsonDbOpensocialService
implements ActivityService,
PersonService,
AppDataService,
MessageService,
AlbumService,
MediaItemService,
ActivityStreamService,
GroupService {
    private static final Comparator<Person> NAME_COMPARATOR = new Comparator<Person>(){

        @Override
        public int compare(Person person, Person person1) {
            String name = person.getName().getFormatted();
            String name1 = person1.getName().getFormatted();
            return name.compareTo(name1);
        }
    };
    private JSONObject db;
    private BeanConverter converter;
    private static final String PEOPLE_TABLE = "people";
    private static final String GROUPS_TABLE = "groups";
    private static final String GROUP_MEMBERS_TABLE = "groupMembers";
    private static final String ACTIVITIES_TABLE = "activities";
    private static final String ALBUMS_TABLE = "albums";
    private static final String MEDIAITEMS_TABLE = "mediaItems";
    private static final String DATA_TABLE = "data";
    private static final String FRIEND_LINK_TABLE = "friendLinks";
    private static final String MESSAGE_TABLE = "messages";
    private static final String PASSWORDS_TABLE = "passwords";
    private static final String ACTIVITYSTREAMS_TABLE = "activityEntries";
    private static final String ANONYMOUS_NAME = "Anonymous";
    private Authority authority;

    @Inject
    public JsonDbOpensocialService(@Named(value="shindig.canonical.json.db") String jsonLocation, @Named(value="shindig.bean.converter.json") BeanConverter converter, @Named(value="shindig.contextroot") String contextroot) throws Exception {
        String content = IOUtils.toString((InputStream)ResourceLoader.openResource((String)jsonLocation), (String)"UTF-8");
        this.db = new JSONObject(content.replace("%contextroot%", contextroot));
        this.converter = converter;
    }

    public JSONObject getDb() {
        return this.db;
    }

    public void setDb(JSONObject db) {
        this.db = db;
    }

    @Inject(optional=true)
    public void setAuthority(Authority authority) {
        this.authority = authority;
    }

    @Override
    public Future<RestfulCollection<Activity>> getActivities(Set<UserId> userIds, GroupId groupId, String appId, Set<String> fields, CollectionOptions options, SecurityToken token) throws ProtocolException {
        ArrayList result = Lists.newArrayList();
        try {
            Set<String> idSet = this.getIdSet(userIds, groupId, token);
            for (String id : idSet) {
                if (!this.db.getJSONObject(ACTIVITIES_TABLE).has(id)) continue;
                JSONArray activities = this.db.getJSONObject(ACTIVITIES_TABLE).getJSONArray(id);
                for (int i = 0; i < activities.length(); ++i) {
                    JSONObject activity = activities.getJSONObject(i);
                    if (appId == null || !activity.has(Activity.Field.APP_ID.toString())) {
                        result.add(this.filterFields(activity, fields, Activity.class));
                        continue;
                    }
                    if (!activity.get(Activity.Field.APP_ID.toString()).equals(appId)) continue;
                    result.add(this.filterFields(activity, fields, Activity.class));
                }
            }
            return Futures.immediateFuture((Object)new RestfulCollection((List)result));
        }
        catch (JSONException je) {
            throw new ProtocolException(500, je.getMessage(), (Throwable)je);
        }
    }

    @Override
    public Future<RestfulCollection<Activity>> getActivities(UserId userId, GroupId groupId, String appId, Set<String> fields, CollectionOptions options, Set<String> activityIds, SecurityToken token) throws ProtocolException {
        ArrayList result = Lists.newArrayList();
        try {
            String user = userId.getUserId(token);
            if (this.db.getJSONObject(ACTIVITIES_TABLE).has(user)) {
                JSONArray activities = this.db.getJSONObject(ACTIVITIES_TABLE).getJSONArray(user);
                for (int i = 0; i < activities.length(); ++i) {
                    JSONObject activity = activities.getJSONObject(i);
                    if (!activity.get(Activity.Field.USER_ID.toString()).equals(user) || !activityIds.contains(activity.getString(Activity.Field.ID.toString()))) continue;
                    result.add(this.filterFields(activity, fields, Activity.class));
                }
            }
            return Futures.immediateFuture((Object)new RestfulCollection((List)result));
        }
        catch (JSONException je) {
            throw new ProtocolException(500, je.getMessage(), (Throwable)je);
        }
    }

    @Override
    public Future<Activity> getActivity(UserId userId, GroupId groupId, String appId, Set<String> fields, String activityId, SecurityToken token) throws ProtocolException {
        try {
            String user = userId.getUserId(token);
            if (this.db.getJSONObject(ACTIVITIES_TABLE).has(user)) {
                JSONArray activities = this.db.getJSONObject(ACTIVITIES_TABLE).getJSONArray(user);
                for (int i = 0; i < activities.length(); ++i) {
                    JSONObject activity = activities.getJSONObject(i);
                    if (!activity.get(Activity.Field.USER_ID.toString()).equals(user) || !activity.get(Activity.Field.ID.toString()).equals(activityId)) continue;
                    return Futures.immediateFuture((Object)this.filterFields(activity, fields, Activity.class));
                }
            }
            throw new ProtocolException(400, "Activity not found");
        }
        catch (JSONException je) {
            throw new ProtocolException(500, je.getMessage(), (Throwable)je);
        }
    }

    @Override
    public Future<Void> deleteActivities(UserId userId, GroupId groupId, String appId, Set<String> activityIds, SecurityToken token) throws ProtocolException {
        try {
            JSONArray activities;
            String user = userId.getUserId(token);
            if (this.db.getJSONObject(ACTIVITIES_TABLE).has(user) && (activities = this.db.getJSONObject(ACTIVITIES_TABLE).getJSONArray(user)) != null) {
                JSONArray newList = new JSONArray();
                for (int i = 0; i < activities.length(); ++i) {
                    JSONObject activity = activities.getJSONObject(i);
                    if (activityIds.contains(activity.getString(Activity.Field.ID.toString()))) continue;
                    newList.put((Object)activity);
                }
                this.db.getJSONObject(ACTIVITIES_TABLE).put(user, (Object)newList);
            }
            return Futures.immediateFuture(null);
        }
        catch (JSONException je) {
            throw new ProtocolException(500, je.getMessage(), (Throwable)je);
        }
    }

    @Override
    public Future<Void> createActivity(UserId userId, GroupId groupId, String appId, Set<String> fields, Activity activity, SecurityToken token) throws ProtocolException {
        try {
            JSONArray jsonArray;
            JSONObject jsonObject = this.convertFromActivity(activity, fields);
            if (!jsonObject.has(Activity.Field.ID.toString())) {
                jsonObject.put(Activity.Field.ID.toString(), System.currentTimeMillis());
            }
            if ((jsonArray = this.db.getJSONObject(ACTIVITIES_TABLE).getJSONArray(userId.getUserId(token))) == null) {
                jsonArray = new JSONArray();
                this.db.getJSONObject(ACTIVITIES_TABLE).put(userId.getUserId(token), (Object)jsonArray);
            }
            jsonArray.put((Object)jsonObject);
            return Futures.immediateFuture(null);
        }
        catch (JSONException je) {
            throw new ProtocolException(500, je.getMessage(), (Throwable)je);
        }
    }

    @Override
    public Future<RestfulCollection<Person>> getPeople(Set<UserId> userIds, GroupId groupId, CollectionOptions options, Set<String> fields, SecurityToken token) throws ProtocolException {
        List<Person> result = Lists.newArrayList();
        try {
            JSONArray people = this.db.getJSONArray(PEOPLE_TABLE);
            Set<String> idSet = this.getIdSet(userIds, groupId, token);
            for (int i = 0; i < people.length(); ++i) {
                JSONObject person = people.getJSONObject(i);
                if (!idSet.contains(person.get(Person.Field.ID.toString()))) continue;
                Person personObj = this.filterFields(person, fields, Person.class);
                Map<String, Object> appData = this.getPersonAppData(person.getString(Person.Field.ID.toString()), fields);
                personObj.setAppData(appData);
                result.add(personObj);
            }
            if (GroupId.Type.self == groupId.getType() && result.isEmpty()) {
                throw new ProtocolException(400, "People '" + idSet + "' not found");
            }
            if (options.getSortBy().equals(Person.Field.NAME.toString())) {
                Collections.sort(result, NAME_COMPARATOR);
                if (options.getSortOrder() == SortOrder.descending) {
                    Collections.reverse(result);
                }
            }
            int totalSize = result.size();
            int last = options.getFirst() + options.getMax();
            result = result.subList(options.getFirst(), Math.min(last, totalSize));
            return Futures.immediateFuture((Object)new RestfulCollection(result, options.getFirst(), totalSize, options.getMax()));
        }
        catch (JSONException je) {
            throw new ProtocolException(500, je.getMessage(), (Throwable)je);
        }
    }

    @Override
    public Future<Person> getPerson(UserId id, Set<String> fields, SecurityToken token) throws ProtocolException {
        if (id != null && "-1".equals(id.getUserId())) {
            PersonImpl anonymous = new PersonImpl();
            anonymous.setId("-1");
            anonymous.setName(new NameImpl(ANONYMOUS_NAME));
            anonymous.setNickname(ANONYMOUS_NAME);
            return Futures.immediateFuture((Object)anonymous);
        }
        try {
            JSONArray people = this.db.getJSONArray(PEOPLE_TABLE);
            for (int i = 0; i < people.length(); ++i) {
                JSONObject person = people.getJSONObject(i);
                if (id == null || !person.get(Person.Field.ID.toString()).equals(id.getUserId(token))) continue;
                Person personObj = this.filterFields(person, fields, Person.class);
                Map<String, Object> appData = this.getPersonAppData(person.getString(Person.Field.ID.toString()), fields);
                personObj.setAppData(appData);
                return Futures.immediateFuture((Object)personObj);
            }
            throw new ProtocolException(400, "Person '" + id.getUserId(token) + "' not found");
        }
        catch (JSONException je) {
            throw new ProtocolException(500, je.getMessage(), (Throwable)je);
        }
    }

    @Override
    public Future<Person> updatePerson(UserId id, Person person, SecurityToken token) throws ProtocolException {
        try {
            String viewer = token.getViewerId();
            String user = id.getUserId(token);
            if (!this.viewerCanUpdatePerson(viewer, user)) {
                throw new ProtocolException(403, "User '" + viewer + "' does not have enough privileges to update person '" + user + "'");
            }
            JSONArray people = this.db.getJSONArray(PEOPLE_TABLE);
            for (int i = 0; i < people.length(); ++i) {
                JSONObject curPerson = people.getJSONObject(i);
                if (user == null || !curPerson.getString(Person.Field.ID.toString()).equals(user)) continue;
                JSONObject jsonPerson = this.convertToJson(person);
                for (String key : JSONObject.getNames((JSONObject)jsonPerson)) {
                    curPerson.put(key, jsonPerson.get(key));
                }
                people.put(i, (Object)curPerson);
                return Futures.immediateFuture((Object)this.converter.convertToObject(curPerson.toString(), Person.class));
            }
            throw new ProtocolException(400, "User ID " + user + " does not exist");
        }
        catch (JSONException je) {
            throw new ProtocolException(500, je.getMessage(), (Throwable)je);
        }
    }

    protected boolean viewerCanUpdatePerson(String viewer, String person) {
        return viewer.equals(person);
    }

    private Map<String, Object> getPersonAppData(String id, Set<String> fields) {
        try {
            HashMap appData = null;
            JSONObject personData = this.db.getJSONObject(DATA_TABLE).optJSONObject(id);
            if (personData != null) {
                if (fields.contains(Person.Field.APP_DATA.toString())) {
                    appData = Maps.newHashMap();
                    Iterator keys = personData.keys();
                    while (keys.hasNext()) {
                        String key = (String)keys.next();
                        appData.put(key, personData.get(key));
                    }
                } else {
                    String appDataPrefix = Person.Field.APP_DATA.toString() + '.';
                    for (String field : fields) {
                        String appDataField;
                        if (!field.startsWith(appDataPrefix)) continue;
                        if (appData == null) {
                            appData = Maps.newHashMap();
                        }
                        if (!personData.has(appDataField = field.substring(appDataPrefix.length()))) continue;
                        appData.put(appDataField, personData.get(appDataField));
                    }
                }
            }
            return appData;
        }
        catch (JSONException je) {
            throw new ProtocolException(500, je.getMessage(), (Throwable)je);
        }
    }

    @Override
    public Future<DataCollection> getPersonData(Set<UserId> userIds, GroupId groupId, String appId, Set<String> fields, SecurityToken token) throws ProtocolException {
        try {
            HashMap idToData = Maps.newHashMap();
            Set<String> idSet = this.getIdSet(userIds, groupId, token);
            for (String id : idSet) {
                JSONObject personData = !this.db.getJSONObject(DATA_TABLE).has(id) ? new JSONObject() : (!fields.isEmpty() ? new JSONObject(this.db.getJSONObject(DATA_TABLE).getJSONObject(id), fields.toArray(new String[fields.size()])) : this.db.getJSONObject(DATA_TABLE).getJSONObject(id));
                Iterator keys = personData.keys();
                HashMap data = Maps.newHashMap();
                while (keys.hasNext()) {
                    String key = (String)keys.next();
                    data.put(key, personData.getString(key));
                }
                idToData.put(id, data);
            }
            return Futures.immediateFuture((Object)new DataCollection((Map)idToData));
        }
        catch (JSONException je) {
            throw new ProtocolException(500, je.getMessage(), (Throwable)je);
        }
    }

    @Override
    public Future<Void> deletePersonData(UserId userId, GroupId groupId, String appId, Set<String> fields, SecurityToken token) throws ProtocolException {
        try {
            String user = userId.getUserId(token);
            if (!this.db.getJSONObject(DATA_TABLE).has(user)) {
                return null;
            }
            JSONObject newPersonData = new JSONObject();
            JSONObject oldPersonData = this.db.getJSONObject(DATA_TABLE).getJSONObject(user);
            Iterator keys = oldPersonData.keys();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                if (fields.contains(key)) continue;
                newPersonData.put(key, (Object)oldPersonData.getString(key));
            }
            this.db.getJSONObject(DATA_TABLE).put(user, (Object)newPersonData);
            return Futures.immediateFuture(null);
        }
        catch (JSONException je) {
            throw new ProtocolException(500, je.getMessage(), (Throwable)je);
        }
    }

    @Override
    public Future<Void> updatePersonData(UserId userId, GroupId groupId, String appId, Set<String> fields, Map<String, Object> values, SecurityToken token) throws ProtocolException {
        try {
            JSONObject personData = this.db.getJSONObject(DATA_TABLE).getJSONObject(userId.getUserId(token));
            if (personData == null) {
                personData = new JSONObject();
                this.db.getJSONObject(DATA_TABLE).put(userId.getUserId(token), (Object)personData);
            }
            for (Map.Entry<String, Object> entry : values.entrySet()) {
                personData.put(entry.getKey(), entry.getValue());
            }
            return Futures.immediateFuture(null);
        }
        catch (JSONException je) {
            throw new ProtocolException(500, je.getMessage(), (Throwable)je);
        }
    }

    @Override
    public Future<RestfulCollection<Group>> getGroups(UserId userId, CollectionOptions options, Set<String> fields, SecurityToken token) throws ProtocolException {
        ArrayList result = Lists.newArrayList();
        String user = userId.getUserId(token);
        try {
            JSONArray groups = this.db.getJSONObject(GROUPS_TABLE).getJSONArray(user);
            for (int i = 0; i < groups.length(); ++i) {
                JSONObject group = groups.getJSONObject(i);
                Group groupObj = this.filterFields(group, fields, Group.class);
                result.add(groupObj);
            }
        }
        catch (JSONException je) {
            throw new ProtocolException(500, je.getMessage(), (Throwable)je);
        }
        return Futures.immediateFuture((Object)new RestfulCollection((List)result));
    }

    @Override
    public Future<Void> createMessage(UserId userId, String appId, String msgCollId, Message message, SecurityToken token) throws ProtocolException {
        for (String recipient : message.getRecipients()) {
            try {
                JSONArray outbox = this.db.getJSONObject(MESSAGE_TABLE).getJSONArray(recipient);
                if (outbox == null) {
                    outbox = new JSONArray();
                    this.db.getJSONObject(MESSAGE_TABLE).put(recipient, (Object)outbox);
                }
                outbox.put((Object)message);
            }
            catch (JSONException je) {
                throw new ProtocolException(500, je.getMessage(), (Throwable)je);
            }
        }
        return Futures.immediateFuture(null);
    }

    @Override
    public Future<RestfulCollection<MessageCollection>> getMessageCollections(UserId userId, Set<String> fields, CollectionOptions options, SecurityToken token) throws ProtocolException {
        try {
            ArrayList result = Lists.newArrayList();
            JSONObject messageCollections = this.db.getJSONObject(MESSAGE_TABLE).getJSONObject(userId.getUserId(token));
            for (String msgCollId : JSONObject.getNames((JSONObject)messageCollections)) {
                JSONObject msgColl = messageCollections.getJSONObject(msgCollId);
                msgColl.put("id", (Object)msgCollId);
                JSONArray messages = msgColl.getJSONArray(MESSAGE_TABLE);
                int numMessages = messages == null ? 0 : messages.length();
                msgColl.put("total", (Object)String.valueOf(numMessages));
                msgColl.put("unread", (Object)String.valueOf(numMessages));
                result.add(this.filterFields(msgColl, fields, MessageCollection.class));
            }
            return Futures.immediateFuture((Object)new RestfulCollection((List)result));
        }
        catch (JSONException je) {
            throw new ProtocolException(500, je.getMessage(), (Throwable)je);
        }
    }

    @Override
    public Future<Void> deleteMessages(UserId userId, String msgCollId, List<String> ids, SecurityToken token) throws ProtocolException {
        throw new ProtocolException(501, "this functionality is not yet available");
    }

    @Override
    public Future<RestfulCollection<Message>> getMessages(UserId userId, String msgCollId, Set<String> fields, List<String> msgIds, CollectionOptions options, SecurityToken token) throws ProtocolException {
        try {
            ArrayList result = Lists.newArrayList();
            JSONArray messages = this.db.getJSONObject(MESSAGE_TABLE).getJSONObject(userId.getUserId(token)).getJSONObject(msgCollId).getJSONArray(MESSAGE_TABLE);
            if (messages == null) {
                throw new ProtocolException(400, "message collection" + msgCollId + " not found");
            }
            for (int i = 0; i < messages.length(); ++i) {
                JSONObject msg = messages.getJSONObject(i);
                result.add(this.filterFields(msg, fields, Message.class));
            }
            return Futures.immediateFuture((Object)new RestfulCollection((List)result));
        }
        catch (JSONException je) {
            throw new ProtocolException(500, je.getMessage(), (Throwable)je);
        }
    }

    @Override
    public Future<MessageCollection> createMessageCollection(UserId userId, MessageCollection msgCollection, SecurityToken token) throws ProtocolException {
        throw new ProtocolException(501, "this functionality is not yet available");
    }

    @Override
    public Future<Void> modifyMessage(UserId userId, String msgCollId, String messageId, Message message, SecurityToken token) throws ProtocolException {
        throw new ProtocolException(501, "this functionality is not yet available");
    }

    @Override
    public Future<Void> modifyMessageCollection(UserId userId, MessageCollection msgCollection, SecurityToken token) throws ProtocolException {
        throw new ProtocolException(501, "this functionality is not yet available");
    }

    @Override
    public Future<Void> deleteMessageCollection(UserId userId, String msgCollId, SecurityToken token) throws ProtocolException {
        throw new ProtocolException(501, "this functionality is not yet available");
    }

    public String getPassword(String username) {
        try {
            return this.db.getJSONObject(PASSWORDS_TABLE).getString(username);
        }
        catch (JSONException e) {
            return null;
        }
    }

    private Set<String> getIdSet(UserId user, GroupId group, SecurityToken token) throws JSONException {
        String userId = user.getUserId(token);
        if (group == null) {
            return ImmutableSortedSet.of((Comparable)((Object)userId));
        }
        LinkedHashSet returnVal = Sets.newLinkedHashSet();
        switch (group.getType()) {
            case all: 
            case friends: {
                if (!this.db.getJSONObject(FRIEND_LINK_TABLE).has(userId)) break;
                JSONArray friends = this.db.getJSONObject(FRIEND_LINK_TABLE).getJSONArray(userId);
                for (int i = 0; i < friends.length(); ++i) {
                    returnVal.add(friends.getString(i));
                }
                break;
            }
            case objectId: {
                if (!this.db.getJSONObject(GROUP_MEMBERS_TABLE).has(group.toString())) break;
                JSONArray groupMembers = this.db.getJSONObject(GROUP_MEMBERS_TABLE).getJSONArray(group.toString());
                for (int i = 0; i < groupMembers.length(); ++i) {
                    returnVal.add(groupMembers.getString(i));
                }
                break;
            }
            case self: {
                returnVal.add(userId);
            }
        }
        return returnVal;
    }

    public Set<String> getIdSet(Set<UserId> users, GroupId group, SecurityToken token) throws JSONException {
        LinkedHashSet ids = Sets.newLinkedHashSet();
        for (UserId user : users) {
            ids.addAll(this.getIdSet(user, group, token));
        }
        return ids;
    }

    @Override
    public Future<Album> getAlbum(UserId userId, String appId, Set<String> fields, String albumId, SecurityToken token) throws ProtocolException {
        try {
            String user = userId.getUserId(token);
            if (this.db.getJSONObject(ALBUMS_TABLE).has(user)) {
                JSONArray userAlbums = this.db.getJSONObject(ALBUMS_TABLE).getJSONArray(user);
                for (int i = 0; i < userAlbums.length(); ++i) {
                    JSONObject album = userAlbums.getJSONObject(i);
                    if (!album.getString(Album.Field.ID.toString()).equals(albumId) || !album.getString(Album.Field.OWNER_ID.toString()).equals(user)) continue;
                    return Futures.immediateFuture((Object)this.filterFields(album, fields, Album.class));
                }
            }
            throw new ProtocolException(400, "Album ID " + albumId + " does not exist");
        }
        catch (JSONException je) {
            throw new ProtocolException(500, je.getMessage(), (Throwable)je);
        }
    }

    @Override
    public Future<RestfulCollection<Album>> getAlbums(UserId userId, String appId, Set<String> fields, CollectionOptions options, Set<String> albumIds, SecurityToken token) throws ProtocolException {
        try {
            String user = userId.getUserId(token);
            if (this.db.getJSONObject(ALBUMS_TABLE).has(user)) {
                JSONArray userAlbums = this.db.getJSONObject(ALBUMS_TABLE).getJSONArray(user);
                ArrayList result = Lists.newArrayList();
                for (String albumId : albumIds) {
                    boolean found = false;
                    for (int i = 0; i < userAlbums.length(); ++i) {
                        JSONObject curAlbum = userAlbums.getJSONObject(i);
                        if (!curAlbum.getString(Album.Field.ID.toString()).equals(albumId) || !curAlbum.getString(Album.Field.OWNER_ID.toString()).equals(user)) continue;
                        result.add(this.filterFields(curAlbum, fields, Album.class));
                        found = true;
                        break;
                    }
                    if (found) continue;
                    throw new ProtocolException(400, "Album ID " + albumId + " does not exist");
                }
                return Futures.immediateFuture((Object)new RestfulCollection((List)result));
            }
            throw new ProtocolException(400, "User '" + user + "' has no albums");
        }
        catch (JSONException je) {
            throw new ProtocolException(500, je.getMessage(), (Throwable)je);
        }
    }

    @Override
    public Future<RestfulCollection<Album>> getAlbums(Set<UserId> userIds, GroupId groupId, String appId, Set<String> fields, CollectionOptions options, SecurityToken token) throws ProtocolException {
        try {
            ArrayList result = Lists.newArrayList();
            Set<String> idSet = this.getIdSet(userIds, groupId, token);
            for (String id : idSet) {
                if (!this.db.getJSONObject(ALBUMS_TABLE).has(id)) continue;
                JSONArray userAlbums = this.db.getJSONObject(ALBUMS_TABLE).getJSONArray(id);
                for (int i = 0; i < userAlbums.length(); ++i) {
                    JSONObject album = userAlbums.getJSONObject(i);
                    if (!album.getString(Album.Field.OWNER_ID.toString()).equals(id)) continue;
                    result.add(this.filterFields(album, fields, Album.class));
                }
            }
            return Futures.immediateFuture((Object)new RestfulCollection((List)result));
        }
        catch (JSONException je) {
            throw new ProtocolException(500, je.getMessage(), (Throwable)je);
        }
    }

    @Override
    public Future<Void> deleteAlbum(UserId userId, String appId, String albumId, SecurityToken token) throws ProtocolException {
        try {
            boolean targetFound = false;
            JSONArray newAlbums = new JSONArray();
            String user = userId.getUserId(token);
            if (this.db.getJSONObject(ALBUMS_TABLE).has(user)) {
                JSONArray userAlbums = this.db.getJSONObject(ALBUMS_TABLE).getJSONArray(user);
                for (int i = 0; i < userAlbums.length(); ++i) {
                    JSONObject curAlbum = userAlbums.getJSONObject(i);
                    if (curAlbum.getString(Album.Field.ID.toString()).equals(albumId)) {
                        targetFound = true;
                        continue;
                    }
                    newAlbums.put((Object)curAlbum);
                }
            }
            if (targetFound) {
                this.db.getJSONObject(ALBUMS_TABLE).put(user, (Object)newAlbums);
                return Futures.immediateFuture(null);
            }
            throw new ProtocolException(400, "Album ID " + albumId + " does not exist");
        }
        catch (JSONException je) {
            throw new ProtocolException(500, je.getMessage(), (Throwable)je);
        }
    }

    @Override
    public Future<Void> createAlbum(UserId userId, String appId, Album album, SecurityToken token) throws ProtocolException {
        try {
            JSONObject jsonAlbum;
            String user = userId.getUserId(token);
            JSONArray userAlbums = this.db.getJSONObject(ALBUMS_TABLE).getJSONArray(user);
            if (userAlbums == null) {
                userAlbums = new JSONArray();
                this.db.getJSONObject(ALBUMS_TABLE).put(user, (Object)userAlbums);
            }
            if (!(jsonAlbum = this.convertToJson(album)).has(Album.Field.ID.toString())) {
                jsonAlbum.put(Album.Field.ID.toString(), System.currentTimeMillis());
            }
            if (!jsonAlbum.has(Album.Field.OWNER_ID.toString())) {
                jsonAlbum.put(Album.Field.OWNER_ID.toString(), (Object)user);
            }
            userAlbums.put((Object)jsonAlbum);
            return Futures.immediateFuture(null);
        }
        catch (JSONException je) {
            throw new ProtocolException(500, je.getMessage(), (Throwable)je);
        }
    }

    @Override
    public Future<Void> updateAlbum(UserId userId, String appId, Album album, String albumId, SecurityToken token) throws ProtocolException {
        try {
            String user = userId.getUserId(token);
            if (this.db.getJSONObject(ALBUMS_TABLE).has(user)) {
                JSONArray userAlbums = this.db.getJSONObject(ALBUMS_TABLE).getJSONArray(user);
                JSONObject jsonAlbum = this.convertToJson(album);
                jsonAlbum.put(Album.Field.ID.toString(), (Object)albumId);
                for (int i = 0; i < userAlbums.length(); ++i) {
                    JSONObject curAlbum = userAlbums.getJSONObject(i);
                    if (!curAlbum.getString(Album.Field.ID.toString()).equals(albumId)) continue;
                    userAlbums.put(i, (Object)jsonAlbum);
                    return Futures.immediateFuture(null);
                }
            }
            throw new ProtocolException(400, "Album ID " + albumId + " does not exist");
        }
        catch (JSONException je) {
            throw new ProtocolException(500, je.getMessage(), (Throwable)je);
        }
    }

    @Override
    public Future<MediaItem> getMediaItem(UserId userId, String appId, String albumId, String mediaItemId, Set<String> fields, SecurityToken token) throws ProtocolException {
        try {
            String user = userId.getUserId(token);
            if (this.db.getJSONObject(MEDIAITEMS_TABLE).has(user)) {
                JSONArray userMediaItems = this.db.getJSONObject(MEDIAITEMS_TABLE).getJSONArray(user);
                for (int i = 0; i < userMediaItems.length(); ++i) {
                    JSONObject mediaItem = userMediaItems.getJSONObject(i);
                    if (!mediaItem.getString(MediaItem.Field.ID.toString()).equals(mediaItemId) || !mediaItem.getString(MediaItem.Field.ALBUM_ID.toString()).equals(albumId)) continue;
                    return Futures.immediateFuture((Object)this.filterFields(mediaItem, fields, MediaItem.class));
                }
            }
            throw new ProtocolException(400, "MediaItem ID '" + mediaItemId + "' does not exist within Album '" + albumId + '\'');
        }
        catch (JSONException je) {
            throw new ProtocolException(500, je.getMessage(), (Throwable)je);
        }
    }

    @Override
    public Future<RestfulCollection<MediaItem>> getMediaItems(UserId userId, String appId, String albumId, Set<String> mediaItemIds, Set<String> fields, CollectionOptions options, SecurityToken token) throws ProtocolException {
        try {
            String user = userId.getUserId(token);
            if (this.db.getJSONObject(MEDIAITEMS_TABLE).has(user)) {
                JSONArray userMediaItems = this.db.getJSONObject(MEDIAITEMS_TABLE).getJSONArray(user);
                ArrayList result = Lists.newArrayList();
                for (String mediaItemId : mediaItemIds) {
                    boolean found = false;
                    for (int i = 0; i < userMediaItems.length(); ++i) {
                        JSONObject curMediaItem = userMediaItems.getJSONObject(i);
                        if (!curMediaItem.getString(MediaItem.Field.ID.toString()).equals(albumId) || !curMediaItem.getString(MediaItem.Field.ALBUM_ID.toString()).equals(albumId)) continue;
                        result.add(this.filterFields(curMediaItem, fields, MediaItem.class));
                        found = true;
                        break;
                    }
                    if (found) continue;
                    throw new ProtocolException(400, "MediaItem ID " + mediaItemId + " does not exist within Album " + albumId);
                }
                return Futures.immediateFuture((Object)new RestfulCollection((List)result));
            }
            throw new ProtocolException(400, "MediaItem table not found for user " + user);
        }
        catch (JSONException je) {
            throw new ProtocolException(500, je.getMessage(), (Throwable)je);
        }
    }

    @Override
    public Future<RestfulCollection<MediaItem>> getMediaItems(UserId userId, String appId, String albumId, Set<String> fields, CollectionOptions options, SecurityToken token) throws ProtocolException {
        try {
            String user = userId.getUserId(token);
            if (this.db.getJSONObject(MEDIAITEMS_TABLE).has(user)) {
                JSONArray userMediaItems = this.db.getJSONObject(MEDIAITEMS_TABLE).getJSONArray(user);
                ArrayList result = Lists.newArrayList();
                for (int i = 0; i < userMediaItems.length(); ++i) {
                    JSONObject curMediaItem = userMediaItems.getJSONObject(i);
                    if (!curMediaItem.getString(MediaItem.Field.ALBUM_ID.toString()).equals(albumId)) continue;
                    result.add(this.filterFields(curMediaItem, fields, MediaItem.class));
                }
                return Futures.immediateFuture((Object)new RestfulCollection((List)result));
            }
            throw new ProtocolException(400, "Album ID " + albumId + " does not exist");
        }
        catch (JSONException je) {
            throw new ProtocolException(500, je.getMessage(), (Throwable)je);
        }
    }

    @Override
    public Future<RestfulCollection<MediaItem>> getMediaItems(Set<UserId> userIds, GroupId groupId, String appId, Set<String> fields, CollectionOptions options, SecurityToken token) throws ProtocolException {
        try {
            ArrayList result = Lists.newArrayList();
            Set<String> idSet = this.getIdSet(userIds, groupId, token);
            for (String id : idSet) {
                if (!this.db.getJSONObject(MEDIAITEMS_TABLE).has(id)) continue;
                JSONArray userMediaItems = this.db.getJSONObject(MEDIAITEMS_TABLE).getJSONArray(id);
                for (int i = 0; i < userMediaItems.length(); ++i) {
                    result.add(this.filterFields(userMediaItems.getJSONObject(i), fields, MediaItem.class));
                }
            }
            return Futures.immediateFuture((Object)new RestfulCollection((List)result));
        }
        catch (JSONException je) {
            throw new ProtocolException(500, je.getMessage(), (Throwable)je);
        }
    }

    @Override
    public Future<Void> deleteMediaItem(UserId userId, String appId, String albumId, String mediaItemId, SecurityToken token) throws ProtocolException {
        try {
            boolean targetFound = false;
            JSONArray newMediaItems = new JSONArray();
            String user = userId.getUserId(token);
            if (this.db.getJSONObject(MEDIAITEMS_TABLE).has(user)) {
                JSONArray userMediaItems = this.db.getJSONObject(MEDIAITEMS_TABLE).getJSONArray(user);
                for (int i = 0; i < userMediaItems.length(); ++i) {
                    JSONObject curMediaItem = userMediaItems.getJSONObject(i);
                    if (curMediaItem.getString(MediaItem.Field.ID.toString()).equals(mediaItemId) && curMediaItem.getString(MediaItem.Field.ALBUM_ID.toString()).equals(albumId)) {
                        targetFound = true;
                        continue;
                    }
                    newMediaItems.put((Object)curMediaItem);
                }
            }
            if (targetFound) {
                this.db.getJSONObject(MEDIAITEMS_TABLE).put(user, (Object)newMediaItems);
                return Futures.immediateFuture(null);
            }
            throw new ProtocolException(400, "MediaItem ID " + mediaItemId + " does not exist existin within Album " + albumId);
        }
        catch (JSONException je) {
            throw new ProtocolException(500, je.getMessage(), (Throwable)je);
        }
    }

    @Override
    public Future<Void> createMediaItem(UserId userId, String appId, String albumId, MediaItem mediaItem, SecurityToken token) throws ProtocolException {
        try {
            JSONArray userMediaItems = this.db.getJSONObject(MEDIAITEMS_TABLE).getJSONArray(userId.getUserId(token));
            if (userMediaItems == null) {
                userMediaItems = new JSONArray();
                this.db.getJSONObject(MEDIAITEMS_TABLE).put(userId.getUserId(token), (Object)userMediaItems);
            }
            JSONObject jsonMediaItem = this.convertToJson(mediaItem);
            jsonMediaItem.put(MediaItem.Field.ALBUM_ID.toString(), (Object)albumId);
            if (!jsonMediaItem.has(MediaItem.Field.ID.toString())) {
                jsonMediaItem.put(MediaItem.Field.ID.toString(), System.currentTimeMillis());
            }
            userMediaItems.put((Object)jsonMediaItem);
            return Futures.immediateFuture(null);
        }
        catch (JSONException je) {
            throw new ProtocolException(500, je.getMessage(), (Throwable)je);
        }
    }

    @Override
    public Future<Void> updateMediaItem(UserId userId, String appId, String albumId, String mediaItemId, MediaItem mediaItem, SecurityToken token) throws ProtocolException {
        try {
            String user = userId.getUserId(token);
            if (this.db.getJSONObject(MEDIAITEMS_TABLE).has(user)) {
                JSONArray userMediaItems = this.db.getJSONObject(MEDIAITEMS_TABLE).getJSONArray(user);
                JSONObject jsonMediaItem = this.convertToJson(mediaItem);
                jsonMediaItem.put(MediaItem.Field.ID.toString(), (Object)mediaItemId);
                jsonMediaItem.put(MediaItem.Field.ALBUM_ID.toString(), (Object)albumId);
                for (int i = 0; i < userMediaItems.length(); ++i) {
                    JSONObject curMediaItem = userMediaItems.getJSONObject(i);
                    if (!curMediaItem.getString(MediaItem.Field.ID.toString()).equals(mediaItemId) || !curMediaItem.getString(MediaItem.Field.ALBUM_ID.toString()).equals(albumId)) continue;
                    userMediaItems.put(i, (Object)jsonMediaItem);
                    return Futures.immediateFuture(null);
                }
            }
            throw new ProtocolException(400, "MediaItem ID " + mediaItemId + " does not exist existin within Album " + albumId);
        }
        catch (JSONException je) {
            throw new ProtocolException(500, je.getMessage(), (Throwable)je);
        }
    }

    @Override
    public Future<ActivityEntry> updateActivityEntry(UserId userId, GroupId groupId, String appId, Set<String> fields, ActivityEntry activityEntry, String activityId, SecurityToken token) throws ProtocolException {
        try {
            JSONArray jsonArray;
            JSONObject jsonEntry = this.convertFromActivityEntry(activityEntry, fields);
            if (!jsonEntry.has(ActivityEntry.Field.ID.toString())) {
                if (activityId != null) {
                    jsonEntry.put(ActivityEntry.Field.ID.toString(), (Object)activityId);
                } else {
                    jsonEntry.put(ActivityEntry.Field.ID.toString(), System.currentTimeMillis());
                }
            }
            activityId = jsonEntry.getString(ActivityEntry.Field.ID.toString());
            if (this.db.getJSONObject(ACTIVITYSTREAMS_TABLE).has(userId.getUserId(token))) {
                jsonArray = this.db.getJSONObject(ACTIVITYSTREAMS_TABLE).getJSONArray(userId.getUserId(token));
            } else {
                jsonArray = new JSONArray();
                this.db.getJSONObject(ACTIVITYSTREAMS_TABLE).put(userId.getUserId(token), (Object)jsonArray);
            }
            for (int i = 0; i < jsonArray.length(); ++i) {
                JSONObject entry = jsonArray.getJSONObject(i);
                if (!entry.getString(ActivityEntry.Field.ID.toString()).equals(activityId)) continue;
                jsonArray.put(i, (Object)jsonEntry);
                return Futures.immediateFuture((Object)this.filterFields(jsonEntry, fields, ActivityEntry.class));
            }
            throw new ProtocolException(400, "Activity not found: " + activityId);
        }
        catch (JSONException je) {
            throw new ProtocolException(500, je.getMessage(), (Throwable)je);
        }
    }

    @Override
    public Future<ActivityEntry> createActivityEntry(UserId userId, GroupId groupId, String appId, Set<String> fields, ActivityEntry activityEntry, SecurityToken token) throws ProtocolException {
        try {
            JSONArray jsonArray;
            JSONObject jsonEntry = this.convertFromActivityEntry(activityEntry, fields);
            if (!jsonEntry.has(ActivityEntry.Field.ID.toString())) {
                jsonEntry.put(ActivityEntry.Field.ID.toString(), System.currentTimeMillis());
            }
            String activityId = jsonEntry.getString(ActivityEntry.Field.ID.toString());
            if (this.db.getJSONObject(ACTIVITYSTREAMS_TABLE).has(userId.getUserId(token))) {
                jsonArray = this.db.getJSONObject(ACTIVITYSTREAMS_TABLE).getJSONArray(userId.getUserId(token));
            } else {
                jsonArray = new JSONArray();
                this.db.getJSONObject(ACTIVITYSTREAMS_TABLE).put(userId.getUserId(token), (Object)jsonArray);
            }
            for (int i = 0; i < jsonArray.length(); ++i) {
                JSONObject entry = jsonArray.getJSONObject(i);
                if (!entry.getString(ActivityEntry.Field.ID.toString()).equals(activityId)) continue;
                throw new ProtocolException(400, "Activity already exists: " + activityId);
            }
            jsonArray.put((Object)jsonEntry);
            return Futures.immediateFuture((Object)this.filterFields(jsonEntry, fields, ActivityEntry.class));
        }
        catch (JSONException je) {
            throw new ProtocolException(500, je.getMessage(), (Throwable)je);
        }
    }

    @Override
    public Future<Void> deleteActivityEntries(UserId userId, GroupId groupId, String appId, Set<String> activityIds, SecurityToken token) throws ProtocolException {
        try {
            JSONArray activityEntries;
            String user = userId.getUserId(token);
            if (this.db.getJSONObject(ACTIVITYSTREAMS_TABLE).has(user) && (activityEntries = this.db.getJSONObject(ACTIVITYSTREAMS_TABLE).getJSONArray(user)) != null) {
                JSONArray newList = new JSONArray();
                for (int i = 0; i < activityEntries.length(); ++i) {
                    JSONObject activityEntry = activityEntries.getJSONObject(i);
                    if (activityIds.contains(activityEntry.getString(ActivityEntry.Field.ID.toString()))) continue;
                    newList.put((Object)activityEntry);
                }
                this.db.getJSONObject(ACTIVITYSTREAMS_TABLE).put(user, (Object)newList);
            }
            return Futures.immediateFuture(null);
        }
        catch (JSONException je) {
            throw new ProtocolException(500, je.getMessage(), (Throwable)je);
        }
    }

    @Override
    public Future<ActivityEntry> getActivityEntry(UserId userId, GroupId groupId, String appId, Set<String> fields, String activityId, SecurityToken token) throws ProtocolException {
        try {
            String user = userId.getUserId(token);
            if (this.db.getJSONObject(ACTIVITYSTREAMS_TABLE).has(user)) {
                JSONArray activityEntries = this.db.getJSONObject(ACTIVITYSTREAMS_TABLE).getJSONArray(user);
                for (int i = 0; i < activityEntries.length(); ++i) {
                    JSONObject activityEntry = activityEntries.getJSONObject(i);
                    if (!activityEntry.getString(ActivityEntry.Field.ID.toString()).equals(activityId)) continue;
                    return Futures.immediateFuture((Object)this.filterFields(activityEntry, fields, ActivityEntry.class));
                }
            }
            throw new ProtocolException(400, "Activity not found: " + activityId);
        }
        catch (JSONException je) {
            throw new ProtocolException(500, je.getMessage(), (Throwable)je);
        }
    }

    @Override
    public Future<RestfulCollection<ActivityEntry>> getActivityEntries(Set<UserId> userIds, GroupId groupId, String appId, Set<String> fields, CollectionOptions options, SecurityToken token) throws ProtocolException {
        ArrayList result = Lists.newArrayList();
        try {
            Set<String> idSet = this.getIdSet(userIds, groupId, token);
            for (String id : idSet) {
                if (!this.db.getJSONObject(ACTIVITYSTREAMS_TABLE).has(id)) continue;
                JSONArray activityEntries = this.db.getJSONObject(ACTIVITYSTREAMS_TABLE).getJSONArray(id);
                for (int i = 0; i < activityEntries.length(); ++i) {
                    JSONObject activityEntry = activityEntries.getJSONObject(i);
                    result.add(this.filterFields(activityEntry, fields, ActivityEntry.class));
                }
            }
            Collections.sort(result, Collections.reverseOrder());
            return Futures.immediateFuture((Object)new RestfulCollection((List)result));
        }
        catch (JSONException je) {
            throw new ProtocolException(500, je.getMessage(), (Throwable)je);
        }
    }

    @Override
    public Future<RestfulCollection<ActivityEntry>> getActivityEntries(UserId userId, GroupId groupId, String appId, Set<String> fields, CollectionOptions options, Set<String> activityIds, SecurityToken token) throws ProtocolException {
        ArrayList result = Lists.newArrayList();
        try {
            String user = userId.getUserId(token);
            if (this.db.getJSONObject(ACTIVITYSTREAMS_TABLE).has(user)) {
                JSONArray activityEntries = this.db.getJSONObject(ACTIVITYSTREAMS_TABLE).getJSONArray(user);
                for (String activityId : activityIds) {
                    boolean found = false;
                    for (int i = 0; i < activityEntries.length(); ++i) {
                        JSONObject activityEntry = activityEntries.getJSONObject(i);
                        if (!activityEntry.getString(ActivityEntry.Field.ID.toString()).equals(activityId)) continue;
                        result.add(this.filterFields(activityEntry, fields, ActivityEntry.class));
                        found = true;
                        break;
                    }
                    if (found) continue;
                    throw new ProtocolException(404, "Activity not found: " + activityId);
                }
            }
            Collections.sort(result, Collections.reverseOrder());
            return Futures.immediateFuture((Object)new RestfulCollection((List)result));
        }
        catch (JSONException je) {
            throw new ProtocolException(500, je.getMessage(), (Throwable)je);
        }
    }

    private JSONObject convertFromActivity(Activity activity, Set<String> fields) throws JSONException {
        return new JSONObject(this.converter.convertToString((Object)activity));
    }

    private JSONObject convertFromActivityEntry(ActivityEntry activityEntry, Set<String> fields) throws JSONException {
        return new JSONObject(this.converter.convertToString((Object)activityEntry));
    }

    private JSONObject convertToJson(Object object) throws JSONException {
        return new JSONObject(this.converter.convertToString(object));
    }

    public <T> T filterFields(JSONObject object, Set<String> fields, Class<T> clz) throws JSONException {
        if (!fields.isEmpty()) {
            object = new JSONObject(object, fields.toArray(new String[fields.size()]));
        }
        String objectVal = object.toString();
        objectVal = this.authority != null ? objectVal.replace("%origin%", this.authority.getOrigin()) : objectVal.replace("%origin%", "http://localhost:8080");
        return (T)this.converter.convertToObject(objectVal, clz);
    }
}

