/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.social.sample.oauth;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URISyntaxException;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.oauth.OAuth;
import net.oauth.OAuthAccessor;
import net.oauth.OAuthConsumer;
import net.oauth.OAuthException;
import net.oauth.OAuthMessage;
import net.oauth.OAuthProblemException;
import net.oauth.OAuthValidator;
import net.oauth.server.OAuthServlet;
import org.apache.shindig.common.servlet.HttpUtil;
import org.apache.shindig.common.servlet.InjectedServlet;
import org.apache.shindig.social.opensocial.oauth.OAuthDataStore;
import org.apache.shindig.social.opensocial.oauth.OAuthEntry;

public class SampleOAuthServlet
extends InjectedServlet {
    private OAuthValidator validator;
    private OAuthDataStore dataStore;
    private String oauthAuthorizeAction;

    @Inject
    public void setValidator(OAuthValidator validator) {
        this.validator = validator;
    }

    @Inject
    public void setDataStore(OAuthDataStore dataStore) {
        this.dataStore = dataStore;
    }

    @Inject
    void setAuthorizeAction(@Named(value="shindig.oauth.authorize-action") String authorizeAction) {
        this.oauthAuthorizeAction = authorizeAction;
    }

    protected void doPost(HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws ServletException, IOException {
        this.doGet(servletRequest, servletResponse);
    }

    protected void doGet(HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws ServletException, IOException {
        HttpUtil.setNoCache((HttpServletResponse)servletResponse);
        String path = servletRequest.getPathInfo();
        try {
            if (path.endsWith("requestToken")) {
                this.createRequestToken(servletRequest, servletResponse);
            } else if (path.endsWith("authorize")) {
                this.authorizeRequestToken(servletRequest, servletResponse);
            } else if (path.endsWith("accessToken")) {
                this.createAccessToken(servletRequest, servletResponse);
            } else {
                servletResponse.sendError(404, "unknown Url");
            }
        }
        catch (OAuthException e) {
            SampleOAuthServlet.handleException((Exception)((Object)e), servletRequest, servletResponse, true);
        }
        catch (URISyntaxException e) {
            SampleOAuthServlet.handleException(e, servletRequest, servletResponse, true);
        }
    }

    private void createRequestToken(HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws IOException, OAuthException, URISyntaxException {
        OAuthMessage requestMessage = OAuthServlet.getMessage((HttpServletRequest)servletRequest, null);
        String consumerKey = requestMessage.getConsumerKey();
        if (consumerKey == null) {
            OAuthProblemException e = new OAuthProblemException("parameter_absent");
            e.setParameter("oauth_parameters_absent", (Object)"oauth_consumer_key");
            throw e;
        }
        OAuthConsumer consumer = this.dataStore.getConsumer(consumerKey);
        if (consumer == null) {
            throw new OAuthProblemException("consumer_key_unknown");
        }
        OAuthAccessor accessor = new OAuthAccessor(consumer);
        this.validator.validateMessage(requestMessage, accessor);
        String callback = requestMessage.getParameter("oauth_callback");
        if (callback == null) {
            callback = consumer.callbackURL;
        }
        if (callback == null) {
            callback = "oob";
        }
        OAuthEntry entry = this.dataStore.generateRequestToken(consumerKey, requestMessage.getParameter("oauth_version"), callback);
        List responseParams = OAuth.newList((String[])new String[]{"oauth_token", entry.getToken(), "oauth_token_secret", entry.getTokenSecret()});
        if (callback != null) {
            responseParams.add(new OAuth.Parameter("oauth_callback_confirmed", "true"));
        }
        this.sendResponse(servletResponse, responseParams);
    }

    private void authorizeRequestToken(HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws ServletException, IOException, OAuthException, URISyntaxException {
        OAuthMessage requestMessage = OAuthServlet.getMessage((HttpServletRequest)servletRequest, null);
        if (requestMessage.getToken() == null) {
            servletResponse.sendError(400, "Authentication token not found");
            return;
        }
        OAuthEntry entry = this.dataStore.getEntry(requestMessage.getToken());
        if (entry == null) {
            servletResponse.sendError(404, "OAuth Entry not found");
            return;
        }
        OAuthConsumer consumer = this.dataStore.getConsumer(entry.getConsumerKey());
        if (consumer == null) {
            servletResponse.sendError(404, "consumer for entry not found");
            return;
        }
        if (entry.getType() == OAuthEntry.Type.DISABLED) {
            servletResponse.sendError(403, "This token is disabled, please reinitate login");
            return;
        }
        String callback = entry.getCallbackUrl();
        if (!entry.isAuthorized()) {
            if (!this.oauthAuthorizeAction.startsWith("http")) {
                servletRequest.setAttribute("OAUTH_DATASTORE", (Object)this.dataStore);
                servletRequest.setAttribute("OAUTH_ENTRY", (Object)entry);
                servletRequest.setAttribute("CALLBACK", (Object)callback);
                servletRequest.setAttribute("TOKEN", (Object)entry.getToken());
                servletRequest.setAttribute("CONSUMER", (Object)consumer);
                servletRequest.getRequestDispatcher(this.oauthAuthorizeAction).forward((ServletRequest)servletRequest, (ServletResponse)servletResponse);
            }
            return;
        }
        if (callback == null || "oob".equals(callback)) {
            servletResponse.setContentType("text/plain");
            PrintWriter out = servletResponse.getWriter();
            out.write("Token successfully authorized.\n");
            if (entry.getCallbackToken() != null) {
                out.write("Please enter code " + entry.getCallbackToken() + " at the consumer.");
            }
        } else {
            callback = OAuth.addParameters((String)callback, (String[])new String[]{"oauth_token", entry.getToken()});
            callback = OAuth.addParameters((String)callback, (String[])new String[]{"user_id", entry.getUserId()});
            if (entry.getCallbackToken() != null) {
                callback = OAuth.addParameters((String)callback, (String[])new String[]{"oauth_verifier", entry.getCallbackToken()});
            }
            servletResponse.setStatus(302);
            servletResponse.setHeader("Location", callback);
        }
    }

    private void createAccessToken(HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws ServletException, IOException, OAuthException, URISyntaxException {
        OAuthMessage requestMessage = OAuthServlet.getMessage((HttpServletRequest)servletRequest, null);
        OAuthEntry entry = this.getValidatedEntry(requestMessage);
        if (entry == null) {
            throw new OAuthProblemException("token_rejected");
        }
        if (entry.getCallbackToken() != null) {
            String clientCallbackToken = requestMessage.getParameter("oauth_verifier");
            if (!entry.getCallbackToken().equals(clientCallbackToken)) {
                this.dataStore.disableToken(entry);
                servletResponse.sendError(403, "This token is not authorized");
                return;
            }
        } else if (!entry.isAuthorized()) {
            this.dataStore.disableToken(entry);
            servletResponse.sendError(403, "This token is not authorized");
            return;
        }
        OAuthEntry accessEntry = this.dataStore.convertToAccessToken(entry);
        this.sendResponse(servletResponse, OAuth.newList((String[])new String[]{"oauth_token", accessEntry.getToken(), "oauth_token_secret", accessEntry.getTokenSecret(), "user_id", entry.getUserId()}));
    }

    private OAuthEntry getValidatedEntry(OAuthMessage requestMessage) throws IOException, ServletException, OAuthException, URISyntaxException {
        OAuthEntry entry = this.dataStore.getEntry(requestMessage.getToken());
        if (entry == null) {
            throw new OAuthProblemException("token_rejected");
        }
        if (entry.getType() != OAuthEntry.Type.REQUEST) {
            throw new OAuthProblemException("token_used");
        }
        if (entry.isExpired()) {
            throw new OAuthProblemException("token_expired");
        }
        if (requestMessage.getConsumerKey() == null) {
            OAuthProblemException e = new OAuthProblemException("parameter_absent");
            e.setParameter("oauth_parameters_absent", (Object)"oauth_consumer_key");
            throw e;
        }
        String consumerKey = entry.getConsumerKey();
        if (!consumerKey.equals(requestMessage.getConsumerKey())) {
            throw new OAuthProblemException("consumer_key_refused");
        }
        OAuthConsumer consumer = this.dataStore.getConsumer(consumerKey);
        if (consumer == null) {
            throw new OAuthProblemException("consumer_key_unknown");
        }
        OAuthAccessor accessor = new OAuthAccessor(consumer);
        accessor.requestToken = entry.getToken();
        accessor.tokenSecret = entry.getTokenSecret();
        this.validator.validateMessage(requestMessage, accessor);
        return entry;
    }

    private void sendResponse(HttpServletResponse servletResponse, List<OAuth.Parameter> parameters) throws IOException {
        servletResponse.setContentType("text/plain");
        ServletOutputStream out = servletResponse.getOutputStream();
        OAuth.formEncode(parameters, (OutputStream)out);
        out.close();
    }

    private static void handleException(Exception e, HttpServletRequest request, HttpServletResponse response, boolean sendBody) throws IOException, ServletException {
        String realm = request.isSecure() ? "https://" : "http://";
        realm = request.getHeader("Host") != null ? realm + request.getHeader("Host") : realm + request.getLocalName();
        OAuthServlet.handleException((HttpServletResponse)response, (Exception)e, (String)realm, (boolean)sendBody);
    }
}

