/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.samples.spring.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.apache.shiro.authz.AuthorizationException;
import org.apache.shiro.samples.spring.SampleManager;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.ClassPathResource;

public class WebStartView
implements ActionListener,
InitializingBean {
    private SampleManager sampleManager;
    private JTextField valueField;
    private JButton saveButton;
    private JButton refreshButton;
    private JButton secureMethod1Button;
    private JButton secureMethod2Button;
    private JButton secureMethod3Button;
    private JFrame frame;

    public void setSampleManager(SampleManager sampleManager) {
        this.sampleManager = sampleManager;
    }

    public void afterPropertiesSet() throws Exception {
        ClassPathResource resource = new ClassPathResource("logo.png");
        ImageIcon icon = new ImageIcon(resource.getURL());
        JLabel logo = new JLabel(icon);
        this.valueField = new JTextField(20);
        this.updateValueLabel();
        this.saveButton = new JButton("Save Value");
        this.saveButton.addActionListener(this);
        this.refreshButton = new JButton("Refresh Value");
        this.refreshButton.addActionListener(this);
        JPanel valuePanel = new JPanel(new FlowLayout(1));
        valuePanel.add(this.valueField);
        valuePanel.add(this.saveButton);
        valuePanel.add(this.refreshButton);
        this.secureMethod1Button = new JButton("Method #1");
        this.secureMethod1Button.addActionListener(this);
        this.secureMethod2Button = new JButton("Method #2");
        this.secureMethod2Button.addActionListener(this);
        this.secureMethod3Button = new JButton("Method #3");
        this.secureMethod3Button.addActionListener(this);
        JPanel methodPanel = new JPanel(new FlowLayout(1));
        methodPanel.add(this.secureMethod1Button);
        methodPanel.add(this.secureMethod2Button);
        methodPanel.add(this.secureMethod3Button);
        this.frame = new JFrame("Apache Shiro Sample Application");
        this.frame.setSize(500, 200);
        Container panel = this.frame.getContentPane();
        panel.setLayout(new BorderLayout());
        panel.add((Component)logo, "North");
        panel.add((Component)valuePanel, "Center");
        panel.add((Component)methodPanel, "South");
        this.frame.setVisible(true);
        this.frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
    }

    private void updateValueLabel() {
        this.valueField.setText(this.sampleManager.getValue());
    }

    public void actionPerformed(ActionEvent e) {
        block7: {
            try {
                if (e.getSource() == this.saveButton) {
                    this.sampleManager.setValue(this.valueField.getText());
                    break block7;
                }
                if (e.getSource() == this.refreshButton) {
                    this.updateValueLabel();
                    break block7;
                }
                if (e.getSource() == this.secureMethod1Button) {
                    this.sampleManager.secureMethod1();
                    JOptionPane.showMessageDialog(this.frame, "Method #1 successfully called.", "Success", 1);
                    break block7;
                }
                if (e.getSource() == this.secureMethod2Button) {
                    this.sampleManager.secureMethod2();
                    JOptionPane.showMessageDialog(this.frame, "Method #2 successfully called.", "Success", 1);
                    break block7;
                }
                if (e.getSource() == this.secureMethod3Button) {
                    this.sampleManager.secureMethod3();
                    JOptionPane.showMessageDialog(this.frame, "Method #3 successfully called.", "Success", 1);
                    break block7;
                }
                throw new RuntimeException("Unexpected action event from source: " + e.getSource());
            }
            catch (AuthorizationException ae) {
                JOptionPane.showMessageDialog(this.frame, "Unauthorized to perform action: " + ae.getMessage(), "Unauthorized", 2);
            }
        }
    }
}

