/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.storage;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.logging.Logger;
import org.apache.sis.internal.jdk7.Files;
import org.apache.sis.internal.jdk7.StandardCharsets;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.Exceptions;
import org.apache.sis.util.Static;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.resources.Errors;

public final class IOUtilities
extends Static {
    private static final List<String> ILLEGAL_OPTIONS = Arrays.asList("APPEND", "TRUNCATE_EXISTING", "DELETE_ON_CLOSE");

    private IOUtilities() {
    }

    public static String filename(Object object) {
        return IOUtilities.part(object, false);
    }

    public static String extension(Object object) {
        return IOUtilities.part(object, true);
    }

    private static String part(Object object, boolean bl) {
        String string;
        int n = 0;
        if (object instanceof File) {
            string = ((File)object).getName();
        } else {
            int n2 = 47;
            if (object instanceof URL) {
                string = ((URL)object).getPath();
            } else if (object instanceof URI) {
                URI uRI = (URI)object;
                string = uRI.isOpaque() ? uRI.getSchemeSpecificPart() : uRI.getPath();
            } else if (object instanceof CharSequence) {
                string = object.toString();
                n2 = File.separatorChar;
            } else {
                return null;
            }
            n = string.lastIndexOf(47) + 1;
            if (n2 != 47) {
                n = Math.max(n, CharSequences.lastIndexOf((CharSequence)string, (int)n2, (int)n, (int)string.length()) + 1);
            }
        }
        if (bl && (n = CharSequences.lastIndexOf((CharSequence)string, (int)46, (int)n, (int)string.length()) + 1) <= 1) {
            return "";
        }
        return string.substring(n);
    }

    public static String toString(Object object) {
        if (object instanceof CharSequence || object instanceof URL || object instanceof URI) {
            return object.toString();
        }
        if (object instanceof File) {
            return ((File)object).getPath();
        }
        return null;
    }

    public static String encodeURI(String string) {
        int n;
        if (string == null) {
            return null;
        }
        StringBuilder stringBuilder = null;
        int n2 = string.length();
        for (int i = 0; i < n2; i += n) {
            int n3 = string.codePointAt(i);
            n = Character.charCount(n3);
            if (!Character.isSpaceChar(n3) && !Character.isISOControl(n3) && n3 != 37) {
                if (stringBuilder == null) continue;
                stringBuilder.appendCodePoint(n3);
                continue;
            }
            if (stringBuilder == null) {
                stringBuilder = new StringBuilder(string);
                stringBuilder.setLength(i);
            }
            for (byte by : string.substring(i, i + n).getBytes(StandardCharsets.UTF_8)) {
                stringBuilder.append('%');
                String string2 = Integer.toHexString(by & 0xFF).toUpperCase(Locale.ROOT);
                if (string2.length() < 2) {
                    stringBuilder.append('0');
                }
                stringBuilder.append(string2);
            }
        }
        return stringBuilder != null ? stringBuilder.toString() : string;
    }

    public static URI toURI(URL uRL, String string) throws IOException {
        if (uRL == null) {
            return null;
        }
        String string2 = uRL.toExternalForm();
        if (string != null) {
            string2 = URLDecoder.decode(string2, string);
        }
        string2 = IOUtilities.encodeURI(string2);
        try {
            return new URI(string2);
        }
        catch (URISyntaxException uRISyntaxException) {
            MalformedURLException malformedURLException = new MalformedURLException(Exceptions.formatChainedMessages(null, (String)Errors.format((short)31, (Object)"URL", (Object)string2), (Throwable)uRISyntaxException));
            malformedURLException.initCause(uRISyntaxException);
            throw malformedURLException;
        }
    }

    public static File toFile(URL uRL, String string) throws IOException {
        if (uRL == null) {
            return null;
        }
        URI uRI = IOUtilities.toURI(uRL, string);
        try {
            return new File(uRI);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IOException(Exceptions.formatChainedMessages(null, (String)Errors.format((short)31, (Object)"URL", (Object)uRL), (Throwable)illegalArgumentException), illegalArgumentException);
        }
    }

    public static Object toFileOrURL(String string, String string2) throws IOException {
        int n;
        if (string == null) {
            return null;
        }
        if (string.indexOf(63) < 0 && string.indexOf(35) < 0 && ((n = string.indexOf(58)) < 0 || n == 1 && Character.isLetter(string.charAt(0)) && !string.regionMatches(2, "//", 0, 2))) {
            return new File(string);
        }
        URL uRL = new URL(string);
        String string3 = uRL.getProtocol();
        if (string3 != null && string3.equalsIgnoreCase("file")) {
            return IOUtilities.toFile(uRL, string2);
        }
        return uRL;
    }

    public static ReadableByteChannel open(Object object, String string, Object ... objectArray) throws IOException {
        Set set;
        if (objectArray == null || objectArray.length == 0) {
            set = Collections.emptySet();
        } else {
            set = new HashSet<Object>(Arrays.asList(objectArray));
            set.add("READ");
            if (set.removeAll(ILLEGAL_OPTIONS)) {
                throw new IllegalArgumentException(Errors.format((short)31, (Object)"options", (Object)Arrays.toString(objectArray)));
            }
        }
        if (object instanceof ReadableByteChannel) {
            return (ReadableByteChannel)object;
        }
        if (object instanceof InputStream) {
            if (object instanceof FileInputStream) {
                return ((FileInputStream)object).getChannel();
            }
            return Channels.newChannel((InputStream)object);
        }
        if (object instanceof URL) {
            try {
                object = IOUtilities.toFile((URL)object, string);
            }
            catch (IOException iOException) {
                IOUtilities.recoverableException(iOException);
            }
        } else if (object instanceof URI) {
            URI uRI = (URI)object;
            if (!uRI.isAbsolute()) {
                throw new IOException(Errors.format((short)62));
            }
            try {
                object = new File(uRI);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                object = uRI.toURL();
                IOUtilities.recoverableException(illegalArgumentException);
            }
        } else if (object instanceof CharSequence) {
            object = IOUtilities.toFileOrURL(object.toString(), string);
        }
        if (object instanceof URL) {
            return Channels.newChannel(((URL)object).openStream());
        }
        if (object instanceof File) {
            return Files.newByteChannel((File)((File)object), set);
        }
        return null;
    }

    private static void recoverableException(Exception exception) {
        Logging.recoverableException((Logger)Logging.getLogger((String)"org.apache.sis.storage"), IOUtilities.class, (String)"open", (Throwable)exception);
    }
}

