/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.maven.bundlesupport;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpStatus;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.FileRequestEntity;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.multipart.FilePart;
import org.apache.commons.httpclient.methods.multipart.FilePartSource;
import org.apache.commons.httpclient.methods.multipart.MultipartRequestEntity;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.apache.commons.httpclient.methods.multipart.PartSource;
import org.apache.commons.httpclient.methods.multipart.StringPart;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.sling.commons.json.JSONArray;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.apache.sling.commons.osgi.ManifestHeader;
import org.apache.sling.maven.bundlesupport.AbstractBundlePostMojo;

abstract class AbstractBundleInstallMojo
extends AbstractBundlePostMojo {
    private static final String HEADER_INITIAL_CONTENT = "Sling-Initial-Content";
    private static final String FS_FACTORY = "org.apache.sling.fsprovider.internal.FsResourceProvider";
    private static final String JSON_MIME_TYPE = "application/json";
    private static final String HEADER_CONTENT_TYPE = "Content-Type";
    protected String slingUrl;
    protected String slingUrlSuffix;
    protected boolean usePut;
    protected String mimeType;
    private String user;
    private String password;
    private String bundleStartLevel;
    private boolean bundleStart;
    private boolean refreshPackages;
    private boolean mountByFS;
    protected MavenProject project;

    protected abstract String getBundleFileName() throws MojoExecutionException;

    protected String getTargetURL() {
        String targetURL = this.slingUrl;
        if (this.slingUrlSuffix != null) {
            targetURL = targetURL + this.slingUrlSuffix;
        }
        return targetURL;
    }

    protected String getPutURL(String targetURL, String fileName) {
        return targetURL + (targetURL.endsWith("/") ? "" : "/") + fileName;
    }

    public void execute() throws MojoExecutionException {
        String bundleFileName = this.getBundleFileName();
        File bundleFile = new File(bundleFileName);
        String bundleName = this.getBundleSymbolicName(bundleFile);
        if (bundleName == null) {
            this.getLog().info((CharSequence)(bundleFile + " is not an OSGi Bundle, not uploading"));
            return;
        }
        String targetURL = this.getTargetURL();
        this.getLog().info((CharSequence)("Installing Bundle " + bundleName + "(" + bundleFile + ") to " + targetURL + " via " + (this.usePut ? "PUT" : "POST")));
        if (this.usePut) {
            this.put(targetURL, bundleFile);
        } else {
            this.post(targetURL, bundleFile);
        }
        if (this.mountByFS) {
            this.configure(targetURL, bundleFile);
        }
    }

    protected void throwWebConsoleTooOldException() throws MojoExecutionException {
        throw new MojoExecutionException("The Apache Felix Web Console is too old to mount the initial content through file system provider configs. Either upgrade the web console or disable this feature.");
    }

    protected HttpClient getHttpClient() {
        HttpClient client = new HttpClient();
        client.getHttpConnectionManager().getParams().setConnectionTimeout(5000);
        client.getParams().setAuthenticationPreemptive(true);
        UsernamePasswordCredentials defaultcreds = new UsernamePasswordCredentials(this.user, this.password);
        client.getState().setCredentials(AuthScope.ANY, (Credentials)defaultcreds);
        return client;
    }

    protected void post(String targetURL, File file) throws MojoExecutionException {
        PostMethod filePost = new PostMethod(targetURL + "/install");
        try {
            ArrayList<Object> partList = new ArrayList<Object>();
            partList.add(new StringPart("action", "install"));
            partList.add(new StringPart("_noredir_", "_noredir_"));
            partList.add(new FilePart("bundlefile", (PartSource)new FilePartSource(file.getName(), file)));
            partList.add(new StringPart("bundlestartlevel", this.bundleStartLevel));
            if (this.bundleStart) {
                partList.add(new StringPart("bundlestart", "start"));
            }
            if (this.refreshPackages) {
                partList.add(new StringPart("refreshPackages", "true"));
            }
            Part[] parts = partList.toArray(new Part[partList.size()]);
            filePost.setRequestEntity((RequestEntity)new MultipartRequestEntity(parts, filePost.getParams()));
            int status = this.getHttpClient().executeMethod((HttpMethod)filePost);
            if (status == 200) {
                this.getLog().info((CharSequence)"Bundle installed");
            } else {
                String msg = "Installation failed, cause: " + HttpStatus.getStatusText((int)status);
                if (this.failOnError) {
                    throw new MojoExecutionException(msg);
                }
                this.getLog().error((CharSequence)msg);
            }
        }
        catch (Exception ex) {
            throw new MojoExecutionException("Installation on " + targetURL + " failed, cause: " + ex.getMessage(), ex);
        }
        finally {
            filePost.releaseConnection();
        }
    }

    protected void put(String targetURL, File file) throws MojoExecutionException {
        PutMethod filePut = new PutMethod(this.getPutURL(targetURL, file.getName()));
        try {
            filePut.setRequestEntity((RequestEntity)new FileRequestEntity(file, this.mimeType));
            int status = this.getHttpClient().executeMethod((HttpMethod)filePut);
            if (status >= 200 && status < 300) {
                this.getLog().info((CharSequence)"Bundle installed");
            } else {
                String msg = "Installation failed, cause: " + HttpStatus.getStatusText((int)status);
                if (this.failOnError) {
                    throw new MojoExecutionException(msg);
                }
                this.getLog().error((CharSequence)msg);
            }
        }
        catch (Exception ex) {
            throw new MojoExecutionException("Installation on " + targetURL + " failed, cause: " + ex.getMessage(), ex);
        }
        finally {
            filePut.releaseConnection();
        }
    }

    protected void configure(String targetURL, File file) throws MojoExecutionException {
        ManifestHeader.Entry[] entries;
        ManifestHeader header = null;
        try {
            Manifest mf = this.getManifest(file);
            String value = mf.getMainAttributes().getValue(HEADER_INITIAL_CONTENT);
            if (value == null) {
                this.getLog().debug((CharSequence)"Bundle has no initial content - no file system provider config created.");
                return;
            }
            header = ManifestHeader.parse((String)value);
            if (header == null || header.getEntries().length == 0) {
                this.getLog().warn((CharSequence)("Unable to parse header or header is empty: " + value));
                return;
            }
        }
        catch (IOException ioe) {
            throw new MojoExecutionException("Unable to read manifest from file " + file, (Exception)ioe);
        }
        HttpClient client = this.getHttpClient();
        this.getLog().info((CharSequence)"Trying to configure file system provider...");
        List resources = this.project.getResources();
        if (resources == null || resources.size() == 0) {
            throw new MojoExecutionException("No resources configured for this project.");
        }
        Map oldConfigs = this.getCurrentFileProviderConfigs(targetURL, client);
        for (ManifestHeader.Entry entry : entries = header.getEntries()) {
            String ignoreValue;
            String path = entry.getValue();
            if (path != null && !path.endsWith("/")) {
                path = path + "/";
            }
            if ((ignoreValue = entry.getDirectiveValue("maven:mount")) != null && ignoreValue.equalsIgnoreCase("false")) {
                this.getLog().debug((CharSequence)("Ignoring " + path));
                continue;
            }
            String installPath = entry.getDirectiveValue("path");
            if (installPath == null) {
                installPath = "/";
            }
            File dir = null;
            Iterator i = resources.iterator();
            while (dir == null && i.hasNext()) {
                Resource rsrc = (Resource)i.next();
                String child = path;
                String targetPath = rsrc.getTargetPath();
                if (targetPath != null && !targetPath.endsWith("/")) {
                    targetPath = targetPath + "/";
                }
                if (targetPath != null && path.startsWith(targetPath)) {
                    child = child.substring(targetPath.length());
                }
                if ((dir = new File(rsrc.getDirectory(), child)).exists()) continue;
                dir = null;
            }
            if (dir == null) {
                throw new MojoExecutionException("No resource entry found containing " + path);
            }
            if ("/".equals(installPath)) {
                throw new MojoExecutionException("Mapping to root path not supported by fs provider at the moment. Please adapt your initial content configuration.");
            }
            this.getLog().info((CharSequence)("Mapping " + dir + " to " + installPath));
            boolean found = false;
            Iterator entryIterator = oldConfigs.entrySet().iterator();
            while (!found && entryIterator.hasNext()) {
                Map.Entry current = entryIterator.next();
                String[] value = (String[])current.getValue();
                this.getLog().debug((CharSequence)("Comparing " + dir.getAbsolutePath() + " with " + value[0] + " (" + value[1] + ")"));
                if (!dir.getAbsolutePath().equals(value[0])) continue;
                if (installPath.equals(value[1])) {
                    this.getLog().debug((CharSequence)("Using existing configuration for " + dir + " and " + installPath));
                    found = true;
                } else {
                    this.getLog().debug((CharSequence)("Removing old configuration for " + value[0] + " and " + value[1]));
                    this.removeConfiguration(client, targetURL, current.getKey().toString());
                }
                entryIterator.remove();
            }
            if (found) continue;
            this.getLog().debug((CharSequence)("Adding new configuration for " + dir + " and " + installPath));
            this.addConfiguration(client, targetURL, dir.getAbsolutePath(), installPath);
        }
        for (Map.Entry current : oldConfigs.entrySet()) {
            String[] value = (String[])current.getValue();
            this.getLog().debug((CharSequence)("Removing old configuration for " + value[0] + " and " + value[1]));
            this.removeConfiguration(client, targetURL, current.getKey().toString());
        }
    }

    protected void removeConfiguration(HttpClient client, String targetURL, String pid) throws MojoExecutionException {
        String postUrl = targetURL + "/configMgr/" + pid;
        PostMethod post = new PostMethod(postUrl);
        post.addParameter("apply", "true");
        post.addParameter("delete", "true");
        try {
            int status = client.executeMethod((HttpMethod)post);
            if (status == 302 || status == 200) {
                this.getLog().debug((CharSequence)"Configuration removed.");
            } else {
                this.getLog().error((CharSequence)("Removing configuration failed, cause: " + HttpStatus.getStatusText((int)status)));
            }
        }
        catch (HttpException ex) {
            throw new MojoExecutionException("Removing configuration at " + postUrl + " failed, cause: " + ex.getMessage(), (Exception)((Object)ex));
        }
        catch (IOException ex) {
            throw new MojoExecutionException("Removing configuration at " + postUrl + " failed, cause: " + ex.getMessage(), (Exception)ex);
        }
        finally {
            post.releaseConnection();
        }
    }

    protected void addConfiguration(HttpClient client, String targetURL, String dir, String path) throws MojoExecutionException {
        String postUrl = targetURL + "/configMgr/" + FS_FACTORY;
        PostMethod post = new PostMethod(postUrl);
        post.addParameter("apply", "true");
        post.addParameter("factoryPid", FS_FACTORY);
        post.addParameter("pid", "[Temporary PID replaced by real PID upon save]");
        post.addParameter("provider.file", dir);
        post.addParameter("provider.roots", path);
        post.addParameter("propertylist", "provider.roots,provider.file");
        try {
            int status = client.executeMethod((HttpMethod)post);
            if (status == 302 || status == 200) {
                this.getLog().info((CharSequence)"Configuration created.");
            } else {
                this.getLog().error((CharSequence)("Configuration failed, cause: " + HttpStatus.getStatusText((int)status)));
            }
        }
        catch (HttpException ex) {
            throw new MojoExecutionException("Configuration on " + postUrl + " failed, cause: " + ex.getMessage(), (Exception)((Object)ex));
        }
        catch (IOException ex) {
            throw new MojoExecutionException("Configuration on " + postUrl + " failed, cause: " + ex.getMessage(), (Exception)ex);
        }
        finally {
            post.releaseConnection();
        }
    }

    protected Map getCurrentFileProviderConfigs(String targetURL, HttpClient client) throws MojoExecutionException {
        HashMap<String, String[]> result;
        block11: {
            this.getLog().debug((CharSequence)"Getting current file provider configurations.");
            result = new HashMap<String, String[]>();
            String getUrl = targetURL + "/configMgr/(service.factoryPid=" + FS_FACTORY + ").json";
            GetMethod get = new GetMethod(getUrl);
            try {
                int status = client.executeMethod((HttpMethod)get);
                if (status != 200) break block11;
                String contentType = get.getResponseHeader(HEADER_CONTENT_TYPE).getValue();
                int pos = contentType.indexOf(59);
                if (pos != -1) {
                    contentType = contentType.substring(0, pos);
                }
                if (!JSON_MIME_TYPE.equals(contentType)) {
                    this.getLog().debug((CharSequence)("Response type from web console is not JSON, but " + contentType));
                    this.throwWebConsoleTooOldException();
                }
                String jsonText = get.getResponseBodyAsString();
                try {
                    JSONArray array = new JSONArray(jsonText);
                    for (int i = 0; i < array.length(); ++i) {
                        JSONObject obj = array.getJSONObject(i);
                        String pid = obj.getString("pid");
                        String path = obj.getJSONObject("provider.file").getString("value");
                        String roots = obj.getJSONObject("provider.roots").getString("value");
                        if (path == null || !path.startsWith(this.project.getBasedir().getAbsolutePath())) continue;
                        this.getLog().debug((CharSequence)("Found configuration with pid: " + pid + ", path: " + path + ", roots: " + roots));
                        result.put(pid, new String[]{path, roots});
                    }
                }
                catch (JSONException ex) {
                    throw new MojoExecutionException("Reading configuration from " + getUrl + " failed, cause: " + ex.getMessage(), (Exception)((Object)ex));
                }
            }
            catch (HttpException ex) {
                throw new MojoExecutionException("Reading configuration from " + getUrl + " failed, cause: " + ex.getMessage(), (Exception)((Object)ex));
            }
            catch (IOException ex) {
                throw new MojoExecutionException("Reading configuration from " + getUrl + " failed, cause: " + ex.getMessage(), (Exception)ex);
            }
            finally {
                get.releaseConnection();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Manifest getManifest(File bundleFile) throws IOException {
        JarFile file = null;
        try {
            file = new JarFile(bundleFile);
            Manifest manifest = file.getManifest();
            return manifest;
        }
        finally {
            if (file != null) {
                try {
                    file.close();
                }
                catch (IOException ignore) {}
            }
        }
    }

    protected String checkWebConsoleVersion(String targetUrl) {
        this.getLog().debug((CharSequence)"Checking web console version....");
        String bundleUrl = targetUrl + "/bundles/org.apache.felix.webconsole.json";
        HttpClient client = this.getHttpClient();
        GetMethod gm = new GetMethod(bundleUrl);
        try {
            int status = client.executeMethod((HttpMethod)gm);
            if (status == 200) {
                if (gm.getResponseContentLength() == 0L) {
                    this.getLog().debug((CharSequence)"Response has zero length. Assuming older version of web console.");
                    return null;
                }
                String jsonText = gm.getResponseBodyAsString();
                try {
                    JSONObject obj = new JSONObject(jsonText);
                    JSONArray props = obj.getJSONArray("props");
                    for (int i = 0; i < props.length(); ++i) {
                        JSONObject property = props.getJSONObject(i);
                        if (!"Version".equals(property.get("key"))) continue;
                        String version = property.getString("value");
                        this.getLog().debug((CharSequence)("Found web console version " + version));
                        return version;
                    }
                    this.getLog().debug((CharSequence)"Version property not found in response. Assuming older version.");
                    return null;
                }
                catch (JSONException ex) {
                    this.getLog().debug((CharSequence)("Converting response to JSON failed. Assuming older version: " + ex.getMessage()));
                    return null;
                }
            }
            this.getLog().debug((CharSequence)("Status code from web console: " + status));
        }
        catch (HttpException e) {
            this.getLog().debug((CharSequence)("HttpException: " + e.getMessage()));
        }
        catch (IOException e) {
            this.getLog().debug((CharSequence)("IOException: " + e.getMessage()));
        }
        this.getLog().debug((CharSequence)"Unknown version.");
        return null;
    }
}

