/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.auth.core.impl;

import javax.servlet.Servlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.auth.Authenticator;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.apache.sling.auth.core.AuthUtil;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.propertytypes.ServiceDescription;
import org.osgi.service.component.propertytypes.ServiceVendor;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Servlet.class}, property={"sling.servlet.paths=/system/sling/logout"})
@ServiceDescription(value="Authenticator Logout Servlet")
@ServiceVendor(value="The Apache Software Foundation")
@Designate(ocd=Config.class)
public class LogoutServlet
extends SlingAllMethodsServlet {
    private static final long serialVersionUID = -1L;
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    @Reference(policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.OPTIONAL)
    private volatile Authenticator authenticator;
    public static final String SERVLET_PATH = "/system/sling/logout";

    protected void service(SlingHttpServletRequest request, SlingHttpServletResponse response) {
        Authenticator authenticator = this.authenticator;
        if (authenticator != null) {
            try {
                AuthUtil.setLoginResourceAttribute((HttpServletRequest)request, null);
                authenticator.logout((HttpServletRequest)request, (HttpServletResponse)response);
                return;
            }
            catch (IllegalStateException ise) {
                this.log.error("service: Response already committed, cannot logout");
                return;
            }
        }
        this.log.error("service: Authenticator service missing, cannot logout");
        response.setStatus(204);
    }

    @ObjectClassDefinition(name="Apache Sling Authentication Logout Servlet", description="Servlet for logging out users through the authenticator service.")
    public static @interface Config {
        @AttributeDefinition(name="Method", description="Supported Methods")
        public String[] sling_servlet_methods() default {"GET", "POST"};
    }
}

