/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.auth.core.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.servlet.http.HttpServletRequest;
import org.apache.sling.auth.core.impl.PathBasedHolder;

public class PathBasedHolderCache<Type extends PathBasedHolder> {
    private final Map<String, Map<String, SortedSet<Type>>> cache = new HashMap<String, Map<String, SortedSet<Type>>>();
    private final ReentrantReadWriteLock rwLock = new ReentrantReadWriteLock();

    public void clear() {
        this.rwLock.writeLock().lock();
        try {
            this.cache.clear();
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHolder(Type holder) {
        this.rwLock.writeLock().lock();
        try {
            Map<String, SortedSet<Type>> byHostMap = this.cache.get(((PathBasedHolder)holder).protocol);
            if (byHostMap == null) {
                byHostMap = new HashMap<String, SortedSet<Type>>();
                this.cache.put(((PathBasedHolder)holder).protocol, byHostMap);
            }
            TreeSet<Type> byPathSet = new TreeSet<Type>();
            SortedSet<Type> currentPathSet = byHostMap.get(((PathBasedHolder)holder).host);
            if (currentPathSet != null) {
                byPathSet.addAll(currentPathSet);
            }
            byPathSet.add(holder);
            byHostMap.put(((PathBasedHolder)holder).host, byPathSet);
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeHolder(Type holder) {
        this.rwLock.writeLock().lock();
        try {
            SortedSet<Type> byPathSet;
            Map<String, SortedSet<Type>> byHostMap = this.cache.get(((PathBasedHolder)holder).protocol);
            if (byHostMap != null && (byPathSet = byHostMap.get(((PathBasedHolder)holder).host)) != null) {
                TreeSet<Type> set = new TreeSet<Type>();
                set.addAll(byPathSet);
                set.remove(holder);
                if (set.isEmpty()) {
                    byHostMap.remove(((PathBasedHolder)holder).host);
                } else {
                    byHostMap.put(((PathBasedHolder)holder).host, set);
                }
            }
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Type>[] findApplicableHolders(HttpServletRequest request) {
        this.rwLock.readLock().lock();
        try {
            Map<String, SortedSet<Type>> defaultByHostMap;
            String hostname = request.getServerName() + (request.getServerPort() != 80 && request.getServerPort() != 443 ? ":" + request.getServerPort() : "");
            SortedSet[] result = new SortedSet[4];
            Map<String, SortedSet<Type>> byHostMap = this.cache.get(request.getScheme());
            if (byHostMap != null) {
                result[0] = byHostMap.get(hostname);
                result[1] = byHostMap.get("");
            }
            if ((defaultByHostMap = this.cache.get("")) != null) {
                result[2] = defaultByHostMap.get(hostname);
                result[3] = defaultByHostMap.get("");
            }
            SortedSet[] sortedSetArray = result;
            return sortedSetArray;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Type> getHolders() {
        this.rwLock.readLock().lock();
        try {
            ArrayList<Type> result = new ArrayList<Type>();
            for (Map<String, SortedSet<Type>> byHostEntry : this.cache.values()) {
                for (SortedSet<Type> holderSet : byHostEntry.values()) {
                    result.addAll(holderSet);
                }
            }
            ArrayList<Type> arrayList = result;
            return arrayList;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }
}

