/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.auth.core.impl;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Base64;
import org.apache.sling.auth.core.AuthUtil;
import org.apache.sling.auth.core.spi.AuthenticationHandler;
import org.apache.sling.auth.core.spi.AuthenticationInfo;
import org.apache.sling.auth.core.spi.DefaultAuthenticationFeedbackHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class HttpBasicAuthenticationHandler
extends DefaultAuthenticationFeedbackHandler
implements AuthenticationHandler {
    private static final String HEADER_WWW_AUTHENTICATE = "WWW-Authenticate";
    private static final String HEADER_AUTHORIZATION = "Authorization";
    private static final String AUTHENTICATION_SCHEME_BASIC = "Basic";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final String realm;
    private final boolean fullSupport;

    HttpBasicAuthenticationHandler(String realm, boolean fullSupport) {
        this.realm = realm;
        this.fullSupport = fullSupport;
    }

    @Override
    public AuthenticationInfo extractCredentials(HttpServletRequest request, HttpServletResponse response) {
        AuthenticationInfo info = this.extractCredentials(request);
        if (info != null) {
            return info;
        }
        if (this.forceAuthentication(request, response)) {
            return AuthenticationInfo.DOING_AUTH;
        }
        return null;
    }

    @Override
    public boolean requestCredentials(HttpServletRequest request, HttpServletResponse response) {
        return this.fullSupport ? this.sendUnauthorized(response) : false;
    }

    @Override
    public void dropCredentials(HttpServletRequest request, HttpServletResponse response) {
        if (this.fullSupport && request.getHeader(HEADER_AUTHORIZATION) != null) {
            this.sendUnauthorized(response);
        }
    }

    @Override
    public void authenticationFailed(HttpServletRequest request, HttpServletResponse response, AuthenticationInfo authInfo) {
        if (!AuthUtil.isValidateRequest(request)) {
            this.sendUnauthorized(response);
        }
    }

    private boolean isLoginRequested(HttpServletRequest request) {
        return AuthUtil.getAttributeOrParameter(request, "sling:authRequestLogin", null) != null;
    }

    private boolean forceAuthentication(HttpServletRequest request, HttpServletResponse response) {
        boolean authenticationForced = false;
        if (this.isLoginRequested(request)) {
            authenticationForced = this.sendUnauthorized(response);
        } else {
            this.log.debug("forceAuthentication: Not forcing authentication because request parameter {} is not set", (Object)"sling:authRequestLogin");
        }
        return authenticationForced;
    }

    boolean sendUnauthorized(HttpServletResponse response) {
        if (response.isCommitted()) {
            this.log.error("sendUnauthorized: Cannot send 401/UNAUTHORIZED; response is already committed");
        } else {
            response.resetBuffer();
            response.setStatus(401);
            response.setHeader(HEADER_WWW_AUTHENTICATE, "Basic realm=\"" + this.realm + "\"");
            try {
                response.flushBuffer();
                return true;
            }
            catch (IOException ioe) {
                this.log.error("sendUnauthorized: Failed requesting authentication", (Throwable)ioe);
            }
        }
        return false;
    }

    public String toString() {
        return "HTTP Basic Authentication Handler (" + (this.fullSupport ? "enabled" : "preemptive") + ")";
    }

    protected AuthenticationInfo extractCredentials(HttpServletRequest request) {
        char[] password;
        String userId;
        String decoded;
        String authHeader = request.getHeader(HEADER_AUTHORIZATION);
        if (authHeader == null || authHeader.length() == 0) {
            return null;
        }
        int blank = (authHeader = authHeader.trim()).indexOf(32);
        if (blank <= 0) {
            return null;
        }
        String authType = authHeader.substring(0, blank);
        String authInfo = authHeader.substring(blank).trim();
        if (!authType.equalsIgnoreCase(AUTHENTICATION_SCHEME_BASIC)) {
            return null;
        }
        try {
            byte[] encoded = authInfo.getBytes("ISO-8859-1");
            byte[] bytes = Base64.decodeBase64((byte[])encoded);
            decoded = new String(bytes, "ISO-8859-1");
        }
        catch (UnsupportedEncodingException uee) {
            this.log.error("extractAuthentication: Cannot en/decode authentication info", (Throwable)uee);
            return null;
        }
        int colIdx = decoded.indexOf(58);
        if (colIdx < 0) {
            userId = decoded;
            password = new char[]{};
        } else {
            userId = decoded.substring(0, colIdx);
            password = decoded.substring(colIdx + 1).toCharArray();
        }
        return new AuthenticationInfo("BASIC", userId, password);
    }
}

