/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.auth.core.impl;

import org.osgi.framework.ServiceReference;
import org.osgi.util.converter.Converters;
import org.osgi.util.converter.Converting;

public abstract class PathBasedHolder
implements Comparable<PathBasedHolder> {
    protected final String fullPath;
    final String protocol;
    final String host;
    final String path;
    final ServiceReference<?> serviceReference;

    protected PathBasedHolder(String url, ServiceReference<?> serviceReference) {
        String path = url;
        String host = "";
        String protocol = "";
        if (path.startsWith("http://") || path.startsWith("https://")) {
            int idxProtocolEnd = path.indexOf("://");
            protocol = path.substring(0, idxProtocolEnd);
            path = path.substring(idxProtocolEnd + 1);
        }
        if (path.startsWith("//")) {
            int idxHostEnd = path.indexOf("/", 2);
            int n = idxHostEnd = idxHostEnd == -1 ? path.length() : idxHostEnd;
            if (path.length() > 2) {
                host = path.substring(2, idxHostEnd);
                path = idxHostEnd < path.length() ? path.substring(idxHostEnd) : "/";
            } else {
                path = "/";
            }
        }
        this.fullPath = url;
        this.path = path;
        this.host = host;
        this.protocol = protocol;
        this.serviceReference = serviceReference;
    }

    String getProvider() {
        if (this.serviceReference == null) {
            return "Apache Sling Request Authenticator";
        }
        String descr = (String)Converters.standardConverter().convert(this.serviceReference.getProperty("service.description")).to(String.class);
        if (descr != null) {
            return descr;
        }
        String id = (String)((Converting)Converters.standardConverter().convert(this.serviceReference.getProperty("service.id")).defaultValue((Object)"unknown")).to(String.class);
        return "Service ".concat(id);
    }

    @Override
    public int compareTo(PathBasedHolder other) {
        int pathResult = other.path.compareTo(this.path);
        if (pathResult != 0) {
            return pathResult;
        }
        if (this.serviceReference == null) {
            if (other.serviceReference == null) {
                return this.getClass().getName().compareTo(other.getClass().getName());
            }
            return -1;
        }
        if (other.serviceReference == null) {
            return 1;
        }
        int serviceResult = other.serviceReference.compareTo(this.serviceReference);
        if (serviceResult != 0) {
            return serviceResult;
        }
        return this.getClass().getName().compareTo(other.getClass().getName());
    }

    public int hashCode() {
        return this.fullPath.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass() == this.getClass()) {
            PathBasedHolder other = (PathBasedHolder)obj;
            return this.fullPath.equals(other.fullPath) && (this.serviceReference == null && other.serviceReference == null || this.serviceReference != null && this.serviceReference.equals(other.serviceReference));
        }
        return false;
    }
}

