/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.auth.core.impl;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.api.resource.mapping.ResourceMapper;
import org.apache.sling.auth.core.impl.AuthenticationRequirementHolder;
import org.apache.sling.auth.core.impl.PathBasedHolderCache;
import org.osgi.framework.AllServiceListener;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;
import org.osgi.util.converter.Converters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SlingAuthenticatorServiceListener
implements AllServiceListener,
EventHandler {
    private static final String FILTER_EXPR = "(".concat("sling.auth.requirements").concat("=*)");
    private static final Long UPDATE = 0L;
    private static final Long CLEAR = -1L;
    private final Logger logger = LoggerFactory.getLogger(SlingAuthenticatorServiceListener.class);
    private final ResourceResolverFactory resolverFactory;
    private final PathBasedHolderCache<AuthenticationRequirementHolder> authRequiredCache;
    private final Map<Long, Set<String>> regProps = new ConcurrentHashMap<Long, Set<String>>();
    private final Map<Long, List<AuthenticationRequirementHolder>> props = new ConcurrentHashMap<Long, List<AuthenticationRequirementHolder>>();
    private ServiceRegistration<EventHandler> serviceRegistration;
    private final Map<Long, Action> processingQueue = new LinkedHashMap<Long, Action>();
    private final Executor executor;
    private final AtomicBoolean backgroundJobRunning = new AtomicBoolean(false);

    static SlingAuthenticatorServiceListener createListener(BundleContext context, Executor executor, ResourceResolverFactory factory, PathBasedHolderCache<AuthenticationRequirementHolder> authRequiredCache) {
        SlingAuthenticatorServiceListener listener = new SlingAuthenticatorServiceListener(authRequiredCache, executor, factory);
        try {
            context.addServiceListener((ServiceListener)listener, FILTER_EXPR);
            Hashtable<String, String> props = new Hashtable<String, String>();
            ((Dictionary)props).put("event.topics", "org/apache/sling/api/resource/ResourceResolverMapping/CHANGED");
            listener.setServiceRegistration((ServiceRegistration<EventHandler>)context.registerService(EventHandler.class, (Object)listener, props));
            ServiceReference[] refs = context.getAllServiceReferences(null, FILTER_EXPR);
            if (refs != null) {
                for (ServiceReference ref : refs) {
                    Long id = (Long)ref.getProperty("service.id");
                    listener.queue(id, new Action(ActionType.ADDED, ref));
                }
            }
            listener.schedule();
            return listener;
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            return null;
        }
    }

    private SlingAuthenticatorServiceListener(PathBasedHolderCache<AuthenticationRequirementHolder> authRequiredCache, Executor executor, ResourceResolverFactory factory) {
        this.authRequiredCache = authRequiredCache;
        this.executor = executor;
        this.resolverFactory = factory;
        this.logger.debug("Started auth requirements listener");
    }

    void setServiceRegistration(ServiceRegistration<EventHandler> reg) {
        this.serviceRegistration = reg;
    }

    public void stop(BundleContext bundleContext) {
        bundleContext.removeServiceListener((ServiceListener)this);
        if (this.serviceRegistration != null) {
            this.serviceRegistration.unregister();
            this.serviceRegistration = null;
        }
        this.queue(CLEAR, null);
        this.backgroundJobRunning.set(false);
        this.logger.debug("Stopped auth requirements listener");
    }

    private void schedule() {
        if (this.backgroundJobRunning.compareAndSet(false, true)) {
            this.executor.execute(() -> this.processQueue());
        }
    }

    public void serviceChanged(ServiceEvent event) {
        Long id = (Long)event.getServiceReference().getProperty("service.id");
        if ((event.getType() & 0xC) != 0) {
            this.queue(id, new Action(ActionType.REMOVED, event.getServiceReference()));
        }
        if ((event.getType() & 2) != 0) {
            this.queue(id, new Action(ActionType.MODIFIED, event.getServiceReference()));
        }
        if ((event.getType() & 1) != 0) {
            this.queue(id, new Action(ActionType.ADDED, event.getServiceReference()));
        }
        this.schedule();
    }

    public void handleEvent(Event event) {
        this.queue(UPDATE, null);
        this.schedule();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queue(long id, Action action) {
        this.logger.debug("Queuing action for service {} : {}", (Object)id, (Object)action);
        Map<Long, Action> map = this.processingQueue;
        synchronized (map) {
            if (id == CLEAR) {
                this.processingQueue.clear();
            } else if (id == UPDATE) {
                for (Long updateId : this.props.keySet()) {
                    this.processingQueue.putIfAbsent(updateId, new Action(ActionType.UPDATE, null));
                }
            } else {
                this.processingQueue.remove(id);
                this.processingQueue.put(id, action);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void processQueue() {
        ResourceMapper mapper = null;
        try (ResourceResolver resolver = null;){
            while (this.backgroundJobRunning.get()) {
                Map.Entry<Long, Action> entry = null;
                Map<Long, Action> map = this.processingQueue;
                // MONITORENTER : map
                Iterator<Map.Entry<Long, Action>> iter = this.processingQueue.entrySet().iterator();
                if (iter.hasNext()) {
                    entry = iter.next();
                    iter.remove();
                }
                // MONITOREXIT : map
                if (entry == null) {
                    map = this.processingQueue;
                    // MONITORENTER : map
                    this.backgroundJobRunning.compareAndSet(true, !this.processingQueue.isEmpty());
                    // MONITOREXIT : map
                    continue;
                }
                this.logger.debug("Processing action for service {} : {}", (Object)entry.getKey(), (Object)entry.getValue());
                if (entry.getValue().type != ActionType.REMOVED && mapper == null) {
                    try {
                        resolver = this.resolverFactory.getServiceResourceResolver(null);
                        mapper = (ResourceMapper)resolver.adaptTo(ResourceMapper.class);
                    }
                    catch (LoginException loginException) {
                        // empty catch block
                    }
                }
                this.process(mapper, entry.getKey(), entry.getValue());
            }
            return;
        }
    }

    private void process(ResourceMapper mapper, Long id, Action action) {
        switch (action.type) {
            case ADDED: {
                this.addService(mapper, action.reference);
                break;
            }
            case REMOVED: {
                this.removeService((Long)action.reference.getProperty("service.id"));
                break;
            }
            case MODIFIED: {
                this.modifiedService(mapper, action.reference);
                break;
            }
            case UPDATE: {
                List<AuthenticationRequirementHolder> list = this.props.get(id);
                if (list.isEmpty()) break;
                this.modifiedService(mapper, list.get((int)0).serviceReference);
            }
        }
    }

    void registerAllServices() {
        for (List<AuthenticationRequirementHolder> authReqs : this.props.values()) {
            this.registerService(authReqs);
        }
    }

    private void registerService(List<AuthenticationRequirementHolder> authReqs) {
        for (AuthenticationRequirementHolder authReq : authReqs) {
            this.authRequiredCache.addHolder(authReq);
        }
    }

    private Set<String> buildPathsSet(ResourceMapper mapper, String[] authReqPaths) {
        HashSet<String> paths = new HashSet<String>();
        for (String authReq : authReqPaths) {
            String prefix;
            if (authReq == null || (authReq = authReq.trim()).length() <= 0) continue;
            if (authReq.startsWith("+")) {
                prefix = null;
                authReq = authReq.substring(1);
            } else if (authReq.startsWith("-")) {
                prefix = "-";
                authReq = authReq.substring(1);
            } else {
                prefix = null;
            }
            paths.add(prefix == null ? authReq : prefix.concat(authReq));
            if (mapper == null) continue;
            for (String mappedPath : mapper.getAllMappings(authReq)) {
                paths.add(prefix == null ? mappedPath : prefix.concat(mappedPath));
            }
        }
        return paths;
    }

    private void addService(ResourceMapper mapper, ServiceReference<?> ref) {
        String[] authReqPaths = (String[])Converters.standardConverter().convert(ref.getProperty("sling.auth.requirements")).to(String[].class);
        if (authReqPaths.length > 0) {
            Long id = (Long)ref.getProperty("service.id");
            Set<String> paths = this.buildPathsSet(mapper, authReqPaths);
            if (!paths.isEmpty()) {
                ArrayList<AuthenticationRequirementHolder> authReqList = new ArrayList<AuthenticationRequirementHolder>();
                for (String authReq : paths) {
                    authReqList.add(AuthenticationRequirementHolder.fromConfig(authReq, ref));
                }
                this.regProps.put(id, paths);
                this.registerService(authReqList);
                this.props.put(id, authReqList);
                this.logger.debug("Added auth requirements for service {} : {}", (Object)id, paths);
            }
        }
    }

    private void modifiedService(ResourceMapper mapper, ServiceReference<?> ref) {
        String[] authReqPaths = (String[])Converters.standardConverter().convert(ref.getProperty("sling.auth.requirements")).to(String[].class);
        Long id = (Long)ref.getProperty("service.id");
        if (authReqPaths.length > 0) {
            Set<String> oldPaths = this.regProps.get(id);
            if (oldPaths == null) {
                this.addService(mapper, ref);
            } else {
                Set<String> paths = this.buildPathsSet(mapper, authReqPaths);
                if (paths.isEmpty()) {
                    this.removeService(id);
                } else {
                    AuthenticationRequirementHolder holder;
                    List<AuthenticationRequirementHolder> authReqs = this.props.get(id);
                    for (String oldPath : oldPaths) {
                        if (paths.contains(oldPath)) continue;
                        holder = AuthenticationRequirementHolder.fromConfig(oldPath, ref);
                        authReqs.remove(holder);
                        this.authRequiredCache.removeHolder(holder);
                    }
                    for (String path : paths) {
                        if (oldPaths.contains(path)) continue;
                        holder = AuthenticationRequirementHolder.fromConfig(path, ref);
                        authReqs.add(holder);
                        this.authRequiredCache.addHolder(holder);
                    }
                    this.regProps.put(id, paths);
                    this.logger.debug("Updated auth requirements for service {} : {}", (Object)id, paths);
                }
            }
        } else {
            this.removeService(id);
        }
    }

    private void removeService(Long id) {
        List<AuthenticationRequirementHolder> authReqs = this.props.remove(id);
        if (authReqs != null) {
            for (AuthenticationRequirementHolder authReq : authReqs) {
                this.authRequiredCache.removeHolder(authReq);
            }
        }
        this.regProps.remove(id);
        this.logger.debug("Removed auth requirements for service {}", (Object)id);
    }

    public static final class Action {
        public final ActionType type;
        public final ServiceReference<?> reference;

        public Action(ActionType type, ServiceReference<?> ref) {
            this.type = type;
            this.reference = ref;
        }

        public String toString() {
            return "Action [type=" + (Object)((Object)this.type) + ", reference=" + this.reference + "]";
        }
    }

    public static enum ActionType {
        ADDED,
        MODIFIED,
        REMOVED,
        UPDATE;

    }
}

