/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.auth.core.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpServletRequest;
import org.apache.sling.auth.core.impl.PathBasedHolder;

public class PathBasedHolderCache<Type extends PathBasedHolder> {
    private final Map<String, Map<String, SortedSet<Type>>> cache = new ConcurrentHashMap<String, Map<String, SortedSet<Type>>>();

    protected void clear() {
        this.cache.clear();
    }

    public synchronized void addHolder(Type holder) {
        Map byHostMap = this.cache.computeIfAbsent(((PathBasedHolder)holder).protocol, protocol -> new ConcurrentHashMap());
        SortedSet currentPathSet = (SortedSet)byHostMap.get(((PathBasedHolder)holder).host);
        TreeSet<Type> byPathSet = new TreeSet<Type>();
        if (currentPathSet != null) {
            byPathSet.addAll(currentPathSet);
        }
        byPathSet.add(holder);
        byHostMap.put(((PathBasedHolder)holder).host, byPathSet);
    }

    public synchronized void removeHolder(Type holder) {
        SortedSet<Type> byPathSet;
        Map<String, SortedSet<Type>> byHostMap = this.cache.get(((PathBasedHolder)holder).protocol);
        if (byHostMap != null && (byPathSet = byHostMap.get(((PathBasedHolder)holder).host)) != null) {
            TreeSet<Type> set = new TreeSet<Type>();
            set.addAll(byPathSet);
            set.remove(holder);
            if (set.isEmpty()) {
                byHostMap.remove(((PathBasedHolder)holder).host);
            } else {
                byHostMap.put(((PathBasedHolder)holder).host, set);
            }
        }
    }

    public Collection<Type>[] findApplicableHolders(HttpServletRequest request) {
        Map<String, SortedSet<Type>> defaultByHostMap;
        String hostname = request.getServerPort() != 80 && request.getServerPort() != 443 ? request.getServerName().concat(":").concat(String.valueOf(request.getServerPort())) : request.getServerName();
        SortedSet[] result = new SortedSet[4];
        Map<String, SortedSet<Type>> byHostMap = this.cache.get(request.getScheme());
        if (byHostMap != null) {
            result[0] = byHostMap.get(hostname);
            result[1] = byHostMap.get("");
        }
        if ((defaultByHostMap = this.cache.get("")) != null) {
            result[2] = defaultByHostMap.get(hostname);
            result[3] = defaultByHostMap.get("");
        }
        return result;
    }

    public List<Type> getHolders() {
        ArrayList<Type> result = new ArrayList<Type>();
        for (Map<String, SortedSet<Type>> byHostEntry : this.cache.values()) {
            for (SortedSet<Type> holderSet : byHostEntry.values()) {
                result.addAll(holderSet);
            }
        }
        return result;
    }
}

