/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.auth.core.impl;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import java.util.Map;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.sling.api.request.ResponseUtil;
import org.apache.sling.auth.core.impl.AuthenticationHandlersManager;
import org.apache.sling.auth.core.impl.AuthenticationRequirementHolder;
import org.apache.sling.auth.core.impl.AuthenticationRequirementsManager;
import org.apache.sling.auth.core.impl.PathBasedHolderCache;
import org.apache.sling.auth.core.impl.SlingAuthenticator;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.propertytypes.ServiceDescription;
import org.osgi.service.component.propertytypes.ServiceVendor;

@Component(service={Servlet.class}, configurationPid={"org.apache.sling.engine.impl.auth.SlingAuthenticator"}, property={"felix.webconsole.label=slingauth", "felix.webconsole.title=Authenticator", "felix.webconsole.category=Sling"})
@ServiceDescription(value="Apache Sling Request Authenticator WebConsole Plugin")
@ServiceVendor(value="The Apache Software Foundation")
public class AuthenticatorWebConsolePlugin
extends HttpServlet {
    public static final String LABEL = "slingauth";
    public static final String TITLE = "Authenticator";
    @Reference(service=AuthenticationRequirementsManager.class)
    private PathBasedHolderCache<AuthenticationRequirementHolder> authenticationRequirementsManager;
    @Reference
    private AuthenticationHandlersManager authenticationHoldersManager;
    private final SlingAuthenticator.Config config;

    @Activate
    public AuthenticatorWebConsolePlugin(SlingAuthenticator.Config config) {
        this.config = config;
    }

    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if ("GET".equals(req.getMethod()) || "HEAD".equals(req.getMethod())) {
            super.service(req, resp);
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        try {
            PrintWriter pw = resp.getWriter();
            pw.println("<table class='content' width='100%' cellspacing='0' cellpadding='0'>");
            this.printAuthenticationHandler(pw);
            pw.println("<tr><td colspan='2'>&nbsp;</td></tr>");
            this.printAuthenticationRequirements(pw);
            pw.println("<tr><td colspan='2'>&nbsp;</td></tr>");
            this.printAuthenticationConfiguration(pw);
            pw.println("</table>");
        }
        catch (IOException ioe) {
            this.log("Unexpected exception caught", ioe);
            try {
                resp.sendError(500);
            }
            catch (IOException ioe2) {
                this.log("Unexpected exception caught while sending the error", ioe2);
            }
        }
    }

    private void printAuthenticationHandler(PrintWriter pw) {
        this.tr(pw);
        pw.println("<th class='content container' colspan='3'>Registered Authentication Handler</td>");
        this.endTr(pw);
        this.tr(pw);
        pw.println("<th class='content'>Path</td>");
        pw.println("<th class='content' colspan='2'>Handler</td>");
        this.endTr(pw);
        Map<String, List<String>> handlerMap = this.authenticationHoldersManager.getAuthenticationHandlerMap();
        for (Map.Entry<String, List<String>> handler : handlerMap.entrySet()) {
            String path = handler.getKey();
            for (String name : handler.getValue()) {
                pw.println("<tr class='content'>");
                this.td(pw, path);
                this.td(pw, name, 2);
                this.endTr(pw);
            }
        }
    }

    private void printAuthenticationRequirements(PrintWriter pw) {
        this.tr(pw);
        pw.println("<th class='content container' colspan='3'>Authentication Requirement Configuration</td>");
        this.endTr(pw);
        this.tr(pw);
        pw.println("<th class='content'>Path</td>");
        pw.println("<th class='content'>Authentication Required</td>");
        pw.println("<th class='content'>Defining Service (Description or ID)</td>");
        this.endTr(pw);
        List<AuthenticationRequirementHolder> holderList = this.authenticationRequirementsManager.getHolders();
        for (AuthenticationRequirementHolder req : holderList) {
            pw.println("<tr class='content'>");
            this.td(pw, req.fullPath);
            this.td(pw, req.requiresAuthentication() ? "Yes" : "No");
            this.td(pw, req.getProvider());
            this.endTr(pw);
        }
    }

    private void printAuthenticationConfiguration(PrintWriter pw) {
        String anonUser = this.config.sling_auth_anonymous_user() != null && this.config.sling_auth_anonymous_user().isEmpty() ? this.config.sling_auth_anonymous_user() : "(default)";
        String sudoCookie = this.config.auth_sudo_cookie();
        String sudoParam = this.config.auth_sudo_parameter();
        this.tr(pw);
        pw.println("<th class='content container' colspan='3'>Miscellaneous Configuration</td>");
        this.endTr(pw);
        this.endTr(pw);
        this.tr(pw);
        pw.println("<td class='content'>Impersonation Cookie</td>");
        this.td(pw, sudoCookie, 2);
        this.endTr(pw);
        this.tr(pw);
        pw.println("<td class='content'>Impersonation Parameter</td>");
        this.td(pw, sudoParam, 2);
        this.endTr(pw);
        this.tr(pw);
        pw.println("<td class='content'>Anonymous User Name</td>");
        this.td(pw, anonUser, 2);
        this.endTr(pw);
    }

    private void td(PrintWriter pw, String content) {
        this.td(pw, content, -1);
    }

    private void td(PrintWriter pw, String content, int colspan) {
        if (colspan > 1) {
            pw.printf("<td class='content' colspan='%d'>%s</td>%n", colspan, ResponseUtil.escapeXml((String)content));
        } else {
            pw.printf("<td class='content'>%s</td>%n", ResponseUtil.escapeXml((String)content));
        }
    }

    private void tr(PrintWriter pw) {
        pw.println("<tr>");
    }

    private void endTr(PrintWriter pw) {
        pw.println("</tr>");
    }
}

