/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.auth.core.impl;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.apache.sling.auth.core.impl.AbstractAuthenticationHandlerHolder;
import org.apache.sling.auth.core.impl.AuthenticationHandlerHolder;
import org.apache.sling.auth.core.impl.PathBasedHolderCache;
import org.apache.sling.auth.core.impl.SlingAuthenticator;
import org.apache.sling.auth.core.impl.engine.EngineAuthenticationHandlerHolder;
import org.apache.sling.engine.auth.AuthenticationHandler;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.util.converter.Converters;

@Component(service={AuthenticationHandlersManager.class}, configurationPid={"org.apache.sling.engine.impl.auth.SlingAuthenticator"})
public class AuthenticationHandlersManager
extends PathBasedHolderCache<AbstractAuthenticationHandlerHolder> {
    private final Map<String, List<AbstractAuthenticationHandlerHolder>> handlerMap = new ConcurrentHashMap<String, List<AbstractAuthenticationHandlerHolder>>();
    private final Boolean httpSupport;

    @Activate
    public AuthenticationHandlersManager(SlingAuthenticator.Config config) {
        String http = SlingAuthenticator.getHttpAuth(config);
        this.httpSupport = "disabled".equals(http) ? null : Boolean.valueOf("enabled".equals(http));
    }

    Map<String, List<String>> getAuthenticationHandlerMap() {
        List registeredHolders = this.getHolders();
        LinkedHashMap<String, List<String>> ahMap = new LinkedHashMap<String, List<String>>();
        for (AbstractAuthenticationHandlerHolder holder : registeredHolders) {
            List provider = ahMap.computeIfAbsent(holder.fullPath, key -> new ArrayList());
            provider.add(holder.getProvider());
        }
        if (this.httpSupport != null) {
            List provider = ahMap.computeIfAbsent("/", key -> new ArrayList());
            provider.add("HTTP Basic Authentication Handler (" + (Boolean.TRUE.equals(this.httpSupport) ? "enabled" : "preemptive") + ")");
        }
        return ahMap;
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    private void bindAuthHandler(org.apache.sling.auth.core.spi.AuthenticationHandler handler, ServiceReference<Object> ref) {
        String id = "A".concat(ref.getProperty("service.id").toString());
        String[] paths = (String[])Converters.standardConverter().convert(ref.getProperty("path")).to(String[].class);
        this.internalBindAuthHandler(paths, id, path -> new AuthenticationHandlerHolder((String)path, handler, ref));
    }

    private void updatedAuthHandler(org.apache.sling.auth.core.spi.AuthenticationHandler handler, ServiceReference<Object> ref) {
        this.unbindAuthHandler(ref);
        this.bindAuthHandler(handler, ref);
    }

    private void unbindAuthHandler(ServiceReference<Object> ref) {
        String id = "A".concat(ref.getProperty("service.id").toString());
        this.internalUnbindAuthHandler(id);
    }

    @Deprecated
    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    private void bindEngineAuthHandler(AuthenticationHandler handler, ServiceReference<Object> ref) {
        String id = "E".concat(ref.getProperty("service.id").toString());
        String[] paths = (String[])Converters.standardConverter().convert(ref.getProperty("path")).to(String[].class);
        this.internalBindAuthHandler(paths, id, path -> new EngineAuthenticationHandlerHolder((String)path, handler, ref));
    }

    @Deprecated
    private void updatedEngineAuthHandler(AuthenticationHandler handler, ServiceReference<Object> ref) {
        this.unbindEngineAuthHandler(ref);
        this.bindEngineAuthHandler(handler, ref);
    }

    private void unbindEngineAuthHandler(ServiceReference<Object> ref) {
        String id = "E".concat(ref.getProperty("service.id").toString());
        this.internalUnbindAuthHandler(id);
    }

    private void internalBindAuthHandler(String[] paths, String id, Function<String, AbstractAuthenticationHandlerHolder> createFunction) {
        if (paths != null && paths.length > 0) {
            ArrayList<AbstractAuthenticationHandlerHolder> holderList = new ArrayList<AbstractAuthenticationHandlerHolder>();
            for (String path : paths) {
                if (path == null || path.length() <= 0) continue;
                holderList.add(createFunction.apply(path));
            }
            if (!holderList.isEmpty()) {
                for (AbstractAuthenticationHandlerHolder holder : holderList) {
                    this.addHolder(holder);
                }
                this.handlerMap.put(id, holderList);
            }
        }
    }

    private void internalUnbindAuthHandler(String id) {
        List<AbstractAuthenticationHandlerHolder> holders = this.handlerMap.remove(id);
        if (holders != null) {
            for (AbstractAuthenticationHandlerHolder holder : holders) {
                this.removeHolder(holder);
            }
        }
    }
}

