/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.commons.html.impl;

import java.io.IOException;
import java.io.InputStream;
import org.apache.sling.commons.html.HtmlParser;
import org.apache.sling.commons.html.impl.DOMBuilder;
import org.ccil.cowan.tagsoup.Parser;
import org.w3c.dom.Document;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

public class HtmlParserImpl
implements HtmlParser {
    public void parse(InputStream stream, String encoding, ContentHandler ch) throws SAXException {
        Parser parser = new Parser();
        if (ch instanceof LexicalHandler) {
            parser.setProperty("http://xml.org/sax/properties/lexical-handler", ch);
        }
        parser.setContentHandler(ch);
        InputSource source = new InputSource(stream);
        source.setEncoding(encoding);
        try {
            parser.parse(source);
        }
        catch (IOException ioe) {
            throw new SAXException(ioe);
        }
    }

    public Document parse(String systemId, InputStream stream, String encoding) throws IOException {
        Parser parser = new Parser();
        DOMBuilder builder = new DOMBuilder();
        InputSource source = new InputSource(stream);
        source.setEncoding(encoding);
        source.setSystemId(systemId);
        try {
            parser.setProperty("http://xml.org/sax/properties/lexical-handler", builder);
            parser.setContentHandler(builder);
            parser.parse(source);
        }
        catch (SAXException se) {
            if (se.getCause() instanceof IOException) {
                throw (IOException)se.getCause();
            }
            throw (IOException)new IOException("Unable to parse xml.").initCause(se);
        }
        return builder.getDocument();
    }
}

