/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.commons.log.logback.internal.config;

import org.apache.sling.commons.log.logback.internal.LogConfigManager;
import org.apache.sling.commons.log.logback.internal.config.LogConfigurator;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceRegistration;

public class ConfigurationServiceFactory
implements ServiceFactory {
    private final LogConfigManager logConfigManager;
    private final String serviceClass;
    private int useCount;
    private Object service;

    public ConfigurationServiceFactory(LogConfigManager logConfigManager, String serviceClass) {
        this.logConfigManager = logConfigManager;
        this.serviceClass = serviceClass;
    }

    public Object getService(Bundle bundle, ServiceRegistration registration) {
        if (this.service == null) {
            this.useCount = 1;
            this.service = this.createInstance();
        } else {
            ++this.useCount;
        }
        return this.service;
    }

    public void ungetService(Bundle bundle, ServiceRegistration registration, Object service) {
        --this.useCount;
        if (this.useCount <= 0) {
            service = null;
        }
    }

    private Object createInstance() {
        try {
            Class<?> type = this.getClass().getClassLoader().loadClass(this.serviceClass);
            Object instance = type.newInstance();
            if (instance instanceof LogConfigurator) {
                ((LogConfigurator)instance).setLogConfigManager(this.logConfigManager);
            }
            return instance;
        }
        catch (Throwable t) {
            throw new RuntimeException("Failed to create " + this.serviceClass + " instance", t);
        }
    }
}

