/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.commons.messaging.mail.internal;

import java.util.List;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.event.ConnectionListener;
import javax.mail.event.TransportListener;
import javax.mail.internet.MimeMessage;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.commons.crypto.CryptoService;
import org.apache.sling.commons.messaging.MessageService;
import org.apache.sling.commons.messaging.mail.MailService;
import org.apache.sling.commons.messaging.mail.MessageBuilder;
import org.apache.sling.commons.messaging.mail.MessageIdProvider;
import org.apache.sling.commons.messaging.mail.internal.SimpleMailServiceConfiguration;
import org.apache.sling.commons.messaging.mail.internal.SimpleMessageBuilder;
import org.apache.sling.commons.threads.ThreadPool;
import org.apache.sling.commons.threads.ThreadPoolManager;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.osgi.service.metatype.annotations.Designate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={MessageService.class, MailService.class}, property={"service.description=Apache Sling Commons Messaging Mail \u2013 Simple Mail Service", "service.vendor=The Apache Software Foundation", "protocol=SMTPS"})
@Designate(ocd=SimpleMailServiceConfiguration.class, factory=true)
public class SimpleMailService
implements MailService {
    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    private volatile MessageIdProvider messageIdProvider;
    @Reference(cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    private volatile ThreadPoolManager threadPoolManager;
    @Reference(cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    private volatile CryptoService cryptoService;
    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    private volatile List<ConnectionListener> connectionListeners;
    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    private volatile List<TransportListener> transportListeners;
    private ThreadPool threadPool;
    private SimpleMailServiceConfiguration configuration;
    private Session session;
    private static final String SMTPS_PROTOCOL = "smtps";
    private static final String MAIL_SMTPS_FROM = "mail.smtps.from";
    private static final String MESSAGE_ID_HEADER = "Message-ID";
    private final Logger logger = LoggerFactory.getLogger(SimpleMailService.class);

    @Activate
    private void activate(SimpleMailServiceConfiguration configuration) {
        this.logger.debug("activating");
        this.configuration = configuration;
        this.configure(configuration);
    }

    @Modified
    private void modified(SimpleMailServiceConfiguration configuration) {
        this.logger.debug("modifying");
        this.configuration = configuration;
        this.configure(configuration);
    }

    @Deactivate
    private void deactivate() {
        this.logger.debug("deactivating");
        this.configuration = null;
        this.threadPoolManager.release(this.threadPool);
        this.threadPool = null;
        this.session = null;
    }

    private void configure(SimpleMailServiceConfiguration configuration) {
        this.threadPoolManager.release(this.threadPool);
        this.threadPool = this.threadPoolManager.get(configuration.threadpool_name());
        Properties properties = new Properties();
        String from = configuration.mail_smtps_from();
        if (StringUtils.isNotBlank((CharSequence)from)) {
            properties.setProperty(MAIL_SMTPS_FROM, from);
        }
        this.session = Session.getInstance((Properties)properties);
    }

    @Override
    @NotNull
    public MessageBuilder getMessageBuilder() {
        return new SimpleMessageBuilder(this.session);
    }

    @Override
    @NotNull
    public CompletableFuture<Void> sendMessage(@NotNull MimeMessage message) {
        return CompletableFuture.runAsync(() -> this.send(message), runnable -> this.threadPool.submit(runnable));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void send(@NotNull MimeMessage message) {
        try {
            ClassLoader tccl = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            String password = this.cryptoService.decrypt(this.configuration.password());
            try (Transport transport = this.session.getTransport(SMTPS_PROTOCOL);){
                List<ConnectionListener> connectionListeners = this.connectionListeners;
                connectionListeners.forEach(arg_0 -> ((Transport)transport).addConnectionListener(arg_0));
                List<TransportListener> transportListeners = this.transportListeners;
                transportListeners.forEach(arg_0 -> ((Transport)transport).addTransportListener(arg_0));
                transport.connect(this.configuration.mail_smtps_host(), this.configuration.mail_smtps_port(), this.configuration.username(), password);
                message.saveChanges();
                MessageIdProvider messageIdProvider = this.messageIdProvider;
                if (messageIdProvider != null) {
                    String messageId = messageIdProvider.getMessageId(message);
                    message.setHeader(MESSAGE_ID_HEADER, String.format("<%s>", messageId));
                }
                this.logger.debug("sending message '{}'", (Object)message.getMessageID());
                transport.sendMessage((Message)message, message.getAllRecipients());
            }
            finally {
                Thread.currentThread().setContextClassLoader(tccl);
            }
        }
        catch (MessagingException e) {
            throw new CompletionException(e);
        }
    }
}

