/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.commons.messaging.mail.internal;

import java.util.UUID;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.apache.sling.commons.messaging.mail.MessageIdProvider;
import org.apache.sling.commons.messaging.mail.internal.SimpleMessageIdProviderConfiguration;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.metatype.annotations.Designate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(property={"service.description=Apache Sling Commons Messaging Mail \u2013 Simple Message ID Provider", "service.vendor=The Apache Software Foundation"})
@Designate(ocd=SimpleMessageIdProviderConfiguration.class, factory=true)
public class SimpleMessageIdProvider
implements MessageIdProvider {
    private SimpleMessageIdProviderConfiguration configuration;
    private final Logger logger = LoggerFactory.getLogger(SimpleMessageIdProvider.class);

    @Activate
    private void activate(SimpleMessageIdProviderConfiguration configuration) {
        this.logger.debug("activating");
        this.configuration = configuration;
    }

    @Modified
    private void modified(SimpleMessageIdProviderConfiguration configuration) {
        this.logger.debug("modifying");
        this.configuration = configuration;
    }

    @Deactivate
    private void deactivate() {
        this.logger.debug("deactivating");
        this.configuration = null;
    }

    @Override
    @NotNull
    public String getMessageId(@NotNull MimeMessage message) throws MessagingException {
        return String.format("%s.%s@%s", UUID.randomUUID().toString(), System.currentTimeMillis(), this.configuration.host());
    }
}

