/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.commons.testing.jcr;

import javax.jcr.RepositoryException;
import org.apache.sling.commons.testing.jcr.RepositoryUtil;
import org.apache.sling.jcr.api.SlingRepository;

public class RepositoryProvider {
    private static RepositoryProvider INSTANCE;
    private SlingRepository repository;

    private RepositoryProvider() {
    }

    public static synchronized RepositoryProvider instance() {
        if (INSTANCE == null) {
            INSTANCE = new RepositoryProvider();
        }
        return INSTANCE;
    }

    public synchronized SlingRepository getRepository() throws RepositoryException {
        if (this.repository == null) {
            RepositoryUtil.startRepository();
            this.repository = RepositoryUtil.getRepository();
            Runtime.getRuntime().addShutdownHook(new ShutdownThread());
        }
        return this.repository;
    }

    private static class ShutdownThread
    extends Thread {
        private ShutdownThread() {
        }

        public void run() {
            try {
                RepositoryUtil.stopRepository();
            }
            catch (Exception e) {
                System.out.println("Exception in ShutdownThread:" + e);
            }
        }
    }
}

